/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.wml;

import com.xmlmind.fo.converter.wml.Borders;
import com.xmlmind.fo.converter.wml.Footer;
import com.xmlmind.fo.converter.wml.Header;
import com.xmlmind.fo.converter.wml.Wml;
import com.xmlmind.fo.objects.PageSequence;
import com.xmlmind.fo.objects.Region;
import com.xmlmind.fo.objects.SimplePageMaster;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;

public class Section {
    public static final String FORMAT_DECIMAL = "decimal";
    public static final String FORMAT_LOWERCASE_LETTER = "lower-letter";
    public static final String FORMAT_UPPERCASE_LETTER = "upper-letter";
    public static final String FORMAT_LOWERCASE_ROMAN = "lower-roman";
    public static final String FORMAT_UPPERCASE_ROMAN = "upper-roman";
    public int pageWidth;
    public int pageHeight;
    public int marginTop;
    public int marginBottom;
    public int marginLeft;
    public int marginRight;
    public int headerOffset = 720;
    public int footerOffset = 720;
    public int columnCount;
    public int columnGap;
    public int columnWidth;
    public int contentWidth;
    public Borders borders;
    public boolean titlePage;
    public boolean mirrorMargins;
    public boolean isLast;
    public int startPageNumber;
    public String numberFormat;
    public Header headerOdd;
    public Header headerEven;
    public Header headerFirst;
    public Footer footerOdd;
    public Footer footerEven;
    public Footer footerFirst;

    public Section() {
    }

    public Section(SimplePageMaster simplePageMaster, SimplePageMaster simplePageMaster2, SimplePageMaster simplePageMaster3, PageSequence pageSequence) {
        this();
        this.initialize(simplePageMaster, simplePageMaster2, simplePageMaster3, pageSequence);
    }

    public void initialize(SimplePageMaster simplePageMaster, SimplePageMaster simplePageMaster2, SimplePageMaster simplePageMaster3, PageSequence pageSequence) {
        int n;
        int n2;
        char c = '1';
        Region region = simplePageMaster.regions[0];
        if (simplePageMaster.pageWidth.type == 4) {
            this.pageWidth = Wml.toTwips(simplePageMaster.pageWidth.length());
        }
        if (simplePageMaster.pageHeight.type == 4) {
            this.pageHeight = Wml.toTwips(simplePageMaster.pageHeight.length());
        }
        this.marginTop = Section.length(simplePageMaster.marginTop);
        this.marginBottom = Section.length(simplePageMaster.marginBottom);
        this.marginLeft = Section.length(simplePageMaster.marginLeft);
        this.marginRight = Section.length(simplePageMaster.marginRight);
        if (this.marginTop > 0) {
            this.headerOffset = this.marginTop;
        }
        if (this.marginBottom > 0) {
            this.footerOffset = this.marginBottom;
        }
        this.marginTop += Section.length(region.marginTop);
        this.marginBottom += Section.length(region.marginBottom);
        this.marginLeft += Section.length(region.marginLeft);
        this.marginRight += Section.length(region.marginRight);
        this.marginTop += Section.length(region.paddingTop);
        this.marginBottom += Section.length(region.paddingBottom);
        this.marginLeft += Section.length(region.paddingLeft);
        this.marginRight += Section.length(region.paddingRight);
        this.contentWidth = this.pageWidth - (this.marginLeft + this.marginRight);
        this.columnCount = region.columnCount;
        this.columnGap = Section.length(region.columnGap);
        this.columnWidth = this.contentWidth;
        if (this.columnCount > 1) {
            this.columnWidth -= (this.columnCount - 1) * this.columnGap;
            this.columnWidth /= this.columnCount;
        }
        if (simplePageMaster2 != null) {
            n2 = Section.length(simplePageMaster2.marginLeft);
            n = Section.length(simplePageMaster2.marginRight);
            region = simplePageMaster2.regions[0];
            n2 += Section.length(region.marginLeft);
            n += Section.length(region.marginRight);
            if ((n2 += Section.length(region.paddingLeft)) == this.marginRight && (n += Section.length(region.paddingRight)) == this.marginLeft) {
                this.mirrorMargins = true;
            }
        }
        this.borders = new Borders(region.properties);
        if (simplePageMaster3 != null) {
            this.titlePage = true;
        }
        if (pageSequence.initialPageNumber > 0) {
            this.startPageNumber = pageSequence.initialPageNumber;
        }
        n = pageSequence.format.length();
        for (n2 = 0; n2 < n && !Character.isLetterOrDigit(c = (char)pageSequence.format.charAt(n2)); ++n2) {
        }
        switch (c) {
            default: {
                this.numberFormat = FORMAT_DECIMAL;
                break;
            }
            case 'a': {
                this.numberFormat = FORMAT_LOWERCASE_LETTER;
                break;
            }
            case 'A': {
                this.numberFormat = FORMAT_UPPERCASE_LETTER;
                break;
            }
            case 'i': {
                this.numberFormat = FORMAT_LOWERCASE_ROMAN;
                break;
            }
            case 'I': {
                this.numberFormat = FORMAT_UPPERCASE_ROMAN;
            }
        }
    }

    public void start(PrintWriter printWriter, Encoder encoder) {
    }

    public void end(PrintWriter printWriter, Encoder encoder) throws Exception {
        if (!this.isLast) {
            printWriter.println("<w:p>");
            printWriter.println("<w:pPr>");
        }
        printWriter.println("<w:sectPr>");
        if (this.headerOdd != null) {
            this.headerOdd.print(printWriter, encoder);
        }
        if (this.headerEven != null) {
            this.headerEven.print(printWriter, encoder);
        }
        if (this.headerFirst != null) {
            this.headerFirst.print(printWriter, encoder);
        }
        if (this.footerOdd != null) {
            this.footerOdd.print(printWriter, encoder);
        }
        if (this.footerEven != null) {
            this.footerEven.print(printWriter, encoder);
        }
        if (this.footerFirst != null) {
            this.footerFirst.print(printWriter, encoder);
        }
        printWriter.print("<w:pgSz");
        printWriter.print(" w:w=\"" + this.pageWidth + "\"");
        printWriter.print(" w:h=\"" + this.pageHeight + "\"");
        if (this.pageWidth > this.pageHeight) {
            printWriter.print(" w:orient=\"landscape\"");
        }
        printWriter.println(" />");
        printWriter.print("<w:pgMar");
        printWriter.print(" w:top=\"" + this.marginTop + "\"");
        printWriter.print(" w:bottom=\"" + this.marginBottom + "\"");
        printWriter.print(" w:left=\"" + this.marginLeft + "\"");
        printWriter.print(" w:right=\"" + this.marginRight + "\"");
        printWriter.print(" w:header=\"" + this.headerOffset + "\"");
        printWriter.print(" w:footer=\"" + this.footerOffset + "\"");
        printWriter.print(" w:gutter=\"0\"");
        printWriter.println(" />");
        if (this.borders.materialized()) {
            printWriter.print("<w:pgBorders>");
            this.borders.print(printWriter);
            printWriter.println("</w:pgBorders>");
        }
        printWriter.print("<w:pgNumType");
        printWriter.print(" w:fmt=\"" + this.numberFormat + "\"");
        if (this.startPageNumber > 0) {
            printWriter.print(" w:start=\"" + this.startPageNumber + "\"");
        }
        printWriter.println(" />");
        if (this.columnCount > 1) {
            printWriter.print("<w:cols");
            printWriter.print(" w:num=\"" + this.columnCount + "\"");
            printWriter.print(" w:space=\"" + this.columnGap + "\"");
            printWriter.println(" />");
        }
        if (this.titlePage) {
            printWriter.println("<w:titlePg />");
        }
        printWriter.println("</w:sectPr>");
        if (!this.isLast) {
            printWriter.println("</w:pPr>");
            printWriter.println("</w:p>");
        }
    }

    private static int length(Value value) {
        int n = 0;
        if (value.type == 4) {
            n = Wml.toTwips(value.length());
        }
        return n;
    }
}

