/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.wml;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.wml.Bookmark;
import com.xmlmind.fo.converter.wml.Border;
import com.xmlmind.fo.converter.wml.Borders;
import com.xmlmind.fo.converter.wml.Paragraph;
import com.xmlmind.fo.converter.wml.TableAndCaption;
import com.xmlmind.fo.converter.wml.TableCell;
import com.xmlmind.fo.converter.wml.TableColumn;
import com.xmlmind.fo.converter.wml.TableGroup;
import com.xmlmind.fo.converter.wml.TableRow;
import com.xmlmind.fo.converter.wml.Wml;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;
import java.util.Vector;

public class Table {
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_CENTER = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    private int breakBefore;
    private int spaceBefore;
    private boolean keepTogether;
    private int tableLayout;
    private int borderCollapse;
    private int rowSpacing;
    private int columnSpacing;
    private int width;
    private double percentage;
    private int startIndent;
    private int endIndent;
    private Borders borders;
    private Color background;
    private int alignment = 0;
    private int tableIndent;
    private int numColumns;
    private Vector columns = new Vector();
    private Vector groups = new Vector();
    private boolean hasFooter;
    private boolean requiresLayout;
    private boolean isNested;
    private TableGroup group;
    private TableRow row;
    private TableCell cell;
    private TableRow[] rows;
    private int maxWidth;
    private int[] columnWidths;
    private int[][] borderWidths;

    public Table() {
    }

    public Table(Context context) {
        this();
        this.initialize(context);
    }

    public void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        this.breakBefore = context.breakBefore;
        this.spaceBefore = Wml.toTwips(context.spaceBefore());
        this.keepTogether = Table.keep(valueArray[137]);
        this.tableLayout = valueArray[283].keyword();
        this.borderCollapse = valueArray[37].keyword();
        if (this.borderCollapse == 177) {
            int n = 54;
            int n2 = 55;
            this.rowSpacing = Table.length(valueArray[n]);
            this.columnSpacing = Table.length(valueArray[n2]);
            this.columnSpacing = this.rowSpacing = Math.min(this.rowSpacing, this.columnSpacing);
        }
        Value value = valueArray[308];
        switch (value.type) {
            case 4: {
                this.width = Wml.toTwips(value.length());
                break;
            }
            case 13: {
                this.percentage = value.percentage();
            }
        }
        this.startIndent = Table.length(valueArray[277]);
        this.endIndent = Table.length(valueArray[97]);
        this.borders = new Borders(valueArray);
        this.borders.top.space = 0;
        this.borders.bottom.space = 0;
        this.borders.left.space = 0;
        this.borders.right.space = 0;
        this.background = context.background;
    }

    private static int length(Value value) {
        int n = 0;
        if (value.type == 4) {
            n = Wml.toTwips(value.length());
        }
        return n;
    }

    private static boolean keep(Value value) {
        boolean bl = false;
        switch (value.type) {
            case 1: {
                if (value.keyword() != 8) break;
                bl = true;
                break;
            }
            case 2: {
                if (value.integer() <= 0) break;
                bl = true;
            }
        }
        return bl;
    }

    public void setColumn(Context context) {
        TableColumn tableColumn = new TableColumn(context);
        this.columns.addElement(tableColumn);
        int n = tableColumn.number + tableColumn.repeat * tableColumn.span - 1;
        if (n > this.numColumns) {
            this.numColumns = n;
        }
    }

    public void startHeader(Context context) {
        this.startGroup(context, true);
    }

    private void startGroup(Context context) {
        this.startGroup(context, false);
    }

    private void startGroup(Context context, boolean bl) {
        this.group = new TableGroup(bl, context);
    }

    public void endHeader() {
        this.endGroup();
    }

    private void endGroup() {
        if (this.row != null) {
            this.endRow();
        }
        if (this.hasFooter) {
            this.groups.insertElementAt(this.group, this.groups.size() - 1);
        } else {
            this.groups.addElement(this.group);
        }
        this.group = null;
    }

    public void startBody(Context context) {
        this.startGroup(context);
    }

    public void endBody() {
        this.endGroup();
    }

    public void startFooter(Context context) {
        this.startGroup(context);
    }

    public void endFooter() {
        this.endGroup();
        this.hasFooter = true;
    }

    public void startRow(Context context, Vector vector) {
        this.row = new TableRow(context);
        if (vector != null) {
            this.row.bookmarks = new Bookmark[vector.size()];
            for (int i = 0; i < this.row.bookmarks.length; ++i) {
                this.row.bookmarks[i] = (Bookmark)vector.elementAt(i);
            }
        }
        this.group.add(this.row);
    }

    public void endRow() {
        this.row = null;
    }

    public void startCell(Context context) {
        this.cell = new TableCell(context);
        if (this.cell.startsRow || this.row == null) {
            if (this.row != null) {
                this.endRow();
            }
            this.row = new TableRow();
            this.row.borders = new Borders();
            this.group.add(this.row);
        }
        this.row.add(this.cell);
        int n = this.cell.columnNumber + this.cell.columnSpan - 1;
        if (n > this.numColumns) {
            this.numColumns = n;
        }
    }

    public void endCell() {
        if (this.cell.endsRow) {
            this.endRow();
        }
        this.cell = null;
    }

    public void add(Paragraph paragraph) {
        this.cell.add(paragraph);
        if (paragraph.hasPicture) {
            this.requiresLayout = true;
        }
    }

    public void add(Table table) {
        table.isNested = true;
        this.cell.add(table);
        this.requiresLayout = true;
    }

    public void add(TableAndCaption tableAndCaption) {
        if (tableAndCaption.table != null) {
            tableAndCaption.table.isNested = true;
        }
        this.cell.add(tableAndCaption);
        this.requiresLayout = true;
    }

    public void layout(int n) throws Exception {
        if (this.columnWidths != null) {
            return;
        }
        this.maxWidth = n - (this.startIndent + this.endIndent);
        if (this.percentage > 0.0) {
            this.width = (int)((double)this.maxWidth * this.percentage / 100.0);
        }
        if (this.rows == null) {
            this.rows = this.expandRowSpans();
            if (this.rows == null) {
                return;
            }
        }
        if (this.borderWidths == null) {
            this.layoutBorders();
        }
        this.setTableLayout();
        this.columnWidths = this.tableLayout == 69 ? this.fixedLayout() : this.automaticLayout();
        if (this.requiresLayout) {
            this.layoutCells();
        }
        this.expandColumnSpans();
        this.setCells();
        this.setRows();
        this.setTableIndent();
    }

    public void layout(int n, int n2) throws Exception {
        this.alignment = n2;
        this.layout(n);
    }

    public void print(PrintWriter printWriter, Encoder encoder) throws Exception {
        int n;
        if (this.columnWidths == null) {
            return;
        }
        if (this.rows == null) {
            return;
        }
        if (this.spaceBefore > 0) {
            n = this.spaceBefore / 10;
            if (n == 0) {
                n = 1;
            }
            Paragraph paragraph = Paragraph.empty(n);
            paragraph.print(printWriter);
        }
        printWriter.println("<w:tbl>");
        printWriter.print("<w:tblPr>");
        if (this.rowSpacing > 0) {
            printWriter.print("<w:tblCellSpacing");
            printWriter.print(" w:w=\"" + this.rowSpacing / 2 + "\"");
            printWriter.print(" w:type=\"dxa\"");
            printWriter.print(" />");
        }
        if (this.tableIndent != 0) {
            printWriter.print("<w:tblInd");
            printWriter.print(" w:w=\"" + this.tableIndent + "\"");
            printWriter.print(" w:type=\"dxa\"");
            printWriter.print(" />");
        }
        if (this.background != null) {
            printWriter.print("<w:shd");
            printWriter.print(" w:val=\"clear\"");
            printWriter.print(" w:fill=\"" + Wml.hexColorType(this.background) + "\"");
            printWriter.print(" />");
        }
        if (this.borderCollapse == 177 && this.borders != null && this.borders.materialized()) {
            printWriter.print("<w:tblBorders>");
            this.borders.print(printWriter);
            printWriter.print("</w:tblBorders>");
        }
        printWriter.print("<w:tblLayout w:type=\"Fixed\" />");
        printWriter.println("</w:tblPr>");
        printWriter.print("<w:tblGrid>");
        for (n = 0; n < this.numColumns; ++n) {
            int n2 = this.columnWidths[n];
            if (this.borderCollapse == 177) {
                n2 += this.borderWidths[n][0];
                n2 += this.borderWidths[n][1];
                n2 += this.columnSpacing;
            }
            printWriter.print("<w:gridCol w:w=\"" + n2 + "\" />");
        }
        printWriter.println("</w:tblGrid>");
        int n3 = this.groups.size();
        for (n = 0; n < n3; ++n) {
            TableGroup tableGroup = (TableGroup)this.groups.elementAt(n);
            tableGroup.print(printWriter, encoder);
        }
        printWriter.println("</w:tbl>");
    }

    private void layoutBorders() {
        if (this.borderWidths != null) {
            return;
        }
        if (this.rows == null) {
            this.rows = this.expandRowSpans();
            if (this.rows == null) {
                return;
            }
        }
        if (this.borderCollapse == 177) {
            this.setSeparateBorders();
        } else {
            this.setCollapsedBorders();
        }
        this.setBorderWidths();
    }

    private TableRow[] expandRowSpans() {
        int n = this.groups.size();
        for (int i = 0; i < n; ++i) {
            TableGroup tableGroup = (TableGroup)this.groups.elementAt(i);
            int n2 = tableGroup.size();
            for (int j = 0; j < n2; ++j) {
                TableRow tableRow = tableGroup.get(j);
                int n3 = tableRow.size();
                for (int k = 0; k < n3; ++k) {
                    TableCell tableCell = tableRow.get(k);
                    if (tableCell.rowSpan == 1) continue;
                    int n4 = j + tableCell.rowSpan;
                    for (int i2 = j + 1; i2 < n4; ++i2) {
                        TableRow tableRow2;
                        if (i2 >= tableGroup.size()) {
                            tableRow2 = new TableRow();
                            tableRow2.borders = new Borders();
                            tableGroup.add(tableRow2);
                        } else {
                            tableRow2 = tableGroup.get(i2);
                        }
                        TableCell tableCell2 = tableCell.copy();
                        tableCell2.rowSpan = 1;
                        tableCell2.vMerge = "continue";
                        tableCell2.borders.top.style = 75;
                        tableCell2.borders.top.width = 0;
                        tableCell2.marginTop = 0;
                        if (i2 < n4 - 1) {
                            tableCell2.borders.bottom.style = 75;
                            tableCell2.borders.bottom.width = 0;
                            tableCell2.marginBottom = 0;
                        }
                        tableRow2.add(tableCell2);
                    }
                    tableCell.rowSpan = 1;
                    tableCell.vMerge = "restart";
                    tableCell.borders.bottom.style = 75;
                    tableCell.borders.bottom.width = 0;
                    tableCell.marginBottom = 0;
                }
            }
        }
        return this.rows();
    }

    private void layoutCells() throws Exception {
        for (int i = 0; i < this.rows.length; ++i) {
            int n = this.rows[i].size();
            for (int j = 0; j < n; ++j) {
                TableCell tableCell = this.rows[i].get(j);
                if (!tableCell.requiresLayout()) continue;
                int n2 = tableCell.columnNumber - 1;
                int n3 = tableCell.columnSpan;
                int n4 = 0;
                if (n3 > 1) {
                    for (int k = 0; k < n3; ++k) {
                        n4 += this.columnWidths[n2 + k];
                    }
                    if (this.borderCollapse == 177) {
                        n4 += (n3 - 1) * this.columnSpacing;
                    }
                } else {
                    n4 = this.columnWidths[n2];
                }
                n4 -= tableCell.marginLeft;
                tableCell.layout(n4 -= tableCell.marginRight);
            }
        }
    }

    private void expandColumnSpans() {
        for (int i = 0; i < this.rows.length; ++i) {
            int n = this.rows[i].size();
            for (int j = 0; j < n; ++j) {
                TableCell tableCell = this.rows[i].get(j);
                if (tableCell.columnSpan == 1) continue;
                int n2 = tableCell.columnSpan;
                for (int k = 1; k < n2; ++k) {
                    TableCell tableCell2 = tableCell.copy();
                    tableCell2.columnNumber = tableCell.columnNumber + k;
                    tableCell2.columnSpan = 1;
                    tableCell2.hMerge = "continue";
                    tableCell2.borders.left.style = 75;
                    tableCell2.borders.left.width = 0;
                    tableCell2.marginLeft = 0;
                    if (k < n2 - 1) {
                        tableCell2.borders.right.style = 75;
                        tableCell2.borders.right.width = 0;
                        tableCell2.marginRight = 0;
                    }
                    this.rows[i].add(tableCell2);
                }
                tableCell.columnSpan = 1;
                tableCell.hMerge = "restart";
                tableCell.borders.right.style = 75;
                tableCell.borders.right.width = 0;
                tableCell.marginRight = 0;
            }
        }
    }

    private void setSeparateBorders() {
        for (int i = 0; i < this.rows.length; ++i) {
            this.rows[i].borders.left = this.borders.left;
            this.rows[i].borders.right = this.borders.right;
            this.rows[i].borders.top.style = 75;
            this.rows[i].borders.bottom.style = 75;
        }
        this.rows[0].borders.top = this.borders.top;
        this.rows[this.rows.length - 1].borders.bottom = this.borders.bottom;
    }

    private void setCollapsedBorders() {
        Vector<Border> vector = new Vector<Border>();
        Border border = null;
        TableColumn[] tableColumnArray = this.columns();
        int n = this.groups.size();
        for (int i = 0; i < n; ++i) {
            TableGroup tableGroup = (TableGroup)this.groups.elementAt(i);
            int n2 = tableGroup.size();
            for (int j = 0; j < n2; ++j) {
                TableRow tableRow = tableGroup.get(j);
                int n3 = tableRow.size();
                for (int k = 0; k < n3; ++k) {
                    TableColumn tableColumn;
                    Border border2;
                    int n4;
                    int n5;
                    TableCell tableCell = tableRow.get(k);
                    if (tableCell.borders.top.style != 75) {
                        border = null;
                        vector.setSize(0);
                        vector.addElement(tableRow.borders.top);
                        if (j == 0) {
                            vector.addElement(tableGroup.borders.top);
                            if (i == 0) {
                                vector.addElement(this.borders.top);
                            }
                        }
                        n5 = vector.size();
                        for (n4 = 0; n4 < n5; ++n4) {
                            border2 = (Border)vector.elementAt(n4);
                            if (border2.style == 125) continue;
                            border = border2;
                            if (border2.style == 75) break;
                        }
                        if (border != null) {
                            tableCell.borders.top.style = border.style;
                            tableCell.borders.top.width = border.width;
                            tableCell.borders.top.color = border.color;
                        }
                    }
                    if (tableCell.borders.bottom.style != 75) {
                        border = null;
                        vector.setSize(0);
                        vector.addElement(tableRow.borders.bottom);
                        if (j == n2 - 1) {
                            vector.addElement(tableGroup.borders.bottom);
                            if (i == n - 1) {
                                vector.addElement(this.borders.bottom);
                            }
                        }
                        n5 = vector.size();
                        for (n4 = 0; n4 < n5; ++n4) {
                            border2 = (Border)vector.elementAt(n4);
                            if (border2.style == 125) continue;
                            border = border2;
                            if (border2.style == 75) break;
                        }
                        if (border != null) {
                            tableCell.borders.bottom.style = border.style;
                            tableCell.borders.bottom.width = border.width;
                            tableCell.borders.bottom.color = border.color;
                        }
                    }
                    if (tableCell.borders.left.style != 75) {
                        border = null;
                        vector.setSize(0);
                        tableColumn = tableColumnArray[tableCell.columnNumber];
                        if (tableColumn != null && tableColumn.number == tableCell.columnNumber) {
                            vector.addElement(tableColumn.borders.left);
                        }
                        if (tableCell.columnNumber == 1) {
                            vector.addElement(this.borders.left);
                        }
                        n5 = vector.size();
                        for (n4 = 0; n4 < n5; ++n4) {
                            border2 = (Border)vector.elementAt(n4);
                            if (border2.style == 125) continue;
                            border = border2;
                            if (border2.style == 75) break;
                        }
                        if (border != null) {
                            tableCell.borders.left.style = border.style;
                            tableCell.borders.left.width = border.width;
                            tableCell.borders.left.color = border.color;
                        }
                    }
                    if (tableCell.borders.right.style == 75) continue;
                    border = null;
                    vector.setSize(0);
                    n4 = tableCell.columnNumber + tableCell.columnSpan - 1;
                    tableColumn = tableColumnArray[n4];
                    if (tableColumn != null && (n5 = tableColumn.number + tableColumn.repeat * tableColumn.span - 1) == n4) {
                        vector.addElement(tableColumn.borders.right);
                    }
                    if (n4 == this.numColumns) {
                        vector.addElement(this.borders.right);
                    }
                    int n6 = vector.size();
                    for (n5 = 0; n5 < n6; ++n5) {
                        Border border3 = (Border)vector.elementAt(n5);
                        if (border3.style == 125) continue;
                        border = border3;
                        if (border3.style == 75) break;
                    }
                    if (border == null) continue;
                    tableCell.borders.right.style = border.style;
                    tableCell.borders.right.width = border.width;
                    tableCell.borders.right.color = border.color;
                }
                tableRow.borders = null;
            }
        }
    }

    private void setBorderWidths() {
        this.borderWidths = new int[this.numColumns][2];
        for (int i = 0; i < this.rows.length; ++i) {
            int n = this.rows[i].size();
            for (int j = 0; j < n; ++j) {
                TableCell tableCell = this.rows[i].get(j);
                int n2 = tableCell.columnNumber - 1;
                if (tableCell.borders.left.width > this.borderWidths[n2][0]) {
                    this.borderWidths[n2][0] = tableCell.borders.left.width;
                }
                if (tableCell.borders.right.width <= this.borderWidths[n2 += tableCell.columnSpan - 1][1]) continue;
                this.borderWidths[n2][1] = tableCell.borders.right.width;
            }
        }
    }

    private void setTableLayout() {
        int n;
        int n2 = this.width > 0 ? this.width : this.maxWidth;
        TableColumn[] tableColumnArray = this.columns();
        for (n = 1; n <= this.numColumns; ++n) {
            if (tableColumnArray[n] == null) continue;
            tableColumnArray[n].setReference(n2);
        }
        if (this.tableLayout == 69) {
            for (n = 1; n <= this.numColumns; ++n) {
                if (tableColumnArray[n] == null) {
                    this.tableLayout = 10;
                } else {
                    if (tableColumnArray[n].width != 0 || tableColumnArray[n].proportion != 0.0) continue;
                    this.tableLayout = 10;
                }
                break;
            }
        } else {
            n = 1;
            for (int i = 1; i <= this.numColumns; ++i) {
                if (tableColumnArray[i] == null) {
                    n = 0;
                    break;
                }
                if (tableColumnArray[i].width != 0 || tableColumnArray[i].proportion != 0.0) continue;
                n = 0;
                break;
            }
            if (n != 0) {
                this.tableLayout = 69;
            }
        }
    }

    private int[] fixedLayout() {
        int n;
        int[] nArray = new int[this.numColumns];
        TableColumn[] tableColumnArray = this.columns();
        int n2 = this.width > 0 ? this.width : this.maxWidth;
        double d = 0.0;
        if (this.borderCollapse == 177) {
            n2 -= (this.numColumns + 1) * this.columnSpacing;
        }
        for (n = 0; n < this.numColumns; ++n) {
            if (tableColumnArray[n + 1].proportion > 0.0) {
                d += tableColumnArray[n + 1].proportion;
                nArray[n] = 0;
                continue;
            }
            nArray[n] = tableColumnArray[n + 1].width;
            n2 -= nArray[n];
        }
        if (d > 0.0) {
            for (n = 0; n < this.numColumns; ++n) {
                if (nArray[n] != 0) continue;
                double d2 = (double)n2 * tableColumnArray[n + 1].proportion / d;
                nArray[n] = (int)Math.round(d2);
            }
        }
        return nArray;
    }

    private int[] automaticLayout() {
        int[] nArray;
        int n;
        int n2;
        int n3;
        TableCell tableCell;
        int n4;
        int n5;
        int n6;
        int n7;
        int[] nArray2 = new int[this.numColumns];
        int[] nArray3 = new int[this.numColumns];
        int n8 = 0;
        TableColumn[] tableColumnArray = this.columns();
        for (n7 = 0; n7 < this.numColumns; ++n7) {
            TableColumn tableColumn = tableColumnArray[n7 + 1];
            if (tableColumn == null || tableColumn.width <= 0) continue;
            nArray2[n7] = tableColumn.width / tableColumn.span;
            nArray3[n7] = nArray2[n7];
        }
        n7 = this.width > 0 ? this.width : this.maxWidth;
        for (n6 = 0; n6 < this.rows.length; ++n6) {
            n5 = this.rows[n6].size();
            for (n4 = 0; n4 < n5; ++n4) {
                tableCell = this.rows[n6].get(n4);
                if (tableCell.columnSpan != 1) continue;
                tableCell.setReference(n7);
                n3 = tableCell.columnNumber - 1;
                n2 = tableCell.minWidth();
                if (n2 > nArray2[n3]) {
                    nArray2[n3] = n2;
                }
                if ((n = tableCell.maxWidth()) <= nArray3[n3]) continue;
                nArray3[n3] = n;
            }
        }
        for (n6 = 0; n6 < this.rows.length; ++n6) {
            n5 = this.rows[n6].size();
            for (n4 = 0; n4 < n5; ++n4) {
                int n9;
                int n10;
                tableCell = this.rows[n6].get(n4);
                if (tableCell.columnSpan < 2) continue;
                tableCell.setReference(n7);
                n3 = tableCell.columnNumber - 1;
                n2 = 0;
                for (n = 0; n < tableCell.columnSpan; ++n) {
                    n2 += nArray2[n3 + n];
                }
                n = tableCell.minWidth();
                if (n > n2) {
                    n10 = (n - n2) / tableCell.columnSpan;
                    if (n10 == 0) {
                        n10 = 1;
                    }
                    for (n9 = 0; n9 < tableCell.columnSpan; ++n9) {
                        int n11 = n3 + n9;
                        nArray2[n11] = nArray2[n11] + n10;
                    }
                }
                n2 = 0;
                for (n10 = 0; n10 < tableCell.columnSpan; ++n10) {
                    n2 += nArray3[n3 + n10];
                }
                n = tableCell.maxWidth();
                if (n <= n2) continue;
                n10 = (n - n2) / tableCell.columnSpan;
                if (n10 == 0) {
                    n10 = 1;
                }
                for (n9 = 0; n9 < tableCell.columnSpan; ++n9) {
                    int n12 = n3 + n9;
                    nArray3[n12] = nArray3[n12] + n10;
                }
            }
        }
        if (this.borderCollapse == 177) {
            n8 = (this.numColumns + 1) * this.columnSpacing;
            for (n6 = 0; n6 < this.numColumns; ++n6) {
                n8 += this.borderWidths[n6][0];
                n8 += this.borderWidths[n6][1];
            }
            n8 += this.borders.left.width;
            n8 += this.borders.right.width;
        } else {
            n8 = this.borderWidths[0][0];
            n8 += this.borderWidths[this.numColumns - 1][1];
            for (n6 = 1; n6 < this.numColumns; ++n6) {
                n4 = this.borderWidths[n6 - 1][1];
                n5 = this.borderWidths[n6][0];
                n8 += Math.max(n4, n5);
            }
        }
        if (this.width != 0) {
            n6 = n8;
            for (n4 = 0; n4 < this.numColumns; ++n4) {
                n6 += nArray2[n4];
            }
            if (this.width > n6) {
                n4 = this.width - n6;
                nArray = this.distribute(n4, nArray2, nArray3);
            } else if (this.width < n6) {
                n4 = n6 - this.width;
                nArray = this.shrink(n4, nArray2);
            } else {
                nArray = nArray2;
            }
        } else {
            n6 = this.maxWidth;
            n4 = n8;
            for (n5 = 0; n5 < this.numColumns; ++n5) {
                n4 += nArray3[n5];
            }
            if (n4 > n6) {
                int n13;
                n5 = n8;
                for (n13 = 0; n13 < this.numColumns; ++n13) {
                    n5 += nArray2[n13];
                }
                if (n6 > n5) {
                    n13 = n6 - n5;
                    nArray = this.distribute(n13, nArray2, nArray3);
                } else if (n6 < n5) {
                    n13 = n5 - n6;
                    nArray = this.shrink(n13, nArray2);
                } else {
                    nArray = nArray2;
                }
            } else {
                nArray = nArray3;
            }
        }
        for (n6 = 0; n6 < this.numColumns; ++n6) {
            int n14 = n6;
            nArray[n14] = nArray[n14] + this.borderWidths[n6][0] / 2;
            int n15 = n6;
            nArray[n15] = nArray[n15] + this.borderWidths[n6][1] / 2;
        }
        return nArray;
    }

    private int[] distribute(int n, int[] nArray, int[] nArray2) {
        int n2;
        int[] nArray3 = new int[this.numColumns];
        int n3 = 0;
        for (n2 = 0; n2 < this.numColumns; ++n2) {
            nArray3[n2] = nArray[n2];
            if (nArray3[n2] >= nArray2[n2]) continue;
            ++n3;
        }
        while (n > 0) {
            int n4;
            if (n3 == 0) {
                n4 = n / this.numColumns;
                n2 = 0;
                while (n2 < this.numColumns) {
                    int n5 = n2++;
                    nArray3[n5] = nArray3[n5] + n4;
                }
                n = 0;
                continue;
            }
            n4 = n / n3;
            n3 = 0;
            n = 0;
            for (n2 = 0; n2 < this.numColumns; ++n2) {
                if (nArray3[n2] < nArray2[n2]) {
                    int n6 = n2;
                    nArray3[n6] = nArray3[n6] + n4;
                }
                if (nArray3[n2] > nArray2[n2]) {
                    n += nArray3[n2] - nArray2[n2];
                    nArray3[n2] = nArray2[n2];
                    continue;
                }
                if (nArray3[n2] >= nArray2[n2]) continue;
                ++n3;
            }
        }
        return nArray3;
    }

    private int[] shrink(int n, int[] nArray) {
        int n2;
        int n3 = nArray[0];
        int n4 = nArray[0];
        int n5 = 0;
        int[] nArray2 = new int[this.numColumns];
        for (n2 = 1; n2 < this.numColumns; ++n2) {
            if (nArray[n2] < n3) {
                n3 = nArray[n2];
                continue;
            }
            if (nArray[n2] <= n4) continue;
            n4 = nArray[n2];
        }
        int n6 = (n3 + n4) / 2;
        for (n2 = 0; n2 < this.numColumns; ++n2) {
            if (nArray[n2] < n6) continue;
            n5 += nArray[n2];
        }
        for (n2 = 0; n2 < this.numColumns; ++n2) {
            if (nArray[n2] >= n6) {
                nArray2[n2] = nArray[n2] - n * nArray[n2] / n5;
                if (nArray2[n2] > 0) continue;
                nArray2[n2] = nArray[n2];
                continue;
            }
            nArray2[n2] = nArray[n2];
        }
        return nArray2;
    }

    private void setCells() {
        TableColumn[] tableColumnArray = this.columns();
        int n = this.groups.size();
        for (int i = 0; i < n; ++i) {
            TableGroup tableGroup = (TableGroup)this.groups.elementAt(i);
            int n2 = tableGroup.size();
            for (int j = 0; j < n2; ++j) {
                int n3;
                TableRow tableRow = tableGroup.get(j);
                TableCell[] tableCellArray = new TableCell[this.numColumns];
                int n4 = tableRow.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    TableCell tableCell;
                    tableCellArray[tableCell.columnNumber - 1] = tableCell = tableRow.get(n3);
                }
                tableRow.cells.setSize(0);
                for (n3 = 0; n3 < this.numColumns; ++n3) {
                    if (tableCellArray[n3] == null) {
                        tableCellArray[n3] = new TableCell();
                        tableCellArray[n3].borders = new Borders();
                    } else if (tableCellArray[n3].background == null) {
                        tableCellArray[n3].background = tableRow.background != null ? tableRow.background : (tableGroup.background != null ? tableGroup.background : (tableColumnArray[n3 + 1] != null && tableColumnArray[n3 + 1].background != null ? tableColumnArray[n3 + 1].background : this.background));
                    }
                    tableCellArray[n3].width = 0;
                    tableRow.cells.addElement(tableCellArray[n3]);
                }
            }
        }
    }

    private void setRows() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.rows.length; ++n2) {
            this.rows[n2].background = null;
            if (this.rows[n2].height <= 0) continue;
            n = 0;
            int n3 = this.rows[n2].size();
            for (int i = 0; i < n3; ++i) {
                TableCell tableCell = this.rows[n2].get(i);
                int n4 = tableCell.marginTop + tableCell.marginBottom;
                if (n4 <= n) continue;
                n = n4;
            }
            if (n >= this.rows[n2].height) continue;
            this.rows[n2].height -= n;
        }
        if (this.keepTogether) {
            n = this.rows.length - 1;
            for (n2 = 0; n2 < n; ++n2) {
                this.rows[n2].keepTogether = true;
                this.rows[n2].keepWithNext = true;
            }
            this.rows[this.rows.length - 1].keepTogether = true;
        }
        TableRow tableRow = this.rows[0];
        if (this.breakBefore > tableRow.breakBefore) {
            tableRow.breakBefore = this.breakBefore;
        }
        for (n2 = 1; n2 < this.rows.length; ++n2) {
            TableRow tableRow2 = this.rows[n2];
            if (tableRow.breakAfter > tableRow2.breakBefore) {
                tableRow2.breakBefore = tableRow.breakAfter;
            }
            if (tableRow2.keepWithPrevious) {
                tableRow.keepWithNext = true;
            }
            tableRow = tableRow2;
        }
        for (n2 = 0; n2 < this.rows.length; ++n2) {
            if (this.rows[n2].breakBefore != 0) {
                this.rows[n2].get(0).breakBefore(this.rows[n2].breakBefore);
            }
            if (!this.rows[n2].keepWithNext) continue;
            this.rows[n2].get(0).keepWithNext();
        }
    }

    private void setTableIndent() {
        this.tableIndent = this.startIndent;
        if (!this.isNested) {
            if (this.borderCollapse == 177) {
                this.tableIndent += this.borders.left.width / 2;
                this.tableIndent += this.columnSpacing;
                this.tableIndent += this.borderWidths[0][0];
            } else {
                this.tableIndent += this.borderWidths[0][0] / 2;
            }
            this.tableIndent += this.rows[0].get((int)0).marginLeft;
        }
        switch (this.alignment) {
            case 1: {
                this.tableIndent += (this.maxWidth - this.width()) / 2;
                break;
            }
            case 2: {
                this.tableIndent += this.maxWidth - this.width();
            }
        }
    }

    private TableColumn column(int n) {
        int n2 = this.columns.size();
        for (int i = 0; i < n2; ++i) {
            TableColumn tableColumn = (TableColumn)this.columns.elementAt(i);
            int n3 = tableColumn.number;
            int n4 = n3 + tableColumn.repeat * tableColumn.span - 1;
            if (n3 > n || n4 < n) continue;
            return tableColumn;
        }
        return null;
    }

    private TableColumn[] columns() {
        TableColumn[] tableColumnArray = new TableColumn[this.numColumns + 1];
        int n = this.columns.size();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = (TableColumn)this.columns.elementAt(i);
            int n2 = tableColumn.number + tableColumn.repeat * tableColumn.span - 1;
            for (int j = tableColumn.number; j <= n2; ++j) {
                tableColumnArray[j] = tableColumn;
            }
        }
        return tableColumnArray;
    }

    private TableRow[] rows() {
        int n;
        int n2 = 0;
        TableRow[] tableRowArray = null;
        int n3 = this.groups.size();
        for (n = 0; n < n3; ++n) {
            TableGroup tableGroup = (TableGroup)this.groups.elementAt(n);
            n2 += tableGroup.rows.size();
        }
        if (n2 > 0) {
            tableRowArray = new TableRow[n2];
            n3 = 0;
            int n4 = this.groups.size();
            for (n = 0; n < n4; ++n) {
                TableGroup tableGroup = (TableGroup)this.groups.elementAt(n);
                int n5 = 0;
                int n6 = tableGroup.size();
                while (n5 < n6) {
                    tableRowArray[n3] = tableGroup.get(n5);
                    ++n5;
                    ++n3;
                }
            }
        }
        return tableRowArray;
    }

    private int width() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.numColumns; ++n) {
            n2 += this.columnWidths[n];
        }
        if (this.borderCollapse == 177) {
            n2 += (this.numColumns + 1) * this.columnSpacing;
            for (n = 0; n < this.numColumns; ++n) {
                n2 += this.borderWidths[n][0];
                n2 += this.borderWidths[n][1];
            }
            n2 += this.borders.left.width;
            n2 += this.borders.right.width;
        } else {
            n2 += this.borderWidths[0][0];
            n2 += this.borderWidths[this.numColumns - 1][1];
            for (n = 1; n < this.numColumns; ++n) {
                int n3 = this.borderWidths[n - 1][1];
                int n4 = this.borderWidths[n][0];
                n2 += Math.max(n3, n4);
            }
        }
        return n2;
    }

    public int maxWidth() {
        int n;
        int n2;
        Object[] objectArray;
        int n3 = 0;
        if (this.width > 0) {
            return this.width + this.startIndent + this.endIndent;
        }
        if (this.rows == null) {
            this.rows = this.expandRowSpans();
            if (this.rows == null) {
                return 0;
            }
            this.layoutBorders();
        }
        if (this.tableLayout == 69) {
            objectArray = this.columns();
            n3 = 0;
            for (n2 = 1; n2 <= this.numColumns; ++n2) {
                if (objectArray[n2] == null || objectArray[n2].width == 0) {
                    n3 = 0;
                    break;
                }
                n3 += objectArray[n2].width / objectArray[n2].span;
            }
        }
        if (n3 == 0) {
            objectArray = new int[this.numColumns];
            int n4 = this.rows.length;
            for (n = 0; n < n4; ++n) {
                int n5 = this.rows[n].size();
                for (int i = 0; i < n5; ++i) {
                    TableCell tableCell = this.rows[n].get(i);
                    n3 = tableCell.maxWidth();
                    int n6 = tableCell.columnNumber - 1;
                    int n7 = tableCell.columnSpan;
                    if (n7 > 1) {
                        n3 /= n7;
                        for (n2 = 0; n2 < n7; ++n2) {
                            int n8 = n6 + n2;
                            if (n3 <= objectArray[n8]) continue;
                            objectArray[n8] = (TableColumn)n3;
                        }
                        continue;
                    }
                    if (n3 <= objectArray[n6]) continue;
                    objectArray[n6] = (TableColumn)n3;
                }
            }
            n3 = 0;
            for (n2 = 0; n2 < this.numColumns; ++n2) {
                n3 += objectArray[n2];
            }
        }
        if (this.borderCollapse == 177) {
            n3 += (this.numColumns + 1) * this.columnSpacing;
            for (n2 = 0; n2 < this.numColumns; ++n2) {
                n3 += this.borderWidths[n2][0];
                n3 += this.borderWidths[n2][1];
            }
            n3 += this.borders.left.width;
            n3 += this.borders.right.width;
        } else {
            n3 += this.borderWidths[0][0];
            n3 += this.borderWidths[this.numColumns - 1][1];
            for (n2 = 1; n2 < this.numColumns; ++n2) {
                int n9 = this.borderWidths[n2 - 1][1];
                n = this.borderWidths[n2][0];
                n3 += Math.max(n9, n);
            }
        }
        n3 += this.startIndent;
        return n3 += this.endIndent;
    }

    public int minWidth() {
        int n;
        int n2;
        Object[] objectArray;
        int n3 = 0;
        if (this.width > 0) {
            return this.width + this.startIndent + this.endIndent;
        }
        if (this.rows == null) {
            this.rows = this.expandRowSpans();
            if (this.rows == null) {
                return 0;
            }
            this.layoutBorders();
        }
        if (this.tableLayout == 69) {
            objectArray = this.columns();
            n3 = 0;
            for (n2 = 1; n2 <= this.numColumns; ++n2) {
                if (objectArray[n2] == null || objectArray[n2].width == 0) {
                    n3 = 0;
                    break;
                }
                n3 += objectArray[n2].width / objectArray[n2].span;
            }
        }
        if (n3 == 0) {
            objectArray = new int[this.numColumns];
            int n4 = this.rows.length;
            for (n = 0; n < n4; ++n) {
                int n5 = this.rows[n].size();
                for (int i = 0; i < n5; ++i) {
                    TableCell tableCell = this.rows[n].get(i);
                    n3 = tableCell.minWidth();
                    int n6 = tableCell.columnNumber - 1;
                    int n7 = tableCell.columnSpan;
                    if (n7 > 1) {
                        n3 /= n7;
                        for (n2 = 0; n2 < n7; ++n2) {
                            int n8 = n6 + n2;
                            if (n3 <= objectArray[n8]) continue;
                            objectArray[n8] = (TableColumn)n3;
                        }
                        continue;
                    }
                    if (n3 <= objectArray[n6]) continue;
                    objectArray[n6] = (TableColumn)n3;
                }
            }
            n3 = 0;
            for (n2 = 0; n2 < this.numColumns; ++n2) {
                n3 += objectArray[n2];
            }
        }
        if (this.borderCollapse == 177) {
            n3 += (this.numColumns + 1) * this.columnSpacing;
            for (n2 = 0; n2 < this.numColumns; ++n2) {
                n3 += this.borderWidths[n2][0];
                n3 += this.borderWidths[n2][1];
            }
            n3 += this.borders.left.width;
            n3 += this.borders.right.width;
        } else {
            n3 += this.borderWidths[0][0];
            n3 += this.borderWidths[this.numColumns - 1][1];
            for (n2 = 1; n2 < this.numColumns; ++n2) {
                int n9 = this.borderWidths[n2 - 1][1];
                n = this.borderWidths[n2][0];
                n3 += Math.max(n9, n);
            }
        }
        n3 += this.startIndent;
        return n3 += this.endIndent;
    }
}

