/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.wml;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.wml.Caption;
import com.xmlmind.fo.converter.wml.Table;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;

public class TableAndCaption {
    public int alignment;
    public Table table;
    public Caption caption;

    public TableAndCaption() {
    }

    public TableAndCaption(Context context) {
        this();
        this.initialize(context);
    }

    public void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        switch (valueArray[289].keyword()) {
            default: {
                this.alignment = 0;
                break;
            }
            case 31: 
            case 93: {
                this.alignment = 1;
                break;
            }
            case 52: 
            case 144: 
            case 165: {
                this.alignment = 2;
            }
        }
    }

    public void layout(int n) throws Exception {
        if (this.table != null) {
            this.table.layout(n, this.alignment);
        }
    }

    public void print(PrintWriter printWriter, Encoder encoder) throws Exception {
        if (this.caption != null && this.caption.side == 1) {
            this.caption.print(printWriter, encoder);
        }
        if (this.table != null) {
            this.table.print(printWriter, encoder);
        }
        if (this.caption != null && this.caption.side == 2) {
            this.caption.print(printWriter, encoder);
        }
    }

    public int maxWidth() {
        int n;
        int n2 = 0;
        if (this.table != null) {
            n2 = this.table.maxWidth();
        }
        if (this.caption != null && (n = this.caption.maxWidth()) > n2) {
            n2 = n;
        }
        return n2;
    }

    public int minWidth() {
        int n;
        int n2 = 0;
        if (this.table != null) {
            n2 = this.table.minWidth();
        }
        if (this.caption != null && (n = this.caption.minWidth()) > n2) {
            n2 = n;
        }
        return n2;
    }
}

