/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.wml;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.wml.Bookmark;
import com.xmlmind.fo.converter.wml.Borders;
import com.xmlmind.fo.converter.wml.TableCell;
import com.xmlmind.fo.converter.wml.Wml;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import java.io.PrintWriter;
import java.util.Vector;

public final class TableRow {
    public int breakBefore = 0;
    public int breakAfter = 0;
    public boolean keepTogether;
    public boolean keepWithNext;
    public boolean keepWithPrevious;
    public int height;
    public Borders borders;
    public Color background;
    public Bookmark[] bookmarks;
    public boolean isHeaderRow;
    public Vector cells = new Vector();

    public TableRow() {
    }

    public TableRow(Context context) {
        this();
        this.initialize(context);
    }

    public void initialize(Context context) {
        Value[] valueArray = context.properties.values;
        this.breakBefore = context.properties.breakBefore();
        this.breakAfter = context.properties.breakAfter();
        this.keepTogether = TableRow.keep(valueArray[137]);
        this.keepWithNext = TableRow.keep(valueArray[141]);
        this.keepWithPrevious = TableRow.keep(valueArray[145]);
        Value value = valueArray[118];
        if (value.type == 4) {
            this.height = Wml.toTwips(value.length());
        }
        this.borders = new Borders(valueArray);
        value = valueArray[8];
        if (value.type == 24) {
            this.background = value.color();
        }
    }

    private static boolean keep(Value value) {
        boolean bl = false;
        switch (value.type) {
            case 1: {
                if (value.keyword() != 8) break;
                bl = true;
                break;
            }
            case 2: {
                if (value.integer() <= 0) break;
                bl = true;
            }
        }
        return bl;
    }

    public void add(TableCell tableCell) {
        this.cells.addElement(tableCell);
    }

    public int size() {
        return this.cells.size();
    }

    public TableCell get(int n) {
        return (TableCell)this.cells.elementAt(n);
    }

    public void print(PrintWriter printWriter, Encoder encoder) throws Exception {
        int n;
        if (this.bookmarks != null) {
            for (n = 0; n < this.bookmarks.length; ++n) {
                this.bookmarks[n].start(printWriter, encoder);
            }
        }
        printWriter.println("<w:tr>");
        printWriter.print("<w:tblPrEx>");
        if (this.borders != null && this.borders.materialized()) {
            printWriter.print("<w:tblBorders>");
            this.borders.print(printWriter);
            printWriter.print("</w:tblBorders>");
        }
        if (this.background != null) {
            printWriter.print("<w:shd");
            printWriter.print(" w:val=\"clear\"");
            printWriter.print(" w:fill=\"" + Wml.hexColorType(this.background) + "\"");
            printWriter.print(" />");
        }
        printWriter.println("</w:tblPrEx>");
        printWriter.print("<w:trPr>");
        if (this.keepTogether) {
            printWriter.print("<w:cantSplit />");
        }
        if (this.height > 0) {
            printWriter.print("<w:trHeight");
            printWriter.print(" w:val=\"" + this.height + "\"");
            printWriter.print(" w:h-rule=\"at-least\"");
            printWriter.print(" />");
        }
        if (this.isHeaderRow) {
            printWriter.print("<w:tblHeader />");
        }
        printWriter.println("</w:trPr>");
        int n2 = this.cells.size();
        for (n = 0; n < n2; ++n) {
            TableCell tableCell = (TableCell)this.cells.elementAt(n);
            tableCell.print(printWriter, encoder);
        }
        printWriter.println("</w:tr>");
        if (this.bookmarks != null) {
            for (n = this.bookmarks.length - 1; n >= 0; --n) {
                this.bookmarks[n].end(printWriter);
            }
        }
    }
}

