/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.wml;

import com.xmlmind.fo.converter.wml.ColorTable;
import com.xmlmind.fo.properties.Color;
import com.xmlmind.fo.util.Encoder;

public final class Wml {
    public static final int CS_ANSI = 0;
    public static final int CS_SYMBOL = 2;
    public static final int CS_RUSSIAN = 204;
    public static final int CS_EASTERN_EUROPEAN = 238;
    public static final int UNIT_MILLIMETER = 1;
    public static final int UNIT_CENTIMETER = 2;
    public static final int UNIT_INCH = 3;
    public static final int UNIT_POINT = 4;

    public static int toTwips(double d, int n) {
        double d2;
        switch (n) {
            case 1: {
                d2 = d / 25.4 * 72.0;
                break;
            }
            case 2: {
                d2 = d / 2.54 * 72.0;
                break;
            }
            case 3: {
                d2 = d * 72.0;
                break;
            }
            default: {
                d2 = d;
            }
        }
        return Wml.toTwips(d2);
    }

    public static int toTwips(double d) {
        return (int)Math.rint(20.0 * d);
    }

    public static int toEighths(double d) {
        return (int)Math.rint(8.0 * d);
    }

    public static String hexNumberType(int n, int n2) {
        return Integer.toHexString(n + (1 << n2)).substring(1);
    }

    public static String hexColorType(Color color) {
        if (color.name != null) {
            color = ColorTable.get(color.name);
        }
        int n = (color.red << 16) + (color.green << 8) + color.blue;
        return Wml.hexNumberType(n, 24);
    }

    public static String escape(char c) {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
        }
        return new String(new char[]{c});
    }

    public static String escape(String string) {
        return Wml.escape(string, null);
    }

    public static String escape(String string, Encoder encoder) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        if (encoder != null) {
            block12: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '<': {
                        stringBuffer.append("&lt;");
                        continue block12;
                    }
                    case '>': {
                        if (i > 1 && string.charAt(i - 1) == ']' && string.charAt(i - 2) == ']') {
                            stringBuffer.append("&gt;");
                            continue block12;
                        }
                        stringBuffer.append(c);
                        continue block12;
                    }
                    case '&': {
                        stringBuffer.append("&amp;");
                        continue block12;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        continue block12;
                    }
                    default: {
                        if (!encoder.canEncode(c)) {
                            stringBuffer.append("&#" + Integer.toString(c) + ";");
                            continue block12;
                        }
                        stringBuffer.append(c);
                    }
                }
            }
        } else {
            block13: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '<': {
                        stringBuffer.append("&lt;");
                        continue block13;
                    }
                    case '>': {
                        if (i > 1 && string.charAt(i - 1) == ']' && string.charAt(i - 2) == ']') {
                            stringBuffer.append("&gt;");
                            continue block13;
                        }
                        stringBuffer.append(c);
                        continue block13;
                    }
                    case '&': {
                        stringBuffer.append("&amp;");
                        continue block13;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        continue block13;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
        }
        return stringBuffer.toString();
    }
}

