/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.converter.wml;

import com.xmlmind.fo.converter.Context;
import com.xmlmind.fo.converter.MsTranslator;
import com.xmlmind.fo.converter.wml.Bookmark;
import com.xmlmind.fo.converter.wml.Break;
import com.xmlmind.fo.converter.wml.Caption;
import com.xmlmind.fo.converter.wml.FontTable;
import com.xmlmind.fo.converter.wml.Footer;
import com.xmlmind.fo.converter.wml.Footnote;
import com.xmlmind.fo.converter.wml.Header;
import com.xmlmind.fo.converter.wml.Leader;
import com.xmlmind.fo.converter.wml.Link;
import com.xmlmind.fo.converter.wml.List;
import com.xmlmind.fo.converter.wml.ListTable;
import com.xmlmind.fo.converter.wml.PageNumber;
import com.xmlmind.fo.converter.wml.PageReference;
import com.xmlmind.fo.converter.wml.ParProperties;
import com.xmlmind.fo.converter.wml.Paragraph;
import com.xmlmind.fo.converter.wml.Picture;
import com.xmlmind.fo.converter.wml.RunProperties;
import com.xmlmind.fo.converter.wml.Section;
import com.xmlmind.fo.converter.wml.State;
import com.xmlmind.fo.converter.wml.StaticContent;
import com.xmlmind.fo.converter.wml.Table;
import com.xmlmind.fo.converter.wml.TableAndCaption;
import com.xmlmind.fo.converter.wml.Text;
import com.xmlmind.fo.converter.wml.Wml;
import com.xmlmind.fo.font.GenericFamilies;
import com.xmlmind.fo.graphic.Graphic;
import com.xmlmind.fo.graphic.GraphicEnv;
import com.xmlmind.fo.objects.Flow;
import com.xmlmind.fo.objects.PageMasterReference;
import com.xmlmind.fo.objects.PageSequence;
import com.xmlmind.fo.objects.PageSequenceMaster;
import com.xmlmind.fo.objects.SimplePageMaster;
import com.xmlmind.fo.properties.Value;
import com.xmlmind.fo.util.Encoder;
import com.xmlmind.fo.util.EncoderFactory;
import com.xmlmind.fo.util.Encoding;
import com.xmlmind.fo.util.TempFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.Vector;

public class WmlTranslator
extends MsTranslator {
    private static final int DEFAULT_PAGE_WIDTH = Wml.toTwips(21.0, 2);
    private static final int DEFAULT_PAGE_HEIGHT = Wml.toTwips(29.7, 2);
    private static final String DEFAULT_ENCODING = "Cp1252";
    private static final String WML_NAMESPACE_URI = "http://schemas.microsoft.com/office/word/2003/wordml";
    private static final String AML_NAMESPACE_URI = "http://schemas.microsoft.com/aml/2001/core";
    private static final String VML_NAMESPACE_URI = "urn:schemas-microsoft-com:vml";
    private static final String MSO_NAMESPACE_URI = "urn:schemas-microsoft-com:office:office";
    private String encoding;
    private Encoder encoder;
    private File tmpFile;
    private PrintWriter tmpWriter;
    private PrintWriter outputWriter;
    private boolean closeOutputWriter;
    private SimplePageMaster oddPageMaster;
    private SimplePageMaster evenPageMaster;
    private SimplePageMaster firstPageMaster;
    private FontTable fontTable;
    private ListTable listTable;
    private int bookmarkId;
    private int pictureId;
    private boolean singleSided;
    private boolean mirrorMargins;
    private boolean prescaleImages;
    private int imageResolution;
    private int imageRendererResolution;
    private boolean alwaysSaveAsPNG;
    private State state;
    private Section section;
    private StaticContent staticContent;
    private Paragraph paragraph;
    private Vector bookmarks;

    public static String[] listEncodings() {
        int n;
        String[] stringArray = Encoding.list();
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < stringArray.length; ++n) {
            String string = Encoding.officialName(stringArray[n]);
            if (string == null || string.equals("ISO-2022-CN") || string.equals("x-JISAutoDetect")) continue;
            vector.addElement(string);
        }
        stringArray = new String[vector.size()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    public void abort() {
        try {
            this.clean();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String systemFont(int n) {
        return "10pt serif";
    }

    public double fontSize(int n, double d) {
        double d2 = 10.0;
        switch (n) {
            case 236: {
                d2 = 6.0;
                break;
            }
            case 243: {
                d2 = 8.0;
                break;
            }
            case 182: {
                d2 = 10.0;
                break;
            }
            case 118: {
                d2 = 12.0;
                break;
            }
            case 95: {
                d2 = 14.0;
                break;
            }
            case 239: {
                d2 = 16.0;
                break;
            }
            case 235: {
                d2 = 18.0;
                break;
            }
            case 96: {
                d2 = 2.0 * (double)Math.round(d / 2.0 + 1.0);
                break;
            }
            case 183: {
                d2 = 2.0 * (double)Math.round(d / 2.0 - 1.0);
                if (!(d2 < 2.0)) break;
                d2 = 2.0;
                break;
            }
        }
        return d2;
    }

    public double referenceWidth() {
        return this.state != null ? (double)this.state.referenceWidth / 20.0 : 0.0;
    }

    private void clean() throws Exception {
        if (this.tmpWriter != null) {
            this.tmpWriter.close();
            this.tmpWriter = null;
        }
        if (this.tmpFile != null) {
            this.tmpFile.delete();
            this.tmpFile = null;
        }
    }

    protected void finalize() throws Throwable {
        this.clean();
    }

    public void startDocument() throws Exception {
        this.setEncoding();
        String string = Encoding.officialName(this.encoding);
        this.encoder = !string.startsWith("UTF") ? EncoderFactory.newEncoder(string) : null;
        this.tmpFile = TempFile.create("xfc", null);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.tmpFile));
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, this.encoding);
        this.tmpWriter = new PrintWriter(new BufferedWriter(outputStreamWriter));
        this.fontTable = new FontTable();
        GenericFamilies genericFamilies = this.genericFontFamilies(null, null, null);
        this.fontTable.add(genericFamilies.serif, "Roman");
        this.fontTable.alias("serif", genericFamilies.serif);
        this.fontTable.add(genericFamilies.sansSerif, "Swiss");
        this.fontTable.alias("sans-serif", genericFamilies.sansSerif);
        this.fontTable.add(genericFamilies.monospace, "Modern");
        this.fontTable.alias("monospace", genericFamilies.monospace);
        if (genericFamilies.fantasy != null) {
            this.fontTable.add(genericFamilies.fantasy, "Decorative");
            this.fontTable.alias("fantasy", genericFamilies.fantasy);
        }
        if (genericFamilies.cursive != null) {
            this.fontTable.add(genericFamilies.cursive, "Script");
            this.fontTable.alias("cursive", genericFamilies.cursive);
        }
        this.listTable = new ListTable();
        this.bookmarkId = 0;
        this.pictureId = 1;
        this.singleSided = this.singleSided();
        this.mirrorMargins = true;
        this.prescaleImages = this.prescaleImages();
        this.imageResolution = this.imageResolution();
        this.imageRendererResolution = this.imageRendererResolution();
        this.alwaysSaveAsPNG = this.alwaysSaveAsPNG();
        this.section = null;
        this.paragraph = null;
        this.bookmarks = null;
    }

    private void setEncoding() throws Exception {
        String string = null;
        if (this.output != null) {
            string = this.output.getEncoding();
        }
        if (string == null && (string = this.properties.getProperty("outputEncoding")) == null) {
            string = DEFAULT_ENCODING;
        }
        this.encoding = Encoding.internalName(string);
        if (this.encoding == null) {
            throw new Exception("unsupported encoding \"" + string + "\"");
        }
    }

    public void endDocument() throws Exception {
        if (this.section != null) {
            this.section.isLast = true;
            this.section.end(this.tmpWriter, this.encoder);
        }
        this.tmpWriter.flush();
        this.tmpWriter.close();
        this.tmpWriter = null;
        if (this.output != null) {
            this.setOutputWriter();
            this.writeDocument();
            this.outputWriter.flush();
            if (this.closeOutputWriter) {
                this.outputWriter.close();
            }
            this.outputWriter = null;
        }
        this.tmpFile.delete();
        this.tmpFile = null;
    }

    private void setOutputWriter() throws Exception {
        Writer writer = this.output.getCharacterStream();
        this.closeOutputWriter = false;
        if (writer == null) {
            OutputStream outputStream = this.output.getByteStream();
            if (outputStream == null) {
                String string = this.output.getFileName();
                if (string != null) {
                    outputStream = new FileOutputStream(string);
                    this.closeOutputWriter = true;
                } else {
                    outputStream = System.out;
                }
            }
            outputStream = new BufferedOutputStream(outputStream);
            writer = new OutputStreamWriter(outputStream, this.encoding);
        }
        this.outputWriter = new PrintWriter(new BufferedWriter(writer));
    }

    private void writeDocument() throws Exception {
        this.outputWriter.println("<?xml version=\"1.0\" encoding=\"" + Encoding.officialName(this.encoding) + "\"?>");
        this.outputWriter.println("<?mso-application progid=\"Word.Document\"?>");
        this.outputWriter.print("<w:wordDocument");
        this.outputWriter.print(" xmlns:w=\"http://schemas.microsoft.com/office/word/2003/wordml\"");
        this.outputWriter.print(" xmlns:aml=\"http://schemas.microsoft.com/aml/2001/core\"");
        this.outputWriter.print(" xmlns:v=\"urn:schemas-microsoft-com:vml\"");
        this.outputWriter.print(" xmlns:o=\"urn:schemas-microsoft-com:office:office\"");
        this.outputWriter.println(" xml:space=\"preserve\">");
        this.writeStandardProperties();
        this.writeFontTable();
        this.writeListTable();
        this.writeDocumentProperties();
        this.writeDocumentBody();
        this.outputWriter.println("</w:wordDocument>");
    }

    private void writeStandardProperties() {
        this.outputWriter.print("<o:DocumentProperties>");
        this.outputWriter.print("<o:Author>" + Wml.escape("XMLmind XSL-FO Converter Professional Edition 4.7.0") + "</o:Author>");
        this.outputWriter.println("</o:DocumentProperties>");
    }

    private void writeFontTable() {
        this.fontTable.print(this.outputWriter);
    }

    private void writeListTable() {
        this.listTable.print(this.outputWriter);
    }

    private void writeDocumentProperties() {
        this.outputWriter.print("<w:docPr>");
        this.outputWriter.print("<w:view w:val=\"print\" />");
        if (!this.singleSided && this.mirrorMargins) {
            this.outputWriter.print("<w:mirrorMargins />");
        }
        this.outputWriter.print("<w:bordersDontSurroundHeader />");
        this.outputWriter.print("<w:bordersDontSurroundFooter />");
        if (!this.singleSided) {
            this.outputWriter.print("<w:evenAndOddHeaders />");
        }
        this.outputWriter.println("</w:docPr>");
    }

    private void writeDocumentBody() throws Exception {
        char[] cArray;
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.tmpFile));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, this.encoding));
        this.outputWriter.println("<w:body>");
        while ((n = bufferedReader.read(cArray = new char[1024], 0, cArray.length)) >= 0) {
            if (n <= 0) continue;
            this.outputWriter.write(cArray, 0, n);
        }
        this.outputWriter.println("</w:body>");
        bufferedReader.close();
    }

    public void characters(String string, Context context) throws Exception {
        if (this.state.skip) {
            return;
        }
        if (this.paragraph == null) {
            this.startParagraph(context);
        }
        if (this.state.runProperties == null) {
            this.state.runProperties = this.runProperties(context);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("\n")) {
                object = new Break("text-wrapping", this.state.runProperties);
                this.paragraph.add((Break)object);
                continue;
            }
            object = new Text(string2, this.state.runProperties);
            this.paragraph.add((Text)object);
        }
    }

    private RunProperties runProperties(Context context) {
        return new RunProperties(context, this.fontTable);
    }

    private void startParagraph(Context context) {
        int n;
        this.paragraph = new Paragraph(new ParProperties(context));
        if (this.bookmarks != null && this.state.context != 2) {
            this.paragraph.bookmarks = new Bookmark[this.bookmarks.size()];
            for (n = 0; n < this.paragraph.bookmarks.length; ++n) {
                this.paragraph.bookmarks[n] = (Bookmark)this.bookmarks.elementAt(n);
            }
            this.bookmarks = null;
        }
        if (this.state.context == 3 && this.state.list.item != null) {
            List.Item.Label label = this.state.list.item.label;
            ParProperties parProperties = this.paragraph.properties;
            this.paragraph.startsListItem = true;
            parProperties.breakBefore = this.state.list.item.breakBefore;
            parProperties.spaceBefore = this.state.list.item.spaceBefore;
            if (parProperties.alignment == "center" || parProperties.alignment == "right") {
                parProperties.alignment = "left";
            }
            n = parProperties.startIndent;
            int n2 = label.startIndent - n;
            if (!this.state.list.plainText && label.alignment != 0) {
                int n3 = n - label.startIndent - this.state.list.labelSeparation;
                switch (label.alignment) {
                    case 1: {
                        n2 += n3 / 2;
                        break;
                    }
                    case 2: {
                        n2 += n3;
                    }
                }
            }
            parProperties.firstLineIndent = n2;
            if (n > 0) {
                parProperties.addTab(new ParProperties.Tab(n));
            }
            if (this.state.list.plainText) {
                this.paragraph.add(label.runs);
                if (n > 0) {
                    Paragraph.Tab tab = new Paragraph.Tab(label.properties);
                    tab.isSeparator = true;
                    this.paragraph.add(tab);
                }
            } else {
                parProperties.listId = this.state.list.id;
            }
            this.state.list.item = null;
        }
    }

    private void endParagraph() throws Exception {
        int n = this.state.context;
        if (n == 3) {
            n = this.state.parentContext();
        }
        if (this.paragraph.isVoid()) {
            this.paragraph = null;
            return;
        }
        if (this.paragraph.hasTabs()) {
            this.setTabs();
        }
        if (this.paragraph.hasPicture && n != 4) {
            this.paragraph.layout(this.state.referenceWidth);
        }
        switch (n) {
            case 2: {
                if (this.state.list.item != null) break;
                this.state.list.item = new List.Item(this.paragraph);
                break;
            }
            case 4: {
                this.state.table.add(this.paragraph);
                break;
            }
            case 5: {
                this.state.tableAndCaption.caption.add(this.paragraph);
                break;
            }
            case 6: {
                this.state.footnote.add(this.paragraph);
                break;
            }
            case 7: {
                this.staticContent.add(this.paragraph);
                break;
            }
            default: {
                this.paragraph.print(this.tmpWriter, this.encoder);
            }
        }
        this.paragraph = null;
    }

    private void setTabs() {
        int n;
        int n2 = this.state.referenceWidth;
        int n3 = this.paragraph.properties.startIndent;
        ParProperties.Tab[] tabArray = this.paragraph.properties.tabs();
        for (n = 0; n < tabArray.length; ++n) {
            if (tabArray[n].position >= 0) continue;
            tabArray[n].position += n2;
        }
        for (n = 0; n < tabArray.length; ++n) {
            if (tabArray[n].position == 0) {
                int n4;
                int n5 = n2 - this.paragraph.properties.endIndent;
                int n6 = 1;
                for (n4 = n + 1; n4 < tabArray.length; ++n4) {
                    if (tabArray[n4].position != 0) {
                        n5 = tabArray[n4].position;
                        break;
                    }
                    ++n6;
                }
                int n7 = (n5 - n3) / (n6 + 1);
                while (n < n4) {
                    n3 = tabArray[n].position = n3 + n7;
                    ++n;
                }
                continue;
            }
            n3 = tabArray[n].position;
        }
    }

    public void startRoot(Value[] valueArray, Context context) throws Exception {
    }

    public void endRoot(Context context) throws Exception {
    }

    public void startDeclarations(Value[] valueArray, Context context) throws Exception {
    }

    public void endDeclarations(Context context) throws Exception {
    }

    public void startColorProfile(Value[] valueArray, Context context) throws Exception {
    }

    public void endColorProfile(Context context) throws Exception {
    }

    public void startPageSequence(PageSequence pageSequence, Value[] valueArray, Context context) throws Exception {
        if (this.section != null) {
            this.section.end(this.tmpWriter, this.encoder);
        }
        this.selectPageMasters(pageSequence);
        if (this.singleSided) {
            this.evenPageMaster = null;
        }
        this.section = new Section();
        this.section.pageWidth = DEFAULT_PAGE_WIDTH;
        this.section.pageHeight = DEFAULT_PAGE_HEIGHT;
        this.section.initialize(this.oddPageMaster, this.evenPageMaster, this.firstPageMaster, pageSequence);
        if (!this.section.mirrorMargins) {
            this.mirrorMargins = false;
        }
        this.section.start(this.tmpWriter, this.encoder);
        this.state = new State(31);
        this.state.referenceWidth = this.section.contentWidth;
        if (valueArray[125] != null) {
            this.addBookmark(valueArray[125].id(), context);
        }
    }

    private void selectPageMasters(PageSequence pageSequence) {
        int n;
        this.oddPageMaster = null;
        this.evenPageMaster = null;
        this.firstPageMaster = null;
        if (pageSequence.pageMaster != null) {
            this.oddPageMaster = pageSequence.pageMaster;
            return;
        }
        PageSequenceMaster pageSequenceMaster = pageSequence.pageSequenceMaster;
        PageMasterReference pageMasterReference = pageSequenceMaster.subSequence(0);
        switch (pageMasterReference.type) {
            case 1: {
                this.firstPageMaster = pageMasterReference.pageMaster;
                break;
            }
            case 2: {
                if (pageMasterReference.maximumRepeats != 1) break;
                this.firstPageMaster = pageMasterReference.pageMaster;
                break;
            }
        }
        PageMasterReference pageMasterReference2 = null;
        int n2 = pageSequenceMaster.subSequences.size();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            pageMasterReference = pageSequenceMaster.subSequence(n);
            if (pageMasterReference.maximumRepeats < 0) {
                pageMasterReference2 = pageMasterReference;
                break;
            }
            if (pageMasterReference.maximumRepeats <= n3) continue;
            n3 = pageMasterReference.maximumRepeats;
            pageMasterReference2 = pageMasterReference;
        }
        if (pageMasterReference2.type == 3) {
            n2 = pageMasterReference2.alternatives.size();
            block12: for (n = 0; n < n2; ++n) {
                PageMasterReference pageMasterReference3 = pageMasterReference2.alternative(n);
                if (pageMasterReference3.blankOrNotBlank == 21) continue;
                switch (pageMasterReference3.pagePosition) {
                    case 97: {
                        continue block12;
                    }
                    case 66: {
                        if (this.firstPageMaster != null) continue block12;
                        this.firstPageMaster = pageMasterReference3.pageMaster;
                        continue block12;
                    }
                    default: {
                        switch (pageMasterReference3.oddOrEven) {
                            case 56: {
                                this.evenPageMaster = pageMasterReference3.pageMaster;
                                continue block12;
                            }
                        }
                        this.oddPageMaster = pageMasterReference3.pageMaster;
                    }
                }
            }
            if (this.oddPageMaster == null) {
                this.oddPageMaster = pageMasterReference2.alternative((int)0).pageMaster;
            }
        } else {
            this.oddPageMaster = pageMasterReference2.pageMaster;
        }
        if (this.firstPageMaster == this.oddPageMaster) {
            this.firstPageMaster = null;
        }
    }

    public void endPageSequence(Context context) throws Exception {
    }

    public void startLayoutMasterSet(Value[] valueArray, Context context) throws Exception {
    }

    public void endLayoutMasterSet(Context context) throws Exception {
    }

    public void startPageSequenceMaster(Value[] valueArray, Context context) throws Exception {
    }

    public void endPageSequenceMaster(Context context) throws Exception {
    }

    public void startSinglePageMasterReference(Value[] valueArray, Context context) throws Exception {
    }

    public void endSinglePageMasterReference(Context context) throws Exception {
    }

    public void startRepeatablePageMasterReference(Value[] valueArray, Context context) throws Exception {
    }

    public void endRepeatablePageMasterReference(Context context) throws Exception {
    }

    public void startRepeatablePageMasterAlternatives(Value[] valueArray, Context context) throws Exception {
    }

    public void endRepeatablePageMasterAlternatives(Context context) throws Exception {
    }

    public void startConditionalPageMasterReference(Value[] valueArray, Context context) throws Exception {
    }

    public void endConditionalPageMasterReference(Context context) throws Exception {
    }

    public void startSimplePageMaster(Value[] valueArray, Context context) throws Exception {
    }

    public void endSimplePageMaster(Context context) throws Exception {
    }

    public void startRegionBody(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionBody(Context context) throws Exception {
    }

    public void startRegionBefore(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionBefore(Context context) throws Exception {
    }

    public void startRegionAfter(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionAfter(Context context) throws Exception {
    }

    public void startRegionStart(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionStart(Context context) throws Exception {
    }

    public void startRegionEnd(Value[] valueArray, Context context) throws Exception {
    }

    public void endRegionEnd(Context context) throws Exception {
    }

    public void startFlow(Flow flow, Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(10);
        this.state.referenceWidth = this.section.columnWidth;
        if (flow.region(this.oddPageMaster) != 0) {
            this.state.skip = true;
            return;
        }
        if (valueArray[125] != null) {
            this.addBookmark(valueArray[125].id(), context);
        }
    }

    public void endFlow(Context context) throws Exception {
        if (!this.state.skip && this.bookmarks != null) {
            this.writeBookmarks();
            this.bookmarks = null;
        }
        this.state = this.state.restore();
    }

    private void writeBookmarks() {
        int n;
        Bookmark[] bookmarkArray = new Bookmark[this.bookmarks.size()];
        for (n = 0; n < bookmarkArray.length; ++n) {
            bookmarkArray[n] = (Bookmark)this.bookmarks.elementAt(n);
        }
        for (n = 0; n < bookmarkArray.length; ++n) {
            bookmarkArray[n].start(this.tmpWriter, this.encoder);
        }
        for (n = bookmarkArray.length - 1; n >= 0; --n) {
            bookmarkArray[n].end(this.tmpWriter);
        }
    }

    public void startStaticContent(Flow flow, Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(44);
        this.staticContent = null;
        switch (flow.region(this.oddPageMaster)) {
            case 1: {
                this.staticContent = new StaticContent();
                this.section.headerOdd = new Header("odd", this.staticContent);
                if (this.singleSided || this.evenPageMaster != null) break;
                this.section.headerEven = new Header("even", this.staticContent);
                break;
            }
            case 2: {
                this.staticContent = new StaticContent();
                this.section.footerOdd = new Footer("odd", this.staticContent);
                if (this.singleSided || this.evenPageMaster != null) break;
                this.section.footerEven = new Footer("even", this.staticContent);
            }
        }
        if (this.evenPageMaster != null) {
            switch (flow.region(this.evenPageMaster)) {
                case 1: {
                    if (this.staticContent == null) {
                        this.staticContent = new StaticContent();
                    }
                    this.section.headerEven = new Header("even", this.staticContent);
                    break;
                }
                case 2: {
                    if (this.staticContent == null) {
                        this.staticContent = new StaticContent();
                    }
                    this.section.footerEven = new Footer("even", this.staticContent);
                }
            }
        }
        if (this.firstPageMaster != null) {
            switch (flow.region(this.firstPageMaster)) {
                case 1: {
                    if (this.staticContent == null) {
                        this.staticContent = new StaticContent();
                    }
                    this.section.headerFirst = new Header("first", this.staticContent);
                    break;
                }
                case 2: {
                    if (this.staticContent == null) {
                        this.staticContent = new StaticContent();
                    }
                    this.section.footerFirst = new Footer("first", this.staticContent);
                }
            }
        }
        if (this.staticContent == null) {
            this.state.skip = true;
        }
    }

    public void endStaticContent(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startTitle(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(54);
    }

    public void endTitle(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startBlock(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(2);
        if (!this.state.skip) {
            if (this.paragraph != null) {
                this.endParagraph();
            }
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
        }
    }

    private void addBookmark(String string, Context context) {
        Bookmark bookmark = new Bookmark(this.bookmarkId++, string, context);
        if (this.bookmarks == null) {
            this.bookmarks = new Vector();
        }
        this.bookmarks.addElement(bookmark);
    }

    public void endBlock(Context context) throws Exception {
        if (!this.state.skip && this.paragraph != null) {
            this.endParagraph();
        }
        this.state = this.state.restore();
    }

    public void startBlockContainer(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(3);
    }

    public void endBlockContainer(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startBidiOverride(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(1);
    }

    public void endBidiOverride(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startCharacter(Value[] valueArray, Context context) throws Exception {
    }

    public void endCharacter(Context context) throws Exception {
    }

    public void startInitialPropertySet(Value[] valueArray, Context context) throws Exception {
    }

    public void endInitialPropertySet(Context context) throws Exception {
    }

    public void startExternalGraphic(Graphic graphic, GraphicEnv graphicEnv, Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(8);
        if (!this.state.skip) {
            if (valueArray[125] != null) {
                this.startBookmark(valueArray[125].id(), context);
            }
            Picture picture = new Picture(this.pictureId++, graphic, graphicEnv, this.runProperties(context), this.prescaleImages, this.imageResolution, this.imageRendererResolution, this.alwaysSaveAsPNG, this.encoder);
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.add(picture);
        }
    }

    public void endExternalGraphic(Context context) throws Exception {
        if (!this.state.skip && this.state.bookmark != null) {
            this.endBookmark();
        }
        this.state = this.state.restore();
    }

    public void startInstreamForeignObject(Value[] valueArray, Context context) throws Exception {
    }

    public void endInstreamForeignObject(Graphic graphic, GraphicEnv graphicEnv, Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(16);
        if (!this.state.skip) {
            if (valueArray[125] != null) {
                this.startBookmark(valueArray[125].id(), context);
            }
            Picture picture = new Picture(this.pictureId++, graphic, graphicEnv, this.runProperties(context), this.prescaleImages, this.imageResolution, this.imageRendererResolution, this.alwaysSaveAsPNG, this.encoder);
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.add(picture);
            if (this.state.bookmark != null) {
                this.endBookmark();
            }
        }
        this.state = this.state.restore();
    }

    public void startInline(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(14);
        if (!this.state.skip && valueArray[125] != null) {
            this.startBookmark(valueArray[125].id(), context);
        }
    }

    private void startBookmark(String string, Context context) {
        this.state.bookmark = new Bookmark(this.bookmarkId++, string, context);
        if (this.paragraph == null) {
            this.startParagraph(context);
        }
        this.paragraph.add(this.state.bookmark.start(this.encoder));
    }

    private void endBookmark() {
        this.paragraph.add(this.state.bookmark.end());
    }

    public void endInline(Context context) throws Exception {
        if (!this.state.skip && this.state.bookmark != null) {
            this.endBookmark();
        }
        this.state = this.state.restore();
    }

    public void startInlineContainer(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(15);
    }

    public void endInlineContainer(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startLeader(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(18);
        if (!this.state.skip) {
            Leader leader = new Leader(context);
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.properties.addTab(leader.Tab());
            this.paragraph.add(new Paragraph.Tab(this.runProperties(context)));
            this.state.skip = true;
        }
    }

    public void endLeader(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startPageNumber(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(29);
        if (!this.state.skip) {
            if (valueArray[125] != null) {
                this.startBookmark(valueArray[125].id(), context);
            }
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.add(new PageNumber(this.runProperties(context)));
        }
    }

    public void endPageNumber(Context context) throws Exception {
        if (!this.state.skip && this.state.bookmark != null) {
            this.endBookmark();
        }
        this.state = this.state.restore();
    }

    public void startPageNumberCitation(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(30);
        if (!this.state.skip) {
            if (valueArray[125] != null) {
                this.startBookmark(valueArray[125].id(), context);
            }
            if (valueArray[226] != null) {
                String string = valueArray[226].idref();
                PageReference pageReference = new PageReference(string, context);
                pageReference.properties = this.runProperties(context);
                if (this.paragraph == null) {
                    this.startParagraph(context);
                }
                this.paragraph.add(pageReference);
            }
        }
    }

    public void endPageNumberCitation(Context context) throws Exception {
        if (!this.state.skip && this.state.bookmark != null) {
            this.endBookmark();
        }
        this.state = this.state.restore();
    }

    public void startTableAndCaption(Value[] valueArray, Context context) throws Exception {
        if (!this.state.skip && this.paragraph != null) {
            this.endParagraph();
        }
        this.state = this.state.update(46);
        if (!this.state.skip) {
            this.state.tableAndCaption = new TableAndCaption(context);
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
        }
    }

    public void endTableAndCaption(Context context) throws Exception {
        TableAndCaption tableAndCaption = null;
        if (!this.state.skip) {
            tableAndCaption = this.state.tableAndCaption;
        }
        this.state = this.state.restore();
        if (tableAndCaption != null) {
            int n = this.state.context;
            if (n == 3) {
                n = this.state.parentContext();
            }
            switch (n) {
                case 4: {
                    this.state.table.add(tableAndCaption);
                    break;
                }
                case 7: {
                    tableAndCaption.layout(this.state.referenceWidth);
                    this.staticContent.add(tableAndCaption);
                    break;
                }
                default: {
                    tableAndCaption.layout(this.state.referenceWidth);
                    tableAndCaption.print(this.tmpWriter, this.encoder);
                }
            }
        }
    }

    public void startTable(Value[] valueArray, Context context) throws Exception {
        if (!this.state.skip && this.paragraph != null) {
            this.endParagraph();
        }
        this.state = this.state.update(45);
        if (!this.state.skip) {
            this.state.table = new Table(context);
            if (context.parent().fo == 46) {
                this.state.tableAndCaption.table = this.state.table;
            }
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
        }
    }

    public void endTable(Context context) throws Exception {
        Table table = null;
        if (!this.state.skip && context.parent().fo != 46) {
            table = this.state.table;
        }
        this.state = this.state.restore();
        if (table != null) {
            int n = this.state.context;
            if (n == 3) {
                n = this.state.parentContext();
            }
            switch (n) {
                case 4: {
                    this.state.table.add(table);
                    break;
                }
                case 7: {
                    table.layout(this.state.referenceWidth);
                    this.staticContent.add(table);
                    break;
                }
                default: {
                    table.layout(this.state.referenceWidth);
                    table.print(this.tmpWriter, this.encoder);
                }
            }
        }
    }

    public void startTableColumn(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(50);
        if (!this.state.skip) {
            this.state.table.setColumn(context);
        }
    }

    public void endTableColumn(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startTableCaption(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(48);
        if (!this.state.skip) {
            this.state.tableAndCaption.caption = new Caption(context);
            this.state.bookmarks = this.bookmarks;
            this.bookmarks = null;
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
        }
    }

    public void endTableCaption(Context context) throws Exception {
        if (!this.state.skip) {
            this.bookmarks = this.state.bookmarks;
        }
        this.state = this.state.restore();
    }

    public void startTableHeader(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(52);
        if (!this.state.skip) {
            this.state.table.startHeader(context);
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
        }
    }

    public void endTableHeader(Context context) throws Exception {
        if (!this.state.skip) {
            this.state.table.endHeader();
        }
        this.state = this.state.restore();
    }

    public void startTableFooter(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(51);
        if (!this.state.skip) {
            this.state.table.startFooter(context);
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
        }
    }

    public void endTableFooter(Context context) throws Exception {
        if (!this.state.skip) {
            this.state.table.endFooter();
        }
        this.state = this.state.restore();
    }

    public void startTableBody(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(47);
        if (!this.state.skip) {
            this.state.table.startBody(context);
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
        }
    }

    public void endTableBody(Context context) throws Exception {
        if (!this.state.skip) {
            this.state.table.endBody();
        }
        this.state = this.state.restore();
    }

    public void startTableRow(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(53);
        if (!this.state.skip) {
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
            this.state.table.startRow(context, this.bookmarks);
            this.bookmarks = null;
        }
    }

    public void endTableRow(Context context) throws Exception {
        if (!this.state.skip) {
            this.state.table.endRow();
        }
        this.state = this.state.restore();
    }

    public void startTableCell(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(49);
        if (!this.state.skip) {
            this.state.table.startCell(context);
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
            context.background = null;
        }
    }

    public void endTableCell(Context context) throws Exception {
        if (!this.state.skip) {
            this.state.table.endCell();
        }
        this.state = this.state.restore();
    }

    public void startListBlock(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(19);
        if (!this.state.skip) {
            if (this.paragraph != null) {
                this.endParagraph();
            }
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
            if (this.state.context == 3 && this.state.list.item != null) {
                this.startParagraph(context);
                this.endParagraph();
            }
            this.state.list = new List(context);
        }
    }

    public void endListBlock(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startListItem(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(20);
        if (!this.state.skip && valueArray[125] != null) {
            this.addBookmark(valueArray[125].id(), context);
        }
    }

    public void endListItem(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startListItemBody(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(21);
        if (!this.state.skip && valueArray[125] != null) {
            this.addBookmark(valueArray[125].id(), context);
        }
    }

    public void endListItemBody(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startListItemLabel(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(22);
        if (!this.state.skip && valueArray[125] != null) {
            this.addBookmark(valueArray[125].id(), context);
        }
    }

    public void endListItemLabel(Context context) throws Exception {
        if (!this.state.skip) {
            if (this.state.list.item == null) {
                this.state.list.item = new List.Item();
                this.state.list.item.label = new List.Item.Label();
            }
            if (this.state.list.id < 0) {
                ListTable.List list = this.state.list.item.label.list(this.state.list.labelFormat);
                if (list == null) {
                    this.state.list.id = 0;
                    this.state.list.plainText = true;
                } else {
                    this.state.list.id = this.listTable.add(list);
                }
            }
        }
        this.state = this.state.restore();
    }

    public void startBasicLink(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(0);
        if (!this.state.skip) {
            if (valueArray[125] != null) {
                this.startBookmark(valueArray[125].id(), context);
            }
            this.state.link = new Link(context);
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.add(this.state.link.start(this.encoder));
        }
    }

    public void endBasicLink(Context context) throws Exception {
        if (!this.state.skip) {
            this.paragraph.add(this.state.link.end());
            if (this.state.bookmark != null) {
                this.endBookmark();
            }
        }
        this.state = this.state.restore();
    }

    public void startMultiSwitch(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiSwitch(Context context) throws Exception {
    }

    public void startMultiCase(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiCase(Context context) throws Exception {
    }

    public void startMultiToggle(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiToggle(Context context) throws Exception {
    }

    public void startMultiProperties(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiProperties(Context context) throws Exception {
    }

    public void startMultiPropertySet(Value[] valueArray, Context context) throws Exception {
    }

    public void endMultiPropertySet(Context context) throws Exception {
    }

    public void startFloat(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(9);
    }

    public void endFloat(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startFootnote(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(11);
    }

    public void endFootnote(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startFootnoteBody(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(12);
        if (!this.state.skip) {
            this.state.footnote = new Footnote();
            this.state.paragraph = this.paragraph;
            this.state.bookmarks = this.bookmarks;
            this.paragraph = null;
            this.bookmarks = null;
            if (valueArray[125] != null) {
                this.addBookmark(valueArray[125].id(), context);
            }
        }
    }

    public void endFootnoteBody(Context context) throws Exception {
        if (!this.state.skip) {
            this.paragraph = this.state.paragraph;
            this.bookmarks = this.state.bookmarks;
            if (this.paragraph == null) {
                this.startParagraph(context);
            }
            this.paragraph.add(this.state.footnote);
        }
        this.state = this.state.restore();
    }

    public void startWrapper(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(55);
        if (!this.state.skip && valueArray[125] != null) {
            this.addBookmark(valueArray[125].id(), context);
        }
    }

    public void endWrapper(Context context) throws Exception {
        if (!this.state.skip && this.bookmarks != null && this.paragraph != null) {
            int n;
            if (this.paragraph.bookmarks != null) {
                for (n = 0; n < this.paragraph.bookmarks.length; ++n) {
                    this.bookmarks.insertElementAt(this.paragraph.bookmarks[n], n);
                }
            }
            this.paragraph.bookmarks = new Bookmark[this.bookmarks.size()];
            for (n = 0; n < this.paragraph.bookmarks.length; ++n) {
                this.paragraph.bookmarks[n] = (Bookmark)this.bookmarks.elementAt(n);
            }
            this.bookmarks = null;
        }
        this.state = this.state.restore();
    }

    public void startMarker(Value[] valueArray, Context context) throws Exception {
        this.state = this.state.update(23);
    }

    public void endMarker(Context context) throws Exception {
        this.state = this.state.restore();
    }

    public void startRetrieveMarker(Value[] valueArray, Context context) throws Exception {
    }

    public void endRetrieveMarker(Context context) throws Exception {
    }
}

