/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.font;

import com.xmlmind.fo.font.FontUtil;
import java.util.StringTokenizer;

public final class GenericFamilies
implements Cloneable {
    public String serif;
    public String sansSerif;
    public String monospace;
    public String cursive;
    public String fantasy;

    public static GenericFamilies fromString(String string) {
        try {
            GenericFamilies genericFamilies = new GenericFamilies();
            GenericFamilies.parse(string, genericFamilies);
            return genericFamilies;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static void parse(String string, GenericFamilies genericFamilies) throws IllegalArgumentException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n > 0 && n < string2.length() - 1) {
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                String string5 = FontUtil.normalizeFamily(string4);
                if (string5 != null) {
                    String string6 = FontUtil.normalizeFamily(string3);
                    if ("serif".equals(string6)) {
                        genericFamilies.serif = string5;
                        continue;
                    }
                    if ("sans-serif".equals(string6)) {
                        genericFamilies.sansSerif = string5;
                        continue;
                    }
                    if ("monospace".equals(string6)) {
                        genericFamilies.monospace = string5;
                        continue;
                    }
                    if ("cursive".equals(string6)) {
                        genericFamilies.cursive = string5;
                        continue;
                    }
                    if ("fantasy".equals(string6)) {
                        genericFamilies.fantasy = string5;
                        continue;
                    }
                    throw new IllegalArgumentException("'" + string3 + "', not a generic font family");
                }
                throw new IllegalArgumentException("'" + string4 + "', invalid actual font family");
            }
            throw new IllegalArgumentException("'" + string2 + "', invalid font family mapping");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        if (this.serif != null) {
            stringBuffer.append("serif=");
            stringBuffer.append(this.serif);
            ++n;
        }
        if (this.sansSerif != null) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append("sans-serif=");
            stringBuffer.append(this.sansSerif);
            ++n;
        }
        if (this.monospace != null) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append("monospace=");
            stringBuffer.append(this.monospace);
            ++n;
        }
        if (this.cursive != null) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append("cursive=");
            stringBuffer.append(this.cursive);
            ++n;
        }
        if (this.fantasy != null) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append("fantasy=");
            stringBuffer.append(this.fantasy);
            ++n;
        }
        return stringBuffer.toString();
    }
}

