/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.graphic;

import com.xmlmind.fo.graphic.AutoRegisterFactories;
import com.xmlmind.fo.graphic.Graphic;
import com.xmlmind.fo.graphic.GraphicEnv;
import com.xmlmind.fo.graphic.GraphicFactory;
import com.xmlmind.fo.util.StringUtil;
import com.xmlmind.fo.util.URLUtil;

public final class GraphicFactories {
    private static Object lock = new Object();
    private static GraphicFactory[] factories = new GraphicFactory[0];

    private GraphicFactories() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(GraphicFactory graphicFactory) {
        Object object = lock;
        synchronized (object) {
            int n = factories.length;
            GraphicFactory[] graphicFactoryArray = new GraphicFactory[n + 1];
            System.arraycopy(factories, 0, graphicFactoryArray, 0, n);
            graphicFactoryArray[n] = graphicFactory;
            factories = graphicFactoryArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphicFactory get(String string) {
        string = URLUtil.normalizeMIMEType(string);
        Object object = lock;
        synchronized (object) {
            for (int i = factories.length - 1; i >= 0; --i) {
                GraphicFactory graphicFactory = factories[i];
                String[] stringArray = graphicFactory.getInputFormats();
                if (!StringUtil.contains(stringArray, string)) continue;
                return graphicFactory;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GraphicFactory get(String string, String string2) {
        string = URLUtil.normalizeMIMEType(string);
        string2 = URLUtil.normalizeMIMEType(string2);
        Object object = lock;
        synchronized (object) {
            for (int i = factories.length - 1; i >= 0; --i) {
                GraphicFactory graphicFactory = factories[i];
                String[] stringArray = graphicFactory.getInputFormats();
                if (!StringUtil.contains(stringArray, string) || !StringUtil.contains(stringArray = graphicFactory.getOutputFormats(), string2)) continue;
                return graphicFactory;
            }
            return null;
        }
    }

    public static Graphic createGraphic(String string, String string2, Object object, GraphicEnv graphicEnv) throws Exception {
        GraphicFactory graphicFactory = GraphicFactories.get(string2);
        if (graphicFactory == null) {
            throw new RuntimeException("'" + string2 + "', unsupported graphic format");
        }
        return graphicFactory.createGraphic(string, string2, object, graphicEnv);
    }

    public static Graphic convertGraphic(Graphic graphic, String string, double d, double d2, Object object, GraphicEnv graphicEnv) throws Exception {
        return GraphicFactories.convertGraphic(graphic, new String[]{string}, d, d2, object, graphicEnv);
    }

    public static Graphic convertGraphic(Graphic graphic, String[] stringArray, double d, double d2, Object object, GraphicEnv graphicEnv) throws Exception {
        int n;
        String string = graphic.getFormat();
        String string2 = null;
        GraphicFactory graphicFactory = null;
        if ("image/jpeg".equals(string) && StringUtil.contains(stringArray, "image/jpeg") && (graphicFactory = GraphicFactories.get("image/jpeg", "image/jpeg")) != null) {
            string2 = "image/jpeg";
        }
        if (graphicFactory == null) {
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                if ("image/jpeg".equals(stringArray[n]) || (graphicFactory = GraphicFactories.get(string, stringArray[n])) == null) continue;
                string2 = stringArray[n];
                break;
            }
        }
        if (graphicFactory == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < stringArray.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append('\'');
                stringBuffer.append(stringArray[n]);
                stringBuffer.append('\'');
            }
            throw new RuntimeException("don't know how to convert a '" + string + "' graphic to any of the following formats: " + stringBuffer.toString());
        }
        return graphicFactory.convertGraphic(graphic, string2, d, d2, object, graphicEnv);
    }

    static {
        AutoRegisterFactories.registerAll();
    }
}

