/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.graphic;

import com.xmlmind.fo.graphic.Graphic;
import com.xmlmind.fo.graphic.GraphicEnv;
import com.xmlmind.fo.graphic.GraphicFactory;
import com.xmlmind.fo.graphic.GraphicImpl;
import com.xmlmind.fo.graphic.GraphicUtil;
import com.xmlmind.fo.util.URLUtil;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class GraphicFactoryImpl
implements GraphicFactory {
    private String[] inputFormats;
    private String[] outputFormats;

    public GraphicFactoryImpl() {
        String string;
        int n;
        String[] stringArray;
        ImageReaderWriterSpi imageReaderWriterSpi;
        IIORegistry iIORegistry = IIORegistry.getDefaultInstance();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = null;
        try {
            iterator = iIORegistry.getServiceProviders(ImageReaderSpi.class, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                imageReaderWriterSpi = (ImageReaderSpi)iterator.next();
                stringArray = imageReaderWriterSpi.getMIMETypes();
                if (stringArray == null) continue;
                for (n = 0; n < stringArray.length; ++n) {
                    string = URLUtil.normalizeMIMEType(stringArray[n]);
                    if (string == null || string.length() <= 0) continue;
                    hashMap.put(string, string);
                }
            }
        }
        this.inputFormats = new String[hashMap.size()];
        hashMap.values().toArray(this.inputFormats);
        hashMap.clear();
        iterator = null;
        try {
            iterator = iIORegistry.getServiceProviders(ImageWriterSpi.class, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                imageReaderWriterSpi = (ImageWriterSpi)iterator.next();
                stringArray = imageReaderWriterSpi.getMIMETypes();
                if (stringArray == null) continue;
                for (n = 0; n < stringArray.length; ++n) {
                    string = URLUtil.normalizeMIMEType(stringArray[n]);
                    if (!"image/png".equals(string) && !"image/jpeg".equals(string)) continue;
                    hashMap.put(string, string);
                }
            }
        }
        this.outputFormats = new String[hashMap.size()];
        hashMap.values().toArray(this.outputFormats);
    }

    public String[] getInputFormats() {
        return this.inputFormats;
    }

    public String[] getOutputFormats() {
        return this.outputFormats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graphic createGraphic(String string, String string2, Object object, GraphicEnv graphicEnv) throws Exception {
        int n;
        int n2;
        string2 = URLUtil.normalizeMIMEType(string2);
        double d = 0.0;
        double d2 = 0.0;
        ImageReader imageReader = GraphicFactoryImpl.getImageReader(string2);
        try {
            InputStream inputStream = URLUtil.openStream(string);
            try {
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
                if (imageInputStream == null) {
                    throw new RuntimeException("cannot create an ImageInputStream out of a java.io.InputStream");
                }
                try {
                    imageReader.setInput(imageInputStream, true, false);
                    n2 = imageReader.getWidth(0);
                    n = imageReader.getHeight(0);
                    double[] dArray = GraphicFactoryImpl.getResolution(imageReader);
                    if (dArray != null) {
                        d = dArray[0];
                        d2 = dArray[1];
                    }
                }
                finally {
                    imageInputStream.close();
                }
            }
            finally {
                inputStream.close();
            }
        }
        finally {
            imageReader.dispose();
        }
        return new GraphicImpl(string, string2, n2, n, d, d2, object);
    }

    private static ImageReader getImageReader(String string) {
        ImageReader imageReader = null;
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByMIMEType(string);
        if (iterator.hasNext()) {
            imageReader = iterator.next();
        }
        if (imageReader == null) {
            throw new RuntimeException("don't know how to read '" + string + "' images");
        }
        return imageReader;
    }

    private static double[] getResolution(ImageReader imageReader) throws Exception {
        Element element;
        Node node;
        IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
        if (iIOMetadata != null && (node = iIOMetadata.getAsTree("javax_imageio_1.0")) != null && (element = GraphicFactoryImpl.getChildElementByTag(node, "Dimension")) != null) {
            double d = 0.0;
            double d2 = 0.0;
            for (Node node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                String string = node2.getNodeName();
                if ("HorizontalPixelSize".equals(string)) {
                    d = GraphicFactoryImpl.getDoubleAttribute((Element)node2, "value");
                    continue;
                }
                if (!"VerticalPixelSize".equals(string)) continue;
                d2 = GraphicFactoryImpl.getDoubleAttribute((Element)node2, "value");
            }
            if (d > 0.0 && d2 > 0.0) {
                return new double[]{25.4 / d, 25.4 / d2};
            }
        }
        return null;
    }

    private static Element getChildElementByTag(Node node, String string) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!string.equals(node2.getNodeName())) continue;
            return (Element)node2;
        }
        return null;
    }

    private static double getDoubleAttribute(Element element, String string) {
        String string2 = element.getAttribute(string);
        if (string2 == null || string2.length() == 0) {
            return -1.0;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0;
        }
    }

    public Graphic convertGraphic(Graphic graphic, String string, double d, double d2, Object object, GraphicEnv graphicEnv) throws Exception {
        int n;
        int n2;
        File file;
        string = URLUtil.normalizeMIMEType(string);
        if (d <= 0.0) {
            d = 1.0;
        }
        if (d2 <= 0.0) {
            d2 = 1.0;
        }
        double d3 = graphic.getXResolution();
        double d4 = graphic.getYResolution();
        if (graphic.getFormat().equals(string) && d == 1.0 && d2 == 1.0) {
            file = graphicEnv.createTempFile(GraphicUtil.formatToSuffix(string));
            GraphicUtil.saveGraphic(graphic, file);
            n2 = graphic.getWidth();
            n = graphic.getHeight();
        } else {
            BufferedImage bufferedImage = GraphicFactoryImpl.readImage(graphic);
            if (d != 1.0 || d2 != 1.0) {
                bufferedImage = GraphicFactoryImpl.scaleImage(bufferedImage, d, d2);
            }
            file = graphicEnv.createTempFile(GraphicUtil.formatToSuffix(string));
            GraphicFactoryImpl.writeImage(bufferedImage, d3, d4, string, file, graphicEnv);
            n2 = bufferedImage.getWidth();
            n = bufferedImage.getHeight();
        }
        return new GraphicImpl(URLUtil.fileToLocation(file), string, n2, n, d3, d4, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage readImage(Graphic graphic) throws Exception {
        BufferedImage bufferedImage;
        ImageReader imageReader = GraphicFactoryImpl.getImageReader(graphic.getFormat());
        try {
            InputStream inputStream = URLUtil.openStream(graphic.getLocation());
            try {
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
                if (imageInputStream == null) {
                    throw new RuntimeException("cannot create an ImageInputStream out of a java.io.InputStream");
                }
                try {
                    ImageReadParam imageReadParam = imageReader.getDefaultReadParam();
                    imageReader.setInput(imageInputStream, true, true);
                    bufferedImage = imageReader.read(0, imageReadParam);
                }
                finally {
                    imageInputStream.close();
                }
            }
            finally {
                inputStream.close();
            }
        }
        finally {
            imageReader.dispose();
        }
        return bufferedImage;
    }

    public static BufferedImage scaleImage(BufferedImage bufferedImage, double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToScale(d, d2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        return bufferedImage2;
    }

    public static void writeImage(BufferedImage bufferedImage, double d, double d2, String string, File file) throws Exception {
        GraphicFactoryImpl.writeImage(bufferedImage, d, d2, string, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeImage(BufferedImage object, double d, double d2, String string, File file, GraphicEnv graphicEnv) throws Exception {
        Object object2;
        Object object3;
        if ("image/jpeg".equals(string) && ((BufferedImage)object).getType() == 2) {
            object3 = new BufferedImage(((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight(), 1);
            object2 = new ColorConvertOp(null);
            ((ColorConvertOp)object2).filter((BufferedImage)object, (BufferedImage)object3);
            object = object3;
        }
        object3 = GraphicFactoryImpl.getImageWriter(string);
        try {
            object2 = new FileImageOutputStream(file);
            try {
                ImageTypeSpecifier imageTypeSpecifier;
                ((ImageWriter)object3).setOutput(object2);
                ImageWriteParam imageWriteParam = ((ImageWriter)object3).getDefaultWriteParam();
                IIOMetadata iIOMetadata = null;
                if (d > 0.0 && d2 > 0.0 && !GraphicFactoryImpl.setResolution(iIOMetadata = ((ImageWriter)object3).getDefaultImageMetadata(imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage((RenderedImage)object), imageWriteParam), d, d2, string) && graphicEnv != null) {
                    graphicEnv.reportWarning("cannot set the resolution of '" + file + "' to " + Double.toString(d) + "x" + Double.toString(d2) + "DPI");
                }
                ((ImageWriter)object3).write(null, new IIOImage((RenderedImage)object, null, iIOMetadata), imageWriteParam);
                ((ImageInputStreamImpl)object2).flush();
            }
            finally {
                ((FileImageOutputStream)object2).close();
            }
        }
        finally {
            ((ImageWriter)object3).dispose();
        }
    }

    private static boolean setResolution(IIOMetadata iIOMetadata, double d, double d2, String string) throws Exception {
        if (iIOMetadata.isReadOnly()) {
            return false;
        }
        if ("image/png".equals(string)) {
            Node node = iIOMetadata.getAsTree("javax_imageio_png_1.0");
            Element element = GraphicFactoryImpl.getChildElementByTag(node, "pHYs");
            if (element == null) {
                element = new IIOMetadataNode("pHYs");
                node.appendChild(element);
            }
            element.setAttribute("unitSpecifier", "meter");
            int n = (int)Math.rint(d * 39.37);
            element.setAttribute("pixelsPerUnitXAxis", Integer.toString(n));
            int n2 = (int)Math.rint(d2 * 39.37);
            element.setAttribute("pixelsPerUnitYAxis", Integer.toString(n2));
            iIOMetadata.setFromTree("javax_imageio_png_1.0", node);
            return true;
        }
        if ("image/jpeg".equals(string)) {
            if (!iIOMetadata.isStandardMetadataFormatSupported()) {
                return false;
            }
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("javax_imageio_1.0");
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Dimension");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("HorizontalPixelSize");
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            iIOMetadataNode3.setAttribute("value", Double.toString(0.254 / d));
            IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("VerticalPixelSize");
            iIOMetadataNode2.appendChild(iIOMetadataNode4);
            iIOMetadataNode4.setAttribute("value", Double.toString(0.254 / d2));
            iIOMetadata.mergeTree("javax_imageio_1.0", iIOMetadataNode);
            return true;
        }
        return false;
    }

    private static ImageWriter getImageWriter(String string) {
        ImageWriter imageWriter = null;
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType(string);
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        if (imageWriter == null) {
            throw new RuntimeException("don't know how to write '" + string + "' images");
        }
        return imageWriter;
    }
}

