/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.graphic;

import com.xmlmind.fo.graphic.Graphic;
import com.xmlmind.fo.graphic.GraphicEnv;
import com.xmlmind.fo.util.FileUtil;
import com.xmlmind.fo.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public final class GraphicUtil {
    private GraphicUtil() {
    }

    public static String extensionToFormat(File file) {
        return GraphicUtil.extensionToFormat(file.getPath());
    }

    public static String extensionToFormat(String string) {
        if ((string = string.toLowerCase()).endsWith(".png")) {
            return "image/png";
        }
        if (string.endsWith(".jpg") || string.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (string.endsWith(".gif")) {
            return "image/gif";
        }
        if (string.endsWith(".tif") || string.endsWith(".tiff")) {
            return "image/tiff";
        }
        if (string.endsWith(".bmp")) {
            return "image/bmp";
        }
        if (string.endsWith(".emf")) {
            return "image/x-emf";
        }
        if (string.endsWith(".wmf")) {
            return "image/x-wmf";
        }
        if (string.endsWith(".svg")) {
            return "image/svg+xml";
        }
        if (string.endsWith(".mml")) {
            return "application/mathml+xml";
        }
        if (string.endsWith(".pdf")) {
            return "application/pdf";
        }
        if (string.endsWith(".ps")) {
            return "application/ps";
        }
        if (string.endsWith(".eps") || string.endsWith(".epsi") || string.endsWith(".epsf")) {
            return "image/x-eps";
        }
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return "image/" + string.substring(n + 1);
        }
        return "image/" + string;
    }

    public static String formatToExtension(String string) {
        if ("image/jpeg".equals(string)) {
            return "jpg";
        }
        if ("image/tiff".equals(string)) {
            return "tif";
        }
        String string2 = null;
        int n = string.indexOf(47);
        if (n >= 0) {
            string2 = string.substring(n + 1);
            if (string2.startsWith("x-")) {
                string2 = string2.substring(2);
            }
            if ((n = string2.indexOf(43)) >= 0) {
                string2 = string2.substring(0, n);
            }
        }
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        return string2;
    }

    public static String formatToSuffix(String string) {
        String string2 = GraphicUtil.formatToExtension(string);
        if (string2 == null) {
            string2 = "img";
        }
        return "." + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveGraphic(Graphic graphic, File file) throws IOException {
        InputStream inputStream = URLUtil.openStream(graphic.getLocation());
        try {
            FileUtil.copyFile(inputStream, file);
        }
        finally {
            inputStream.close();
        }
    }

    public static String createTempFile(GraphicEnv graphicEnv, String string) throws Exception {
        return graphicEnv.createTempFile(string).getPath();
    }
}

