/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.graphic.emf;

import com.xmlmind.fo.graphic.Graphic;
import com.xmlmind.fo.graphic.GraphicEnv;
import com.xmlmind.fo.graphic.GraphicFactory;
import com.xmlmind.fo.graphic.GraphicImpl;
import com.xmlmind.fo.graphic.GraphicUtil;
import com.xmlmind.fo.graphic.emf.EMFHeader;
import com.xmlmind.fo.util.URLUtil;
import java.io.File;
import java.io.InputStream;

public final class EMFGraphicFactory
implements GraphicFactory {
    private static final String[] formats = new String[]{"image/x-emf", "image/emf"};

    public String[] getInputFormats() {
        return formats;
    }

    public String[] getOutputFormats() {
        return formats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graphic createGraphic(String string, String string2, Object object, GraphicEnv graphicEnv) throws Exception {
        double d;
        double d2;
        int n;
        int n2;
        string2 = EMFGraphicFactory.normalizeMIMEType(string2);
        InputStream inputStream = URLUtil.openStream(string);
        try {
            EMFHeader eMFHeader = EMFHeader.read(inputStream);
            n2 = eMFHeader.boundsRight - eMFHeader.boundsLeft;
            n = eMFHeader.boundsBottom - eMFHeader.boundsTop;
            d2 = (double)n2 * 2540.0 / (double)(eMFHeader.frameRight - eMFHeader.frameLeft);
            d = (double)n * 2540.0 / (double)(eMFHeader.frameBottom - eMFHeader.frameTop);
        }
        finally {
            inputStream.close();
        }
        return new GraphicImpl(string, string2, n2, n, d2, d, 0, object);
    }

    private static String normalizeMIMEType(String string) {
        if ("image/emf".equals(string = URLUtil.normalizeMIMEType(string))) {
            string = "image/x-emf";
        }
        return string;
    }

    public Graphic convertGraphic(Graphic graphic, String string, double d, double d2, Object object, GraphicEnv graphicEnv) throws Exception {
        string = EMFGraphicFactory.normalizeMIMEType(string);
        if (d <= 0.0) {
            d = 1.0;
        }
        if (d2 <= 0.0) {
            d2 = 1.0;
        }
        if (d != 1.0 || d2 != 1.0) {
            throw new UnsupportedOperationException("cannot scale (" + d + "x" + d2 + ") an EMF graphic");
        }
        File file = graphicEnv.createTempFile(".emf");
        GraphicUtil.saveGraphic(graphic, file);
        return new GraphicImpl(URLUtil.fileToLocation(file), string, graphic.getWidth(), graphic.getHeight(), graphic.getXResolution(), graphic.getYResolution(), 0, object);
    }
}

