/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.graphic.emf;

import com.xmlmind.fo.graphic.emf.EMFInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class EMFHeader {
    public long type;
    public long size;
    public int boundsLeft;
    public int boundsTop;
    public int boundsRight;
    public int boundsBottom;
    public int frameLeft;
    public int frameTop;
    public int frameRight;
    public int frameBottom;
    public long recordSignature;
    public long version;

    private EMFHeader() {
    }

    public static EMFHeader read(InputStream inputStream) throws IOException {
        EMFInputStream eMFInputStream = new EMFInputStream(inputStream);
        EMFHeader eMFHeader = new EMFHeader();
        eMFHeader.type = eMFInputStream.readDWORD();
        eMFHeader.size = eMFInputStream.readDWORD();
        eMFHeader.boundsLeft = eMFInputStream.readINT();
        eMFHeader.boundsTop = eMFInputStream.readINT();
        eMFHeader.boundsRight = eMFInputStream.readINT();
        eMFHeader.boundsBottom = eMFInputStream.readINT();
        eMFHeader.frameLeft = eMFInputStream.readINT();
        eMFHeader.frameTop = eMFInputStream.readINT();
        eMFHeader.frameRight = eMFInputStream.readINT();
        eMFHeader.frameBottom = eMFInputStream.readINT();
        eMFHeader.recordSignature = eMFInputStream.readDWORD();
        eMFHeader.version = eMFInputStream.readDWORD();
        if (eMFHeader.type != 1L) {
            throw new IOException("invalid 'type' field: 0x" + Long.toString(eMFHeader.type, 16));
        }
        if (eMFHeader.size != 88L && eMFHeader.size != 100L && eMFHeader.size != 108L) {
            throw new IOException("invalid 'size' field: " + eMFHeader.size);
        }
        if (eMFHeader.boundsLeft >= eMFHeader.boundsRight || eMFHeader.boundsTop >= eMFHeader.boundsBottom) {
            throw new IOException("invalid 'bounds' fields: " + eMFHeader.boundsLeft + " " + eMFHeader.boundsTop + " " + eMFHeader.boundsRight + " " + eMFHeader.boundsBottom);
        }
        if (eMFHeader.frameLeft >= eMFHeader.frameRight || eMFHeader.frameTop >= eMFHeader.frameBottom) {
            throw new IOException("invalid 'frame' fields: " + eMFHeader.frameLeft + " " + eMFHeader.frameTop + " " + eMFHeader.frameRight + " " + eMFHeader.frameBottom);
        }
        if (eMFHeader.recordSignature != 1179469088L) {
            throw new IOException("invalid 'recordSignature' field: 0x" + Long.toString(eMFHeader.recordSignature, 16));
        }
        if (eMFHeader.version != 65536L) {
            throw new IOException("invalid 'version' field: 0x" + Long.toString(eMFHeader.version, 16));
        }
        return eMFHeader;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EMFHeader[bounds=");
        stringBuffer.append(this.boundsLeft);
        stringBuffer.append(' ');
        stringBuffer.append(this.boundsTop);
        stringBuffer.append(' ');
        stringBuffer.append(this.boundsRight);
        stringBuffer.append(' ');
        stringBuffer.append(this.boundsBottom);
        stringBuffer.append(", frame=");
        stringBuffer.append(this.frameLeft);
        stringBuffer.append(' ');
        stringBuffer.append(this.frameTop);
        stringBuffer.append(' ');
        stringBuffer.append(this.frameRight);
        stringBuffer.append(' ');
        stringBuffer.append(this.frameBottom);
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

