/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.graphic.emf;

import com.xmlmind.fo.graphic.Graphic;
import com.xmlmind.fo.graphic.GraphicEnv;
import com.xmlmind.fo.graphic.GraphicFactory;
import com.xmlmind.fo.graphic.GraphicImpl;
import com.xmlmind.fo.graphic.GraphicUtil;
import com.xmlmind.fo.graphic.emf.WMFHeader;
import com.xmlmind.fo.util.URLUtil;
import java.io.File;
import java.io.InputStream;

public final class WMFGraphicFactory
implements GraphicFactory {
    private static final String[] formats = new String[]{"image/x-wmf", "image/wmf"};

    public String[] getInputFormats() {
        return formats;
    }

    public String[] getOutputFormats() {
        return formats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Graphic createGraphic(String string, String string2, Object object, GraphicEnv graphicEnv) throws Exception {
        double d;
        double d2;
        int n;
        int n2;
        string2 = WMFGraphicFactory.normalizeMIMEType(string2);
        InputStream inputStream = URLUtil.openStream(string);
        try {
            WMFHeader wMFHeader = WMFHeader.read(inputStream);
            n2 = wMFHeader.right - wMFHeader.left;
            n = wMFHeader.bottom - wMFHeader.top;
            d = d2 = (double)wMFHeader.inch;
        }
        finally {
            inputStream.close();
        }
        return new GraphicImpl(string, string2, n2, n, d, d2, 0, object);
    }

    private static String normalizeMIMEType(String string) {
        if ("image/wmf".equals(string = URLUtil.normalizeMIMEType(string))) {
            string = "image/x-wmf";
        }
        return string;
    }

    public Graphic convertGraphic(Graphic graphic, String string, double d, double d2, Object object, GraphicEnv graphicEnv) throws Exception {
        string = WMFGraphicFactory.normalizeMIMEType(string);
        if (d <= 0.0) {
            d = 1.0;
        }
        if (d2 <= 0.0) {
            d2 = 1.0;
        }
        if (d != 1.0 || d2 != 1.0) {
            throw new UnsupportedOperationException("cannot scale (" + d + "x" + d2 + ") a WMF graphic");
        }
        File file = graphicEnv.createTempFile(".wmf");
        GraphicUtil.saveGraphic(graphic, file);
        return new GraphicImpl(URLUtil.fileToLocation(file), string, graphic.getWidth(), graphic.getHeight(), graphic.getXResolution(), graphic.getYResolution(), 0, object);
    }
}

