/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.objects;

import com.xmlmind.fo.graphic.GraphicUtil;
import com.xmlmind.fo.properties.Keyword;
import com.xmlmind.fo.properties.Value;
import java.io.PrintStream;

public class ExternalGraphic {
    public String src;
    public Value contentType;
    public Value width;
    public Value height;
    public Value contentWidth;
    public Value contentHeight;
    public int scaling;
    public int scalingMethod;
    public int textAlign;
    public int displayAlign;
    public int overflow;
    public String role;

    public ExternalGraphic(String string, String string2) {
        this.src = string;
        this.contentType = new Value(15, "content-type:" + string2);
        this.width = Value.KEYWORD_AUTO;
        this.height = Value.KEYWORD_AUTO;
        this.contentWidth = Value.KEYWORD_AUTO;
        this.contentHeight = Value.KEYWORD_AUTO;
        this.scaling = 214;
        this.scalingMethod = 10;
        this.textAlign = 100;
        this.displayAlign = 10;
        this.overflow = 10;
        this.role = null;
    }

    public ExternalGraphic(Value[] valueArray) {
        if (valueArray[276] != null) {
            this.src = valueArray[276].uriSpecification();
        }
        this.contentType = valueArray[85];
        this.width = valueArray[308];
        this.height = valueArray[118];
        this.contentWidth = valueArray[86];
        this.contentHeight = valueArray[84];
        this.scaling = valueArray[239].keyword();
        this.scalingMethod = valueArray[240].keyword();
        this.textAlign = valueArray[289].type == 1 ? valueArray[289].keyword() : 100;
        this.displayAlign = valueArray[93].keyword();
        this.overflow = valueArray[191].keyword();
        if (valueArray[236] != null) {
            this.role = valueArray[236].string();
        }
    }

    public String mimeType() {
        String string = null;
        if (this.contentType.type == 15) {
            String string2 = this.contentType.string();
            if (string2.startsWith("content-type:")) {
                string = string2.substring(string2.indexOf(":") + 1);
            } else if (!string2.startsWith("namespace-prefix:")) {
                string = string2;
            }
        }
        if (string != null) {
            if ("image/jpg".equals(string)) {
                string = "image/jpeg";
            }
        } else if (this.src != null) {
            if (this.src.startsWith("data:")) {
                int n = this.src.indexOf(59, 5);
                if (n < 0) {
                    n = this.src.indexOf(44, 5);
                }
                if (n >= 5) {
                    string = this.src.substring(5, n).trim();
                }
                if (string == null || string.length() == 0) {
                    string = "text/plain";
                }
            } else {
                return GraphicUtil.extensionToFormat(this.src);
            }
        }
        return string;
    }

    public void dump(PrintStream printStream) {
        printStream.println("src = " + this.src);
        printStream.println("contentWidth = " + this.contentWidth.toString());
        printStream.println("contentHeight = " + this.contentHeight.toString());
        printStream.println("scaling = " + Keyword.keyword(this.scaling));
        printStream.println("scalingMethod = " + Keyword.keyword(this.scalingMethod));
        printStream.flush();
    }
}

