/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.properties;

import java.util.Hashtable;
import java.util.StringTokenizer;

public final class Color {
    public static final int AQUA = 0;
    public static final int BLACK = 1;
    public static final int BLUE = 2;
    public static final int FUCHSIA = 3;
    public static final int GRAY = 4;
    public static final int GREEN = 5;
    public static final int LIME = 6;
    public static final int MAROON = 7;
    public static final int NAVY = 8;
    public static final int OLIVE = 9;
    public static final int PURPLE = 10;
    public static final int RED = 11;
    public static final int SILVER = 12;
    public static final int TEAL = 13;
    public static final int WHITE = 14;
    public static final int YELLOW = 15;
    public static final int ORANGE = 16;
    public static final Color[] list = new Color[]{new Color("aqua", 127, 255, 212), new Color("black", 0, 0, 0), new Color("blue", 0, 0, 255), new Color("fuchsia", 0, 0, 0), new Color("gray", 190, 190, 190), new Color("green", 0, 255, 0), new Color("lime", 50, 205, 50), new Color("maroon", 176, 48, 96), new Color("navy", 0, 0, 128), new Color("olive", 85, 107, 47), new Color("purple", 160, 32, 240), new Color("red", 255, 0, 0), new Color("silver", 0, 0, 0), new Color("teal", 0, 0, 0), new Color("white", 255, 255, 255), new Color("yellow", 255, 255, 0), new Color("orange", 255, 165, 0)};
    private static final Hashtable indexes = new Hashtable();
    public String name;
    public int red;
    public int green;
    public int blue;

    public Color(String string, int n, int n2, int n3) {
        this.name = string;
        this.red = n;
        this.green = n2;
        this.blue = n3;
    }

    public Color(int n, int n2, int n3) {
        this(null, n, n2, n3);
    }

    public static Color parse(String string) {
        int n;
        int n2;
        int n3;
        int n4 = Color.index(string);
        if (n4 >= 0) {
            return list[n4];
        }
        if (string.startsWith("#")) {
            try {
                switch (string.length()) {
                    case 4: {
                        n3 = Integer.parseInt(string.substring(1, 2), 16);
                        n3 += n3 << 4;
                        n2 = Integer.parseInt(string.substring(2, 3), 16);
                        n2 += n2 << 4;
                        n = Integer.parseInt(string.substring(3, 4), 16);
                        n += n << 4;
                        break;
                    }
                    case 7: {
                        n3 = Integer.parseInt(string.substring(1, 3), 16);
                        n2 = Integer.parseInt(string.substring(3, 5), 16);
                        n = Integer.parseInt(string.substring(5, 7), 16);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        } else if (string.startsWith("rgb(") || string.startsWith("rgb-icc(")) {
            string = string.substring(string.startsWith("rgb-icc(") ? 8 : 4, string.length());
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,)");
            try {
                if (!stringTokenizer.hasMoreTokens()) {
                    return null;
                }
                n3 = Integer.parseInt(stringTokenizer.nextToken());
                if (!stringTokenizer.hasMoreTokens()) {
                    return null;
                }
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (!stringTokenizer.hasMoreTokens()) {
                    return null;
                }
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        } else {
            return null;
        }
        if (n3 < 0 || n3 > 255 || n2 < 0 || n2 > 255 || n < 0 || n > 255) {
            return null;
        }
        return new Color(n3, n2, n);
    }

    public static int index(String string) {
        Object v = indexes.get(string);
        if (v != null) {
            return (Integer)v;
        }
        return -1;
    }

    public String toString() {
        if (this.name == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("rgb(");
            stringBuffer.append(this.red + ", " + this.green + ", " + this.blue);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        return this.name;
    }

    static {
        for (int i = 0; i < list.length; ++i) {
            indexes.put(Color.list[i].name, new Integer(i));
        }
    }
}

