/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.util;

import java.io.File;
import java.io.IOException;

public final class SystemUtil {
    public static final int PLATFORM_WINDOWS = 1;
    public static final int PLATFORM_MAC_OS = 2;
    public static final int PLATFORM_GENERIC_UNIX = 3;
    public static final int PLATFORM = SystemUtil.platform();
    public static final boolean IS_WINDOWS = PLATFORM == 1;
    public static final boolean IS_UNIX = PLATFORM != 1;
    public static final boolean IS_MAC_OS = PLATFORM == 2;
    public static final boolean IS_GENERIC_UNIX = PLATFORM == 3;

    private SystemUtil() {
    }

    private static final int platform() {
        if (File.pathSeparatorChar == ';') {
            return 1;
        }
        String string = System.getProperty("os.name");
        if (string != null && string.toLowerCase().indexOf("mac") >= 0) {
            return 2;
        }
        return 3;
    }

    public static File homeDir() {
        return SystemUtil.userDir("user.home");
    }

    public static File currentWorkingDir() {
        return SystemUtil.userDir("user.dir");
    }

    private static File userDir(String string) {
        File file = null;
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                file = new File(string2).getCanonicalFile();
                if (!file.isDirectory()) {
                    file = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file;
    }

    public static File userPreferencesDir() {
        return SystemUtil.userPreferencesDir("XMLmind", "FOConverter", "xfc");
    }

    public static File userPreferencesDir(String string, String string2, String string3) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (IS_WINDOWS) {
            object = null;
            try {
                object = System.getenv("APPDATA");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (object != null && new File((String)object).isDirectory()) {
                stringBuffer.append((String)object);
                stringBuffer.append('\\');
                stringBuffer.append(string);
                stringBuffer.append('\\');
                stringBuffer.append(string2);
            }
        }
        if (stringBuffer.length() == 0) {
            object = SystemUtil.homeDir();
            if (object == null) {
                return null;
            }
            stringBuffer.append(((File)object).getPath());
            if (IS_WINDOWS) {
                String string4 = System.getProperty("os.name");
                if (string4 != null && string4.indexOf("Vista") >= 0) {
                    stringBuffer.append("\\AppData\\Roaming\\");
                } else {
                    stringBuffer.append("\\Application Data\\");
                }
                stringBuffer.append(string);
                stringBuffer.append('\\');
                stringBuffer.append(string2);
            } else if (IS_MAC_OS) {
                stringBuffer.append("/Library/Application Support/");
                stringBuffer.append(string);
                stringBuffer.append('/');
                stringBuffer.append(string2);
            } else {
                stringBuffer.append("/.");
                stringBuffer.append(string3);
            }
        }
        object = null;
        try {
            object = new File(stringBuffer.toString()).getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return object;
    }
}

