/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Vector;
import org.xml.sax.Attributes;

public final class XMLWriter {
    private final File outFile;
    private final Writer out;
    private Vector nsStack;
    private String rootElementNS;

    public XMLWriter(File file) throws IOException {
        this.outFile = file;
        this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
        this.out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.nsStack = new Vector();
        StackEntry stackEntry = this.pushEntry();
        stackEntry.add("xml", "http://www.w3.org/XML/1998/namespace");
        stackEntry.add("", "");
    }

    public File getOutputFile() {
        return this.outFile;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws IOException {
        if (this.rootElementNS == null) {
            this.rootElementNS = string;
        }
        this.out.write(60);
        this.out.write(string3);
        StackEntry stackEntry = this.pushEntry();
        this.definePrefix(string3, string, false);
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string4 = attributes.getQName(i);
            if (string4.startsWith("xmlns")) continue;
            String string5 = attributes.getURI(i);
            String string6 = attributes.getValue(i);
            this.out.write(32);
            this.out.write(string4);
            this.out.write("=\"");
            this.characters(string6);
            this.out.write(34);
            this.definePrefix(string4, string5, true);
        }
        stackEntry.declarePrefixes();
        this.out.write(62);
    }

    public void characters(String string) throws IOException {
        char[] cArray = string.toCharArray();
        this.characters(cArray, 0, cArray.length);
    }

    public void characters(char[] cArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        block7: for (int i = n; i < n3; ++i) {
            char c = cArray[i];
            switch (c) {
                case '\'': {
                    this.out.write("&apos;");
                    continue block7;
                }
                case '\"': {
                    this.out.write("&quot;");
                    continue block7;
                }
                case '<': {
                    this.out.write("&lt;");
                    continue block7;
                }
                case '>': {
                    this.out.write("&gt;");
                    continue block7;
                }
                case '&': {
                    this.out.write("&amp;");
                    continue block7;
                }
                default: {
                    this.out.write(c);
                }
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws IOException {
        this.out.write("</");
        this.out.write(string3);
        this.out.write(62);
        this.popEntry();
    }

    public void close() throws IOException {
        this.out.flush();
        this.out.close();
    }

    public String getRootElementNamespaceURI() {
        return this.rootElementNS;
    }

    private StackEntry pushEntry() {
        StackEntry stackEntry = new StackEntry();
        this.nsStack.addElement(stackEntry);
        return stackEntry;
    }

    private void popEntry() {
        this.nsStack.removeElementAt(this.nsStack.size() - 1);
    }

    private StackEntry topEntry() {
        return (StackEntry)this.nsStack.lastElement();
    }

    private boolean inScope(String string, String string2) {
        for (int i = this.nsStack.size() - 1; i >= 0; --i) {
            StackEntry stackEntry = (StackEntry)this.nsStack.elementAt(i);
            if (!stackEntry.contains(string, string2)) continue;
            return true;
        }
        return false;
    }

    private void definePrefix(String string, String string2, boolean bl) {
        int n = string.indexOf(58);
        String string3 = n <= 0 || n == string.length() - 1 ? "" : string.substring(0, n);
        if (bl && string3.length() == 0) {
            return;
        }
        if (this.inScope(string3, string2)) {
            return;
        }
        this.topEntry().add(string3, string2);
    }

    private class StackEntry {
        private String[] pairs;

        private StackEntry() {
        }

        public boolean contains(String string, String string2) {
            if (this.pairs != null) {
                for (int i = 0; i < this.pairs.length; i += 2) {
                    if (!string.equals(this.pairs[i]) || !string2.equals(this.pairs[i + 1])) continue;
                    return true;
                }
            }
            return false;
        }

        public void add(String string, String string2) {
            if (this.pairs == null) {
                this.pairs = new String[]{string, string2};
            } else {
                int n = this.pairs.length;
                String[] stringArray = new String[n + 2];
                System.arraycopy(this.pairs, 0, stringArray, 0, n);
                stringArray[n] = string;
                stringArray[n + 1] = string2;
                this.pairs = stringArray;
            }
        }

        public void declarePrefixes() throws IOException {
            if (this.pairs != null) {
                for (int i = 0; i < this.pairs.length; i += 2) {
                    String string = this.pairs[i];
                    String string2 = this.pairs[i + 1];
                    XMLWriter.this.out.write(32);
                    if (string.length() == 0) {
                        XMLWriter.this.out.write("xmlns");
                    } else {
                        XMLWriter.this.out.write("xmlns:");
                        XMLWriter.this.out.write(string);
                    }
                    XMLWriter.this.out.write("=\"");
                    XMLWriter.this.characters(string2);
                    XMLWriter.this.out.write(34);
                }
            }
        }
    }
}

