/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.fo.zip;

import com.xmlmind.fo.zip.ZipEntry;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class ZipFile {
    private static final int VERSION = 20;
    private Vector entries = new Vector();
    private Deflater deflater = new Deflater(-1, true);
    private OutputStream output;
    private int date;
    private int time;
    private int offset;
    private int size;

    public void add(String string, String string2) {
        this.add(new ZipEntry(string, string2));
    }

    public void add(String string, String string2, boolean bl) {
        this.add(new ZipEntry(string, string2, bl));
    }

    public void add(String string, String[] stringArray) {
        this.add(new ZipEntry(string, stringArray));
    }

    public void add(String string, String[] stringArray, boolean bl) {
        this.add(new ZipEntry(string, stringArray, bl));
    }

    public void add(String string, byte[] byArray) {
        this.add(new ZipEntry(string, byArray));
    }

    public void add(String string, byte[] byArray, boolean bl) {
        this.add(new ZipEntry(string, byArray, bl));
    }

    public void add(ZipEntry zipEntry) {
        if (zipEntry.name.endsWith("/")) {
            zipEntry.stored = true;
        }
        this.entries.addElement(zipEntry);
    }

    public void write(OutputStream outputStream) throws Exception {
        ZipEntry zipEntry;
        int n;
        this.output = outputStream;
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        this.date = ZipFile.dosDate(calendar);
        this.time = ZipFile.dosTime(calendar);
        this.offset = 0;
        this.size = 0;
        int n2 = this.entries.size();
        for (n = 0; n < n2; ++n) {
            zipEntry = (ZipEntry)this.entries.elementAt(n);
            zipEntry.flags = 8;
            zipEntry.compression = zipEntry.stored ? 0 : 8;
            zipEntry.crc = 0;
            zipEntry.compressedSize = 0;
            zipEntry.uncompressedSize = 0;
            zipEntry.offset = this.offset;
            if (zipEntry.data != null && zipEntry.stored) {
                zipEntry.flags = 0;
                zipEntry.crc = (int)ZipFile.crc(zipEntry.data);
                zipEntry.compressedSize = zipEntry.data.length;
                zipEntry.uncompressedSize = zipEntry.data.length;
            } else if (zipEntry.paths == null && zipEntry.data == null) {
                zipEntry.flags = 0;
            }
            this.writeLocalHeader(zipEntry);
            if (zipEntry.stored) {
                this.writeStored(zipEntry);
            } else {
                this.writeDeflated(zipEntry);
            }
            if (zipEntry.flags == 0) continue;
            this.writeDataDescriptor(zipEntry);
        }
        n2 = this.entries.size();
        for (n = 0; n < n2; ++n) {
            zipEntry = (ZipEntry)this.entries.elementAt(n);
            this.writeCentralHeader(zipEntry);
        }
        this.writeEndOfDirectory();
    }

    private void writeLocalHeader(ZipEntry zipEntry) throws Exception {
        this.writeDoubleWord(67324752);
        this.writeWord(20);
        this.writeWord(zipEntry.flags);
        this.writeWord(zipEntry.compression);
        this.writeWord(this.time);
        this.writeWord(this.date);
        this.writeDoubleWord(zipEntry.crc);
        this.writeDoubleWord(zipEntry.compressedSize);
        this.writeDoubleWord(zipEntry.uncompressedSize);
        this.writeWord(zipEntry.name.length());
        this.writeWord(0);
        this.writeString(zipEntry.name);
        this.offset += 30 + zipEntry.name.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStored(ZipEntry zipEntry) throws Exception {
        if (zipEntry.data != null) {
            this.output.write(zipEntry.data);
            this.offset += zipEntry.data.length;
        } else if (zipEntry.paths != null) {
            byte[] byArray = new byte[1024];
            CRC32 cRC32 = new CRC32();
            int n = zipEntry.paths.length;
            block3: for (int i = 0; i < n; ++i) {
                String string = zipEntry.paths[i];
                BufferedInputStream bufferedInputStream = new BufferedInputStream(ZipFile.openStream(string));
                try {
                    while (true) {
                        int n2;
                        if ((n2 = ((InputStream)bufferedInputStream).read(byArray, 0, byArray.length)) < 0) {
                            continue block3;
                        }
                        if (n2 <= 0) continue;
                        cRC32.update(byArray, 0, n2);
                        zipEntry.uncompressedSize += n2;
                        this.output.write(byArray, 0, n2);
                    }
                }
                finally {
                    ((InputStream)bufferedInputStream).close();
                }
            }
            zipEntry.crc = (int)cRC32.getValue();
            zipEntry.compressedSize = zipEntry.uncompressedSize;
            this.offset += zipEntry.uncompressedSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void writeDeflated(ZipEntry var1_1) throws Exception {
        var3_2 = new byte[1024];
        this.deflater.reset();
        if (var1_1.data != null) {
            var1_1.crc = (int)ZipFile.crc(var1_1.data);
            var1_1.uncompressedSize = var1_1.data.length;
            this.deflater.setInput(var1_1.data);
            while ((var2_3 = this.deflater.deflate(var3_2)) > 0) {
                var1_1.compressedSize += var2_3;
                this.output.write(var3_2, 0, var2_3);
            }
        } else if (var1_1.paths != null) {
            var4_4 = new byte[1024];
            var5_5 = new CRC32();
            var7_7 = var1_1.paths.length;
            block4: for (var6_6 = 0; var6_6 < var7_7; ++var6_6) {
                var8_8 = var1_1.paths[var6_6];
                var9_9 = new BufferedInputStream(ZipFile.openStream(var8_8));
                try {
                    block5: while (true) {
                        if ((var2_3 = var9_9.read(var4_4, 0, var4_4.length)) < 0) {
                            continue block4;
                        }
                        if (var2_3 <= 0) continue;
                        var5_5.update(var4_4, 0, var2_3);
                        var1_1.uncompressedSize += var2_3;
                        this.deflater.setInput(var4_4, 0, var2_3);
                        while (true) {
                            if ((var2_3 = this.deflater.deflate(var3_2)) > 0) ** break;
                            continue block5;
                            var1_1.compressedSize += var2_3;
                            this.output.write(var3_2, 0, var2_3);
                        }
                        break;
                    }
                }
                finally {
                    var9_9.close();
                }
            }
            var1_1.crc = (int)var5_5.getValue();
        }
        this.deflater.finish();
        while ((var2_3 = this.deflater.deflate(var3_2)) > 0) {
            var1_1.compressedSize += var2_3;
            this.output.write(var3_2, 0, var2_3);
        }
        this.offset += var1_1.compressedSize;
    }

    private static InputStream openStream(String string) throws IOException {
        try {
            URL uRL = new URL(string);
            return uRL.openStream();
        }
        catch (MalformedURLException malformedURLException) {
            return new FileInputStream(string);
        }
    }

    private void writeDataDescriptor(ZipEntry zipEntry) throws IOException {
        this.writeDoubleWord(134695760);
        this.writeDoubleWord(zipEntry.crc);
        this.writeDoubleWord(zipEntry.compressedSize);
        this.writeDoubleWord(zipEntry.uncompressedSize);
        this.offset += 16;
    }

    private void writeCentralHeader(ZipEntry zipEntry) throws IOException {
        this.writeDoubleWord(33639248);
        this.writeWord(20);
        this.writeWord(20);
        this.writeWord(zipEntry.flags);
        this.writeWord(zipEntry.compression);
        this.writeWord(this.time);
        this.writeWord(this.date);
        this.writeDoubleWord(zipEntry.crc);
        this.writeDoubleWord(zipEntry.compressedSize);
        this.writeDoubleWord(zipEntry.uncompressedSize);
        this.writeWord(zipEntry.name.length());
        this.writeWord(0);
        this.writeWord(0);
        this.writeWord(0);
        this.writeWord(0);
        this.writeDoubleWord(0);
        this.writeDoubleWord(zipEntry.offset);
        this.writeString(zipEntry.name);
        this.size += 46 + zipEntry.name.length();
    }

    private void writeEndOfDirectory() throws IOException {
        this.writeDoubleWord(101010256);
        this.writeWord(0);
        this.writeWord(0);
        this.writeWord(this.entries.size());
        this.writeWord(this.entries.size());
        this.writeDoubleWord(this.size);
        this.writeDoubleWord(this.offset);
        this.writeWord(0);
    }

    private void writeWord(int n) throws IOException {
        this.output.write(n);
        this.output.write(n >>> 8);
    }

    private void writeDoubleWord(int n) throws IOException {
        this.output.write(n);
        this.output.write(n >>> 8);
        this.output.write(n >>> 16);
        this.output.write(n >>> 24);
    }

    private void writeString(String string) throws IOException {
        this.output.write(string.getBytes("ASCII"));
    }

    private static int dosDate(Calendar calendar) {
        int n = calendar.get(1) - 1980;
        int n2 = calendar.get(2) - 0 + 1;
        int n3 = calendar.get(5);
        return n << 9 | n2 << 5 | n3;
    }

    private static int dosTime(Calendar calendar) {
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        return n << 11 | n2 << 5 | n3;
    }

    private static long crc(byte[] byArray) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return cRC32.getValue();
    }
}

