/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CommonUtils;
import common.Packer;
import graph.Route;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AddressList {
    protected List results = null;
    protected String targets;
    protected boolean hasError;
    protected String description;
    public static final int ENTRY_BARE = 1;
    public static final int ENTRY_RANGE = 2;

    public boolean hasError() {
        return this.hasError;
    }

    public String getError() {
        return this.description;
    }

    public _A Bare(String string) {
        _A _A2 = new _A();
        _A2.C = 1;
        _A2.B = string;
        return _A2;
    }

    public _A Range(long l, long l2) {
        _A _A2 = new _A();
        _A2.C = 2;
        _A2.D = l;
        _A2.A = l2;
        return _A2;
    }

    public String check(String string) {
        String[] stringArray = string.split("\\.");
        int n = CommonUtils.toNumber(stringArray[0], -1);
        int n2 = CommonUtils.toNumber(stringArray[1], -1);
        int n3 = CommonUtils.toNumber(stringArray[2], -1);
        int n4 = CommonUtils.toNumber(stringArray[3], -1);
        if (n >= 0 && n2 >= 0 && n3 >= 0 && n4 >= 0 && n < 256 && n2 < 256 && n3 < 256 && n4 < 256) {
            return string;
        }
        this.hasError = true;
        this.description = string + " is not an IPv4 address";
        return string;
    }

    public LinkedList parse() {
        LinkedList<_A> linkedList = new LinkedList<_A>();
        String[] stringArray = this.targets.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            long l;
            long l2;
            long l3;
            String string;
            String[] stringArray2;
            stringArray[i] = CommonUtils.trim(stringArray[i]);
            if (stringArray[i].matches("\\d+\\.\\d+\\.\\d+\\.\\d+/\\d+")) {
                stringArray2 = stringArray[i].split("/");
                string = this.check(stringArray2[0]);
                int n = CommonUtils.toNumber(stringArray2[1], 0);
                if (n < 0 || n > 32) {
                    this.hasError = true;
                    this.description = stringArray[i] + " has invalid CIDR notation " + n;
                    continue;
                }
                l3 = Route.ipToLong(string);
                l2 = l3 + CommonUtils.lpow(2L, 32 - n);
                linkedList.add(this.Range(l3, l2));
                continue;
            }
            if (stringArray[i].matches("\\d+\\.\\d+\\.\\d+\\.\\d+-\\d+")) {
                stringArray2 = stringArray[i].split("-");
                string = this.check(stringArray2[0]);
                long l4 = CommonUtils.toNumber(stringArray2[1], 0);
                l = Route.ipToLong(string);
                if ((l4 -= l & 0xFFL) <= 0L) {
                    this.hasError = true;
                    this.description = "Invalid range: " + l4 + " is less than " + (l & 0xFFL);
                    continue;
                }
                linkedList.add(this.Range(l, l + l4));
                continue;
            }
            if (stringArray[i].matches("\\d+\\.\\d+\\.\\d+\\.\\d++\\d+")) {
                stringArray2 = stringArray[i].split("+");
                string = this.check(stringArray2[0]);
                long l5 = CommonUtils.toNumber(stringArray2[1], 0);
                l = Route.ipToLong(string);
                linkedList.add(this.Range(l, l + l5));
                continue;
            }
            if (stringArray[i].matches("\\d+\\.\\d+\\.\\d+\\.\\d+-\\d+\\.\\d+\\.\\d+\\.\\d+")) {
                stringArray2 = stringArray[i].split("-");
                string = this.check(stringArray2[0]);
                String string2 = this.check(stringArray2[1]);
                l3 = Route.ipToLong(string);
                if (l3 >= (l2 = Route.ipToLong(string2))) {
                    this.hasError = true;
                    this.description = "Invalid range: " + string + " is greater than " + string2;
                    continue;
                }
                linkedList.add(this.Range(l3, l2));
                continue;
            }
            linkedList.add(this.Bare(stringArray[i]));
        }
        return linkedList;
    }

    public AddressList(String string) {
        this.targets = string;
        this.results = this.parse();
        if (this.export().length > 2000) {
            this.hasError = true;
            this.description = "target list is too long";
        }
    }

    public Iterator iterator() {
        return this.results.iterator();
    }

    public static String toIP(long l) {
        long l2 = (l & 0xFFFFFFFFFF000000L) >> 24;
        long l3 = (l & 0xFF0000L) >> 16;
        long l4 = (l & 0xFF00L) >> 8;
        long l5 = l & 0xFFL;
        return l2 + "." + l3 + "." + l4 + "." + l5;
    }

    public List toList() {
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            _A _A2 = (_A)iterator.next();
            if (_A2.C == 1) {
                linkedList.add(_A2.B);
                continue;
            }
            if (_A2.C != 2) continue;
            for (long i = _A2.D; i < _A2.A; ++i) {
                linkedList.add(AddressList.toIP(i));
            }
        }
        return linkedList;
    }

    public boolean hit(String string) {
        long l = Route.ipToLong(string);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            _A _A2 = (_A)iterator.next();
            if (!(_A2.C == 1 ? string.equals(_A2.B) : _A2.C == 2 && l >= _A2.D && l < _A2.A)) continue;
            return true;
        }
        return false;
    }

    public byte[] export() {
        Packer packer = new Packer();
        packer.little();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            _A _A2 = (_A)iterator.next();
            packer.addInt(_A2.C);
            if (_A2.C == 1) {
                packer.addInt(_A2.B.length());
                packer.addString(_A2.B);
                continue;
            }
            if (_A2.C != 2) continue;
            packer.addInt(8);
            packer.addInt((int)_A2.D);
            packer.addInt((int)_A2.A);
        }
        return packer.getBytes();
    }

    private static class _A {
        public int C;
        public String B;
        public long D;
        public long A;

        private _A() {
        }
    }
}

