/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.AuthCrypto;
import common.CommonUtils;
import common.DataParser;
import common.MudgeSanity;
import common.SleevedResource;
import java.io.File;
import java.util.Arrays;
import java.util.Calendar;

public class Authorization {
    protected String validto = "";
    protected String error = null;
    protected boolean valid = false;

    public Authorization() {
        Object object;
        String string = CommonUtils.canonicalize("cobaltstrike.auth");
        if (!new File(string).exists()) {
            try {
                object = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
                if (((File)object).getName().toLowerCase().endsWith(".jar")) {
                    object = ((File)object).getParentFile();
                }
                string = new File((File)object, "cobaltstrike.auth").getAbsolutePath();
            }
            catch (Exception exception) {
                MudgeSanity.logException("trouble locating auth file", exception, false);
            }
        }
        object = CommonUtils.readFile(string);
        if (((byte[])object).length == 0) {
            this.error = "Could not read " + string;
            return;
        }
        if (((byte[])object).length != 512) {
            return;
        }
        AuthCrypto authCrypto = new AuthCrypto();
        byte[] byArray = authCrypto.decrypt(Arrays.copyOfRange((byte[])object, 0, 256));
        if (byArray.length == 0) {
            return;
        }
        try {
            DataParser dataParser = new DataParser(byArray);
            dataParser.big();
            byte[] byArray2 = dataParser.readBytes(dataParser.readByte());
            dataParser.consume(dataParser.readByte());
            byte by = dataParser.readByte();
            int n = dataParser.readInt();
            int n2 = dataParser.readInt();
            if (by != 49) {
                return;
            }
            if (29999999 == n) {
                this.validto = "forever";
                MudgeSanity.systemDetail("valid to", "perpetual");
            } else {
                if (!this.A(n)) {
                    this.error = "Valid to date (" + n + ") is invalid";
                    return;
                }
                this.validto = "20" + n;
                MudgeSanity.systemDetail("valid to", CommonUtils.formatDateAny("MMMMM d, YYYY", this.getExpirationDate()));
            }
            this.valid = true;
            MudgeSanity.systemDetail("id", n2 + "");
            SleevedResource.Setup(byArray2);
        }
        catch (Exception exception) {
            MudgeSanity.logException("auth file parsing", exception, false);
        }
    }

    private final boolean A(int n) {
        if (n > 999999) {
            return false;
        }
        int n2 = 2000 + n / 10000;
        int n3 = n % 10000 / 100;
        int n4 = n % 100;
        int n5 = 10;
        int n6 = Calendar.getInstance().get(1) + n5;
        if (n2 > n6) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setLenient(false);
        try {
            calendar.set(n2, n3 - 1, n4);
            calendar.getTime();
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public boolean isPerpetual() {
        return "forever".equals(this.validto);
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getError() {
        return this.error != null ? this.error : "Authorization file is not for Cobalt Strike 4.9";
    }

    public long getExpirationDate() {
        return CommonUtils.parseDate(this.validto, "yyyyMMdd");
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.getExpirationDate() + Authorization.B(1);
    }

    public String whenExpires() {
        long l = (this.getExpirationDate() + Authorization.B(1) - System.currentTimeMillis()) / Authorization.B(1);
        if (l == 1L) {
            return "in 1 day (" + CommonUtils.formatDateAny("MMMMM d, YYYY", this.getExpirationDate()) + ")";
        }
        if (l <= 0L) {
            return "TODAY (" + CommonUtils.formatDateAny("MMMMM d, YYYY", this.getExpirationDate()) + ")";
        }
        return "in " + l + " days (" + CommonUtils.formatDateAny("MMMMM d, YYYY", this.getExpirationDate()) + ")";
    }

    public boolean isAlmostExpired() {
        long l = System.currentTimeMillis() + Authorization.B(45);
        return l > this.getExpirationDate();
    }

    private static final long B(int n) {
        return 86400000L * (long)n;
    }
}

