/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CommonUtils;
import common.Informant;
import common.Loggable;
import common.Scriptable;
import common.Transcript;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public class BeaconOutput
implements Serializable,
Transcript,
Loggable,
Informant,
Scriptable {
    public static final short ERROR = 0;
    public static final short TASK = 1;
    public static final short OUTPUT = 2;
    public static final short CHECKIN = 3;
    public static final short INPUT = 4;
    public static final short MODE = 5;
    public static final short OUTPUT_PS = 6;
    public static final short OUTPUTB = 7;
    public static final short OUTPUT_JOBS = 8;
    public static final short OUTPUT_LS = 9;
    public static final short INDICATOR = 10;
    public static final short ACTIVITY = 11;
    public static final short NOTE = 12;
    public static final short WARNING = 13;
    public static final short OUTPUT_TOKEN_STORE = 14;
    public static final short OUTPUT_TOKEN_STORE_STEAL = 15;
    public static final short OUTPUT_DATA_STORE = 16;
    public String from = null;
    public long when = System.currentTimeMillis();
    public short type;
    public String text;
    public String bid;
    public String tactic = "";

    public boolean is(String string) {
        return this.bid.equals(string);
    }

    public boolean isSSH() {
        return "session".equals(CommonUtils.session(this.bid));
    }

    public boolean isBeacon() {
        return !this.isSSH();
    }

    public String prefix(String string) {
        if (this.isSSH()) {
            return "ssh_" + string;
        }
        return "beacon_" + string;
    }

    @Override
    public String eventName() {
        switch (this.type) {
            case 0: {
                return this.prefix("error");
            }
            case 1: {
                return this.prefix("tasked");
            }
            case 2: {
                return this.prefix("output");
            }
            case 7: {
                return this.prefix("output_alt");
            }
            case 6: {
                return this.prefix("output_ps");
            }
            case 3: {
                return this.prefix("checkin");
            }
            case 4: {
                return this.prefix("input");
            }
            case 5: {
                return this.prefix("mode");
            }
            case 8: {
                return this.prefix("output_jobs");
            }
            case 9: {
                return this.prefix("output_ls");
            }
            case 14: {
                return this.prefix("output_token_store");
            }
            case 15: {
                return this.prefix("output_token_store_steal");
            }
            case 16: {
                return this.prefix("output_data_store");
            }
            case 10: {
                return this.prefix("indicator");
            }
            case 12: {
                return this.prefix("note");
            }
            case 13: {
                return this.prefix("warning");
            }
        }
        return this.prefix("generic");
    }

    @Override
    public Stack eventArguments() {
        Stack<Scalar> stack = new Stack<Scalar>();
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                stack.push(SleepUtils.getScalar(this.when));
                stack.push(SleepUtils.getScalar(this.text));
                stack.push(SleepUtils.getScalar(this.bid));
                break;
            }
            case 4: 
            case 10: {
                stack.push(SleepUtils.getScalar(this.when));
                stack.push(SleepUtils.getScalar(this.text));
                stack.push(SleepUtils.getScalar(this.from));
                stack.push(SleepUtils.getScalar(this.bid));
            }
        }
        return stack;
    }

    public BeaconOutput(String string, short s, String string2) {
        this(string, s, string2, "");
    }

    public BeaconOutput(String string, short s, String string2, String string3) {
        this.type = s;
        this.text = string2;
        this.bid = string;
        this.tactic = string3;
    }

    public static final BeaconOutput Note(String string, String string2) {
        return new BeaconOutput(string, 12, string2);
    }

    public static final BeaconOutput Input(String string, String string2) {
        return new BeaconOutput(string, 4, string2);
    }

    public static final BeaconOutput Mode(String string, String string2) {
        return new BeaconOutput(string, 5, string2);
    }

    public static final BeaconOutput Error(String string, String string2) {
        return new BeaconOutput(string, 0, string2);
    }

    public static final BeaconOutput Warning(String string, String string2) {
        return new BeaconOutput(string, 13, string2);
    }

    public static final BeaconOutput Task(String string, String string2) {
        return new BeaconOutput(string, 1, string2);
    }

    public static final BeaconOutput Task(String string, String string2, String string3) {
        return new BeaconOutput(string, 1, string2, string3);
    }

    public static final BeaconOutput Output(String string, String string2) {
        return new BeaconOutput(string, 2, string2);
    }

    public static final BeaconOutput OutputB(String string, String string2) {
        return new BeaconOutput(string, 7, string2);
    }

    public static final BeaconOutput OutputPS(String string, String string2) {
        return new BeaconOutput(string, 6, string2);
    }

    public static final BeaconOutput OutputLS(String string, String string2) {
        return new BeaconOutput(string, 9, string2);
    }

    public static final BeaconOutput Checkin(String string, String string2) {
        return new BeaconOutput(string, 3, string2);
    }

    public static final BeaconOutput OutputJobs(String string, String string2) {
        return new BeaconOutput(string, 8, string2);
    }

    public static final BeaconOutput Indicator(String string, String string2) {
        return new BeaconOutput(string, 10, string2);
    }

    public static final BeaconOutput Activity(String string, String string2) {
        return new BeaconOutput(string, 11, string2);
    }

    public static final BeaconOutput FileIndicator(String string, String string2, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("file: ");
        stringBuffer.append(CommonUtils.toHex(CommonUtils.MD5(byArray)));
        stringBuffer.append(" ");
        stringBuffer.append(byArray.length);
        stringBuffer.append(" bytes ");
        stringBuffer.append(string2);
        return BeaconOutput.Indicator(string, stringBuffer.toString());
    }

    public static final BeaconOutput ServiceIndicator(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("service: \\\\");
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(string3);
        return BeaconOutput.Indicator(string, stringBuffer.toString());
    }

    public static final BeaconOutput OutputTokenStore(String string, String string2) {
        return new BeaconOutput(string, 14, string2);
    }

    public static final BeaconOutput OutputTokenStoreSteal(String string, String string2) {
        return new BeaconOutput(string, 15, string2);
    }

    public static final BeaconOutput OutputDataStore(String string, String string2) {
        return new BeaconOutput(string, 16, string2);
    }

    public void touch() {
        this.when = System.currentTimeMillis();
    }

    public void user(String string) {
        this.from = string;
    }

    public String toString() {
        if (this.type == 1) {
            return "[TASK] " + this.from + " " + this.text;
        }
        if (this.type == 2) {
            return "[OUTPUT] " + this.text;
        }
        if (this.type == 0) {
            return "[ERROR] " + this.text;
        }
        if (this.type == 13) {
            return "[WARNING] " + this.text;
        }
        return "Output: " + this.type;
    }

    @Override
    public String getBeaconId() {
        return this.bid;
    }

    @Override
    public void formatEvent(DataOutputStream dataOutputStream) throws IOException {
        if (this.type == 11) {
            return;
        }
        dataOutputStream.writeBytes(CommonUtils.formatLogDate(this.when));
        dataOutputStream.writeBytes(" ");
        switch (this.type) {
            case 0: {
                CommonUtils.writeUTF8(dataOutputStream, "[error] " + this.text);
                break;
            }
            case 1: {
                CommonUtils.writeUTF8(dataOutputStream, "[task] <" + this.tactic + "> " + this.text);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: {
                CommonUtils.writeUTF8(dataOutputStream, "[output]\n" + this.text + "\n");
                break;
            }
            case 3: {
                CommonUtils.writeUTF8(dataOutputStream, "[checkin] " + this.text);
                break;
            }
            case 4: {
                CommonUtils.writeUTF8(dataOutputStream, "[input] <" + this.from + "> " + this.text);
                break;
            }
            case 5: {
                CommonUtils.writeUTF8(dataOutputStream, "[mode] " + this.text);
                break;
            }
            case 10: {
                CommonUtils.writeUTF8(dataOutputStream, "[indicator] " + this.text);
                break;
            }
            case 12: {
                CommonUtils.writeUTF8(dataOutputStream, "[note] " + this.text);
                break;
            }
            case 13: {
                CommonUtils.writeUTF8(dataOutputStream, "[warning] " + this.text);
            }
        }
        dataOutputStream.writeBytes("\n");
    }

    @Override
    public String getLogFile() {
        return this.prefix(this.bid + ".log");
    }

    @Override
    public String getLogFolder() {
        return null;
    }

    @Override
    public long getLogLimit() {
        return 0L;
    }

    @Override
    public String getLogEventName() {
        return "Beacon Output";
    }

    @Override
    public boolean hasInformation() {
        return this.type == 10 || this.type == 4 || this.type == 1 || this.type == 3 || this.type == 11 || this.type == 5;
    }

    @Override
    public Map archive() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.type == 10) {
            hashMap.put("type", "indicator");
            hashMap.put("bid", this.bid);
            hashMap.put("data", this.text);
            hashMap.put("when", this.when);
        } else if (this.type == 4) {
            hashMap.put("type", "input");
            hashMap.put("bid", this.bid);
            hashMap.put("data", this.text);
            hashMap.put("when", this.when);
        } else if (this.type == 1) {
            hashMap.put("type", "task");
            hashMap.put("bid", this.bid);
            if (this.text.startsWith("Tasked beacon to ")) {
                hashMap.put("data", this.text.substring("Tasked beacon to ".length()));
            } else if (this.text.startsWith("Tasked session to ")) {
                hashMap.put("data", this.text.substring("Tasked session to ".length()));
            } else {
                hashMap.put("data", this.text);
            }
            hashMap.put("when", this.when);
        } else if (this.type == 3) {
            hashMap.put("type", "checkin");
            hashMap.put("bid", this.bid);
            hashMap.put("data", this.text);
            hashMap.put("when", this.when);
        } else if (this.type == 11) {
            hashMap.put("type", "output");
            hashMap.put("bid", this.bid);
            hashMap.put("data", this.text);
            hashMap.put("when", this.when);
        } else if (this.type == 5) {
            hashMap.put("type", "task");
            hashMap.put("bid", this.bid);
            hashMap.put("data", this.text);
            hashMap.put("when", this.when);
        }
        if (!"".equals(this.tactic)) {
            hashMap.put("tactic", this.tactic);
        }
        return hashMap;
    }
}

