/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CommonUtils;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ChangeLog
implements Serializable {
    public static final int CHANGE_ADD = 1;
    public static final int CHANGE_ADDNEW = 2;
    public static final int CHANGE_UPDATE = 3;
    public static final int CHANGE_DELETE = 4;
    protected List changes = new LinkedList();
    protected long preid = 0L;
    protected long postid = 0L;
    protected String name;

    public int size() {
        return this.changes.size();
    }

    public boolean isDifferent() {
        return this.changes.size() > 0;
    }

    public ChangeLog(String string) {
        this.name = string;
    }

    public void add(String string, Map map2) {
        this.changes.add(new ChangeEntry(1, string, map2));
    }

    public void addnew(String string, Map map2) {
        this.changes.add(new ChangeEntry(2, string, map2));
    }

    public void update(String string, Map map2) {
        this.changes.add(new ChangeEntry(3, string, map2));
    }

    public void delete(String string) {
        this.changes.add(new ChangeEntry(4, string, null));
    }

    protected long pre(Map map2) {
        long l = 0L;
        if (this.preid == 0L) {
            this.preid = l;
        } else if (l != this.preid) {
            // empty if block
        }
        return l;
    }

    protected void post(Map map2, long l) {
    }

    public void applyOptimize(Map map2) {
        long l = this.pre(map2);
        Iterator iterator = this.changes.iterator();
        while (iterator.hasNext()) {
            ChangeEntry changeEntry = (ChangeEntry)iterator.next();
            this.actOptimize(changeEntry, map2);
            if (changeEntry.isNeccessary()) continue;
            iterator.remove();
        }
        this.post(map2, l);
    }

    public void applyForce(Map map2) {
        long l = this.pre(map2);
        for (ChangeEntry changeEntry : this.changes) {
            this.actForce(changeEntry, map2);
        }
        this.post(map2, l);
    }

    protected boolean same(Map map2, Map map3) {
        if (map2.size() != map3.size()) {
            return false;
        }
        for (Map.Entry entry : map2.entrySet()) {
            Object v = map3.get(entry.getKey());
            if (v == null && entry.getValue() == null) continue;
            if (v == null && entry.getValue() != null) {
                return false;
            }
            if (v != null && entry.getValue() == null) {
                return false;
            }
            if (v == null || entry.getValue() == null || v.toString().equals(entry.getValue().toString())) continue;
            return false;
        }
        return true;
    }

    protected void actForce(ChangeEntry changeEntry, Map map2) {
        switch (changeEntry.type()) {
            case 1: {
                map2.put(changeEntry.key(), changeEntry.entry());
                break;
            }
            case 2: {
                if (map2.containsKey(changeEntry.key())) break;
                map2.put(changeEntry.key(), changeEntry.entry());
                break;
            }
            case 3: {
                if (!map2.containsKey(changeEntry.key())) {
                    map2.put(changeEntry.key(), changeEntry.entry());
                    break;
                }
                Map map3 = (Map)map2.get(changeEntry.key());
                for (Map.Entry entry : changeEntry.entry().entrySet()) {
                    map3.put(entry.getKey(), entry.getValue());
                }
                break;
            }
            case 4: {
                map2.remove(changeEntry.key());
            }
        }
    }

    protected void actOptimize(ChangeEntry changeEntry, Map map2) {
        switch (changeEntry.type()) {
            case 1: {
                if (map2.containsKey(changeEntry.key())) {
                    Map map3 = (Map)map2.get(changeEntry.key());
                    if (!this.same(map3, changeEntry.entry())) {
                        map2.put(changeEntry.key(), changeEntry.entry());
                        break;
                    }
                    changeEntry.kill();
                    break;
                }
                map2.put(changeEntry.key(), changeEntry.entry());
                break;
            }
            case 2: {
                if (!map2.containsKey(changeEntry.key())) {
                    map2.put(changeEntry.key(), changeEntry.entry());
                    break;
                }
                changeEntry.kill();
                break;
            }
            case 3: {
                if (!map2.containsKey(changeEntry.key())) {
                    map2.put(changeEntry.key(), changeEntry.entry());
                    break;
                }
                Map map4 = (Map)map2.get(changeEntry.key());
                boolean bl = false;
                for (Map.Entry entry : changeEntry.entry().entrySet()) {
                    Object v = map4.get(entry.getKey());
                    if (v == null && entry.getValue() == null) continue;
                    if (v == null && entry.getValue() != null) {
                        map4.put(entry.getKey(), entry.getValue());
                        bl = true;
                        continue;
                    }
                    if (v != null && entry.getValue() != null) {
                        if (entry.getValue().toString().equals(v.toString())) continue;
                        map4.put(entry.getKey(), entry.getValue());
                        bl = true;
                        continue;
                    }
                    if (v == null || entry.getValue() != null) continue;
                    map4.put(entry.getKey(), entry.getValue());
                    bl = true;
                }
                if (bl) break;
                changeEntry.kill();
                break;
            }
            case 4: {
                if (map2.containsKey(changeEntry.key())) {
                    map2.remove(changeEntry.key());
                    break;
                }
                changeEntry.kill();
            }
        }
    }

    public void print() {
        CommonUtils.print_info("Change Log...");
        for (ChangeEntry changeEntry : this.changes) {
            changeEntry.print();
        }
    }

    public class ChangeEntry
    implements Serializable {
        protected int type;
        protected String key;
        protected Map entry;
        protected boolean needed = true;

        public ChangeEntry(int n, String string, Map map2) {
            this.type = n;
            this.key = string;
            this.entry = map2;
        }

        public void kill() {
            this.needed = false;
        }

        public boolean isNeccessary() {
            return this.needed;
        }

        public String key() {
            return this.key;
        }

        public int type() {
            return this.type;
        }

        public Map entry() {
            return this.entry;
        }

        public void print() {
            switch (this.type) {
                case 1: {
                    CommonUtils.print_info("\tAdd:\n\t\t" + this.key + "\n\t\t" + this.entry);
                    break;
                }
                case 2: {
                    CommonUtils.print_info("\tAddNew:\n\t\t" + this.key + "\n\t\t" + this.entry);
                    break;
                }
                case 3: {
                    CommonUtils.print_info("\tUpdate:\n\t\t" + this.key + "\n\t\t" + this.entry);
                    break;
                }
                case 4: {
                    CommonUtils.print_info("\tDelete:\n\t\t" + this.key);
                }
            }
        }
    }
}

