/*
 * Decompiled with CFR 0.152.
 */
package common;

import c2profile.Profile;
import common.CommonUtils;
import common.MudgeSanity;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.security.KeyStore;
import net.jsign.AuthenticodeSigner;
import net.jsign.DigestAlgorithm;
import net.jsign.pe.PEFile;
import net.jsign.timestamp.TimestampingMode;

public class CodeSigner
implements Serializable {
    protected byte[] keystore;
    protected String password = null;
    protected String alias = null;
    protected String digest_algorithm = null;
    protected String program_name = null;
    protected String program_url = null;
    protected boolean timestamp = false;
    protected String timestamp_url = null;
    protected String timestamp_mode = null;

    public CodeSigner() {
        this.keystore = new byte[0];
    }

    protected String get(Profile profile, String string) {
        if (profile.hasString(string) && !"".equals(profile.getString(string))) {
            return profile.getString(string);
        }
        return null;
    }

    public CodeSigner(Profile profile) {
        if (!profile.isFile(".code-signer.keystore")) {
            this.keystore = new byte[0];
            return;
        }
        this.keystore = CommonUtils.readFile(profile.getString(".code-signer.keystore"));
        this.password = profile.getString(".code-signer.password");
        this.alias = profile.getString(".code-signer.alias");
        this.digest_algorithm = this.get(profile, ".code-signer.digest_algorithm");
        this.program_name = this.get(profile, ".code-signer.program_name");
        this.program_url = this.get(profile, ".code-signer.program_url");
        this.timestamp_url = this.get(profile, ".code-signer.timestamp_url");
        this.timestamp_mode = this.get(profile, ".code-signer.timestamp_mode");
        this.timestamp = profile.option(".code-signer.timestamp");
    }

    public boolean available() {
        return this.keystore.length > 0;
    }

    public byte[] sign(byte[] byArray) {
        if (!this.available()) {
            return byArray;
        }
        String string = CommonUtils.writeToTemp("signme", "exe", byArray);
        if (string == null) {
            return byArray;
        }
        try {
            this.sign(new File(string));
        }
        catch (Exception exception) {
            MudgeSanity.logException("Could not sign '" + string + "'", exception, false);
            new File(string).delete();
            return byArray;
        }
        byte[] byArray2 = CommonUtils.readFile(string);
        new File(string).delete();
        return byArray2;
    }

    public void sign(File file) throws Exception {
        if (!this.available()) {
            return;
        }
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(new ByteArrayInputStream(this.keystore), this.password.toCharArray());
        AuthenticodeSigner authenticodeSigner = new AuthenticodeSigner(keyStore, this.alias, this.password);
        authenticodeSigner.withTimestamping(this.timestamp);
        if (this.program_name != null) {
            authenticodeSigner.withProgramName(this.program_name);
        }
        if (this.program_url != null) {
            authenticodeSigner.withProgramURL(this.program_url);
        }
        if (this.timestamp_mode != null) {
            authenticodeSigner.withTimestampingMode(TimestampingMode.valueOf(this.timestamp_mode));
        }
        if (this.timestamp_url != null) {
            authenticodeSigner.withTimestampingAuthority(this.timestamp_url);
        }
        if (this.digest_algorithm != null) {
            authenticodeSigner.withDigestAlgorithm(DigestAlgorithm.valueOf(this.digest_algorithm));
        }
        authenticodeSigner.sign(new PEFile(file));
    }
}

