/*
 * Decompiled with CFR 0.152.
 */
package common;

import beacon.BeaconStoreItemType;
import common.AddressList;
import common.CommonUtils;
import common.IntegerList;
import common.ListenerUtils;
import common.PortFlipper;
import common.StringStack;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Stack;

public class CommandParser {
    protected StringStack parse;
    protected String command;
    protected Stack args = new Stack();
    protected String error = null;
    protected String text;
    protected boolean missing = false;

    public CommandParser(String string) {
        this.text = string;
        this.reset();
    }

    public boolean is(String string) {
        return this.command.equals(string);
    }

    public String getCommand() {
        return this.command;
    }

    public String getArguments() {
        return this.parse.toString();
    }

    public String error() {
        return this.command + " error: " + this.error;
    }

    public boolean isMissingArguments() {
        boolean bl = this.missing;
        if (this.missing) {
            this.reset();
        }
        return bl;
    }

    public void error(String string) {
        this.error = string;
    }

    public boolean empty() {
        return this.parse.isEmpty();
    }

    public boolean hasError() {
        return this.error != null;
    }

    public boolean reset() {
        this.parse = new StringStack(this.text);
        this.command = this.parse.shift();
        this.error = null;
        this.args = new Stack();
        this.missing = false;
        return false;
    }

    public boolean verify(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            int n;
            Object object;
            if (this.parse.isEmpty()) {
                this.error = "not enough arguments";
                this.missing = true;
                return false;
            }
            if (cArray[i] == 'A') {
                this.args.push(this.parse.shift());
                continue;
            }
            if (cArray[i] == 'B') {
                this.args.push(this.parse.shiftStringCanBeSingleOrDoubleQuoted());
                continue;
            }
            if (cArray[i] == 'C') {
                object = this.parse.shift();
                if (((String)object).equals("dns") || ((String)object).equals("dns-txt") || ((String)object).equals("dns6")) {
                    this.args.push(object);
                    continue;
                }
                this.error = "argument '" + (String)object + "' is not 'dns', 'dns6', or 'dns-txt'";
                return false;
            }
            if (cArray[i] == 'D') {
                object = this.parse.shift();
                if (((String)object).equals("icmp") || ((String)object).equals("arp") || ((String)object).equals("none")) {
                    this.args.push(object);
                    continue;
                }
                this.error = "argument '" + (String)object + "' is not 'arp', 'icmp', or 'none'";
                return false;
            }
            if (cArray[i] == 'g') {
                object = this.parse.shift();
                if (((String)object).equals("query") || ((String)object).equals("queryv")) {
                    this.args.push(object);
                    continue;
                }
                this.error = "argument '" + (String)object + "' is not 'query or queryv'";
                return false;
            }
            if (cArray[i] == 'H') {
                object = this.parse.shift();
                if (((String)object).length() == 65 && ((String)object).charAt(32) == ':') {
                    object = ((String)object).substring(33);
                }
                if (((String)object).length() != 32) {
                    this.error = "argument '" + (String)object + "' is not an NTLM hash";
                    return false;
                }
                this.args.push(object);
                continue;
            }
            if (cArray[i] == 'I') {
                object = this.parse.shift();
                try {
                    n = Integer.parseInt((String)object);
                    this.args.push(new Integer(n));
                    continue;
                }
                catch (Exception exception) {
                    this.error = "'" + (String)object + "' is not a number";
                    return false;
                }
            }
            if (cArray[i] == 'J') {
                object = this.parse.shift();
                try {
                    long l = ((String)object).startsWith("0x") ? Long.decode((String)object) : Long.parseLong((String)object);
                    this.args.push(new Long(l));
                    continue;
                }
                catch (Exception exception) {
                    this.error = "'" + (String)object + "' is not a number";
                    return false;
                }
            }
            if (cArray[i] == 'f') {
                object = new File(this.parse.toString());
                if (!((File)object).exists()) {
                    this.error = "'" + ((File)object).getAbsolutePath() + "' does not exist";
                    return false;
                }
                if (!((File)object).canRead()) {
                    this.error = "'" + ((File)object).getAbsolutePath() + "' is not readable";
                    return false;
                }
                if (((File)object).isDirectory()) {
                    this.error = "'" + ((File)object).getAbsolutePath() + "' is a directory";
                    return false;
                }
                this.args.push(((File)object).getAbsolutePath());
                continue;
            }
            if (cArray[i] == 'F') {
                object = new File(this.parse.toString());
                if (!((File)object).exists()) {
                    this.error = "'" + ((File)object).getAbsolutePath() + "' does not exist";
                    return false;
                }
                if (!((File)object).canRead()) {
                    this.error = "'" + ((File)object).getAbsolutePath() + "' is not readable";
                    return false;
                }
                if (((File)object).isDirectory()) {
                    this.error = "'" + ((File)object).getAbsolutePath() + "' is a directory";
                    return false;
                }
                this.args.push(((File)object).getAbsolutePath());
                continue;
            }
            if (cArray[i] == 'L') {
                object = this.parse.toString();
                if (!ListenerUtils.isListener((String)object)) {
                    this.error = "Listener '" + (String)object + "' does not exist";
                    return false;
                }
                this.args.push(object);
                continue;
            }
            if (cArray[i] == 'p') {
                object = new File(this.parse.shift());
                if (!((File)object).exists()) {
                    this.error = "'" + ((File)object).getAbsolutePath() + "' does not exist";
                    return false;
                }
                if (!((File)object).canRead()) {
                    this.error = "'" + ((File)object).getAbsolutePath() + "' is not readable";
                    return false;
                }
                if (((File)object).isDirectory()) {
                    this.error = "'" + ((File)object).getAbsolutePath() + "' is a directory";
                    return false;
                }
                this.args.push(((File)object).getAbsolutePath());
                continue;
            }
            if (cArray[i] == 'P') {
                object = this.parse.shiftStringCanBeSingleOrDoubleQuoted();
                if (!((String)object).startsWith("PATCHES:")) {
                    return false;
                }
                object = ((String)object).substring("PATCHES:".length()).trim();
                this.args.push(object);
                continue;
            }
            if (cArray[i] == 'Q') {
                object = this.parse.shift();
                if (((String)object).equals("high") || ((String)object).equals("low")) {
                    this.args.push(object);
                    continue;
                }
                this.error = "argument '" + (String)object + "' is not 'high' or 'low'";
                return false;
            }
            if (cArray[i] == 'R') {
                object = this.parse.shift();
                PortFlipper portFlipper = new PortFlipper((String)object);
                portFlipper.parse();
                if (portFlipper.hasError()) {
                    this.error = portFlipper.getError();
                    return false;
                }
                this.args.push(object);
                continue;
            }
            if (cArray[i] == 'r') {
                object = this.parse.shift();
                IntegerList integerList = new IntegerList((String)object);
                ArrayList<Integer> arrayList = integerList.parse();
                if (integerList.hasError()) {
                    this.error = integerList.getError();
                    return false;
                }
                this.args.push(arrayList);
                continue;
            }
            if (cArray[i] == 'S') {
                object = this.parse.shift();
                if (((String)object).equals("steal") || ((String)object).equals("use") || ((String)object).equals("show") || ((String)object).equals("remove") || ((String)object).equals("remove-all") || ((String)object).equals("steal-and-use")) {
                    this.args.push(object);
                    continue;
                }
                this.error = "argument '" + (String)object + "' is not 'steal', 'use', 'steal-and-use', 'show', 'remove', or 'remove-all'";
                return false;
            }
            if (cArray[i] == 's') {
                object = this.parse.shift();
                if (((String)object).equals("load") || ((String)object).equals("unload") || ((String)object).equals("list")) {
                    this.args.push(object);
                    continue;
                }
                this.error = "argument '" + (String)object + "' is not 'load', 'unload' or 'list'";
                return false;
            }
            if (cArray[i] == 'T') {
                object = this.parse.shift();
                AddressList addressList = new AddressList((String)object);
                if (addressList.hasError()) {
                    this.error = addressList.getError();
                    return false;
                }
                this.args.push(object);
                continue;
            }
            if (cArray[i] == 't') {
                object = this.parse.shift();
                if (BeaconStoreItemType.isItemType((String)object)) {
                    this.args.push(object);
                    continue;
                }
                BeaconStoreItemType[] beaconStoreItemTypeArray = BeaconStoreItemType.values();
                this.error = CommandParser.A((String)object, (Object[])beaconStoreItemTypeArray);
                return false;
            }
            if (cArray[i] == 'U') {
                object = this.parse.shift();
                if (((String)object).startsWith("\\\\")) {
                    this.args.push(((String)object).substring(2));
                    continue;
                }
                this.error = "argument '" + (String)object + "' is not a \\\\target";
                return false;
            }
            if (cArray[i] == 'V') {
                object = this.parse.shift();
                HashSet hashSet = new HashSet(CommonUtils.getNetCommands());
                if (hashSet.contains(object)) {
                    this.args.push(object);
                    continue;
                }
                this.error = "argument '" + (String)object + "' is not a net command";
                return false;
            }
            if (cArray[i] == 'X') {
                object = this.parse.shift();
                if (((String)object).equals("x86") || ((String)object).equals("x64")) {
                    this.args.push(object);
                    continue;
                }
                this.error = "argument '" + (String)object + "' is not 'x86' or 'x64'";
                return false;
            }
            if (cArray[i] == 'Z') {
                this.args.push(this.parse.toString());
                continue;
            }
            if (cArray[i] == '%') {
                object = this.parse.shift();
                try {
                    n = Integer.parseInt((String)object);
                    if (n < 0 || n > 99) {
                        this.error = "argument " + n + " is not a value 0-99";
                        return false;
                    }
                    this.args.push(new Integer(n));
                    continue;
                }
                catch (Exception exception) {
                    this.error = "'" + (String)object + "' is not a number";
                    return false;
                }
            }
            if (cArray[i] != '?') continue;
            object = this.parse.shift();
            if (((String)object).equals("start") || ((String)object).equals("on") || ((String)object).equals("true")) {
                this.args.push(Boolean.TRUE);
                continue;
            }
            if (((String)object).equals("stop") || ((String)object).equals("off") || ((String)object).equals("false")) {
                this.args.push(Boolean.FALSE);
                continue;
            }
            this.error = "'" + (String)object + "' is not a boolean value";
            return false;
        }
        return true;
    }

    public int popInt() {
        Integer n = (Integer)this.args.pop();
        return n;
    }

    public long popLong() {
        Long l = (Long)this.args.pop();
        return l;
    }

    public String popString() {
        return this.args.pop() + "";
    }

    public boolean popBoolean() {
        Boolean bl = (Boolean)this.args.pop();
        return bl;
    }

    public ArrayList<Integer> popArrayInt() {
        return (ArrayList)this.args.pop();
    }

    public int popHistoryArgument() {
        int n = -1;
        if (this.verify("I") || this.reset()) {
            n = this.popInt();
            if (n <= 0) {
                this.error("invalid history option. must be all or must be number greater than zero.");
            }
        } else if (this.verify("Z") || this.reset()) {
            String string = this.popString();
            if ("all".equals(string.toLowerCase())) {
                n = -1;
            } else {
                this.error("invalid history option. must be all or a number greater than zero.");
            }
        }
        return n;
    }

    private static String A(String string, Object[] objectArray) {
        String string2 = "argument '" + string + "' is not ";
        for (int i = 0; i < objectArray.length; ++i) {
            if (i == objectArray.length - 1 && i != 0) {
                string2 = string2 + " or '" + objectArray[i].toString() + "'";
                continue;
            }
            if (i != 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + "'" + objectArray[i].toString() + "'";
        }
        return string2;
    }
}

