/*
 * Decompiled with CFR 0.152.
 */
package common;

public class CommonHTMLUtils {
    public static final boolean potentialXSS(String string) {
        if (string == null) {
            return false;
        }
        if (string.contains("<")) {
            return true;
        }
        if (string.contains(">")) {
            return true;
        }
        if (string.contains("&")) {
            return true;
        }
        if (string.contains("'")) {
            return true;
        }
        return string.contains("\"");
    }

    public static final boolean potentialUserNameXSS(String string) {
        if (string == null) {
            return false;
        }
        if (string.contains("<")) {
            return true;
        }
        if (string.contains(">")) {
            return true;
        }
        if (string.contains("&")) {
            return true;
        }
        return string.contains("\"");
    }

    public static String escapeHtml(String string) {
        if (string == null) {
            return "";
        }
        int n = string.length();
        int n2 = (int)((double)n * 1.3);
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuilder.append("&gt;");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("&quot;");
                continue;
            }
            if (c == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            if (c < ' ' || c == '\'') {
                stringBuilder.append("&#").append((int)c).append(';');
                continue;
            }
            int n3 = c & 0xFFFF;
            if (n3 > 127) {
                stringBuilder.append("&#").append(n3).append(';');
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

