/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CommonUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Stack;

public class DataParser {
    protected DataInputStream content = null;
    protected byte[] bdata = new byte[8];
    protected ByteBuffer buffer = null;
    protected byte[] original;
    protected Stack frames = new Stack();

    public DataParser(InputStream inputStream) {
        this(CommonUtils.readAll(inputStream));
    }

    public void jump(long l) throws IOException {
        this.frames.push(this.content);
        this.content = new DataInputStream(new ByteArrayInputStream(this.original));
        if (l > 0L) {
            this.consume((int)l);
        }
    }

    public void complete() throws IOException {
        this.content.close();
        this.content = (DataInputStream)this.frames.pop();
    }

    public DataParser(byte[] byArray) {
        this.original = byArray;
        this.buffer = ByteBuffer.wrap(this.bdata);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.content = new DataInputStream(new ByteArrayInputStream(byArray));
    }

    public void reset() {
        try {
            this.content.reset();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error resetting parser content.", iOException);
        }
    }

    public void consume(int n) throws IOException {
        this.content.skipBytes(n);
    }

    public int readInt() throws IOException {
        CommonUtils.clearBuffer(this.buffer);
        this.content.read(this.bdata, 0, 4);
        return this.buffer.getInt(0);
    }

    public long readUnsignedInt() throws IOException {
        CommonUtils.clearBuffer(this.buffer);
        this.content.read(this.bdata, 0, 4);
        return this.buffer.getLong(0);
    }

    public long readQWord() throws IOException {
        CommonUtils.clearBuffer(this.buffer);
        this.content.read(this.bdata, 0, 8);
        return this.buffer.getLong(0);
    }

    public byte readByte() throws IOException {
        return this.content.readByte();
    }

    public char readChar() throws IOException {
        return (char)this.content.readByte();
    }

    public char readChar(DataInputStream dataInputStream) throws IOException {
        return (char)dataInputStream.readByte();
    }

    public byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.content.read(byArray);
        return byArray;
    }

    public int readShort() throws IOException {
        this.content.read(this.bdata, 0, 2);
        return this.buffer.getShort(0) & 0xFFFF;
    }

    public boolean more() throws IOException {
        return this.content.available() > 0;
    }

    public byte[] readCountedBytes() throws IOException {
        int n = this.readInt();
        if (n > 0) {
            return this.readBytes(n);
        }
        return new byte[0];
    }

    public String readCountedString() throws IOException {
        int n = this.readInt();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.readChar());
        }
        return stringBuffer.toString();
    }

    public String readString() throws IOException {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        while ((c = this.readChar()) > '\u0000') {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public String readString(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = this.readChar();
            if (c <= '\u0000') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public DataInputStream getData() {
        return this.content;
    }

    public void little() {
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void big() {
        this.buffer.order(ByteOrder.BIG_ENDIAN);
    }
}

