/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CommonUtils;
import common.DownloadFile;
import common.DownloadNotify;
import common.MudgeSanity;
import common.TeamQueue;
import dialog.DialogUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class DownloadFiles
implements DownloadNotify {
    protected Iterator queue = null;
    protected File dest = null;
    protected TeamQueue conn = null;
    protected FileOutputStream out = null;

    public void startNextDownload() {
        if (!this.queue.hasNext()) {
            DialogUtils.showInfo("Download complete!");
            return;
        }
        Map map2 = (Map)this.queue.next();
        String string = (String)map2.get("lpath");
        String string2 = (String)map2.get("name");
        try {
            this.out = new FileOutputStream(CommonUtils.SafeFile(this.dest, string2), false);
            new DownloadFile(this.conn, string, this.out, this).start();
        }
        catch (IOException iOException) {
            MudgeSanity.logException("DownloadFiles for " + string + " to " + string2 + " failed", iOException, false);
            this.startNextDownload();
        }
    }

    public DownloadFiles(TeamQueue teamQueue, Map[] mapArray, File file) {
        this.conn = teamQueue;
        this.queue = CommonUtils.toList(mapArray).iterator();
        this.dest = file;
        file.mkdirs();
    }

    @Override
    public void complete(String string) {
        try {
            this.out.flush();
            this.out.close();
        }
        catch (IOException iOException) {
            MudgeSanity.logException("DownloadFiles failed to close stream", iOException, false);
            this.startNextDownload();
        }
        this.startNextDownload();
    }

    @Override
    public void cancel() {
        try {
            this.out.flush();
            this.out.close();
        }
        catch (IOException iOException) {
            MudgeSanity.logException("DownloadFiles failed to close stream", iOException, false);
            this.startNextDownload();
        }
    }
}

