/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CommonUtils;
import dialog.DialogUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Keys {
    public static final Set models = CommonUtils.toSet("applications, c2info, credentials, services, sessions, targets, tokens");

    public static String[] getCols(String string) {
        if ("applications".equals(string)) {
            return CommonUtils.toArray("external, internal, application, version, date, id");
        }
        if ("c2info".equals(string)) {
            return CommonUtils.toArray("bid, port, proto, domains");
        }
        if ("credentials".equals(string)) {
            return CommonUtils.toArray("user, password, realm, source, host, note");
        }
        if ("services".equals(string)) {
            return CommonUtils.toArray("address, port, banner, note");
        }
        if ("sessions".equals(string)) {
            return CommonUtils.toArray("id, opened, external, internal, user, computer, pid, is64, pbid, note");
        }
        if ("targets".equals(string)) {
            return CommonUtils.toArray("address, name, os, version, note");
        }
        if ("tokens".equals(string)) {
            return CommonUtils.toArray("token, email, cid");
        }
        return new String[0];
    }

    public static int size() {
        return models.size();
    }

    public static boolean isDataModel(String string) {
        return models.contains(string);
    }

    public static Iterator getDataModelIterator() {
        return models.iterator();
    }

    public static String C2InfoKey(Map map2) {
        return DialogUtils.string(map2, "bid");
    }

    public static String ToKey(String string, Map map2) {
        if ("applications".equals(string)) {
            return CommonUtils.ApplicationKey(map2);
        }
        if ("credentials".equals(string)) {
            return CommonUtils.CredKey(map2);
        }
        if ("services".equals(string)) {
            return CommonUtils.ServiceKey(map2);
        }
        if ("targets".equals(string)) {
            return CommonUtils.TargetKey(map2);
        }
        if ("listeners".equals(string)) {
            return DialogUtils.string(map2, "name");
        }
        if ("beacons".equals(string)) {
            return DialogUtils.string(map2, "id");
        }
        if ("accents".equals(string)) {
            return DialogUtils.string(map2, "id");
        }
        CommonUtils.print_error("No key for '" + string + "'");
        return "";
    }
}

