/*
 * Decompiled with CFR 0.152.
 */
package common;

import aggressor.TeamServerProps;
import common.CommonUtils;
import common.HasUUID;
import common.Loggable;
import common.ScriptUtils;
import common.ToScalar;
import common.Transcript;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import sleep.runtime.Scalar;

public class Keystrokes
implements Serializable,
Transcript,
Loggable,
ToScalar,
HasUUID {
    protected String when;
    protected String bid;
    protected transient String data;
    protected String user;
    protected int desktop;
    protected String computer;
    protected String title;
    protected String id;
    protected static final long serialVersionUID = 1L;

    public Keystrokes(String string, String string2, String string3, String string4, int n, String string5) {
        this.bid = string;
        this.data = string2;
        this.user = string3;
        this.computer = string4;
        this.desktop = n;
        this.title = string5;
        this.when = System.currentTimeMillis() + "";
        this.id = CommonUtils.toHex(CommonUtils.MD5(CommonUtils.toBytes(string + n + string3)));
    }

    public Map toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("id", this.id);
        hashMap.put("when", this.when);
        hashMap.put("title", this.title);
        hashMap.put("user", this.user);
        hashMap.put("session", this.desktop);
        hashMap.put("bid", this.bid);
        hashMap.put("computer", this.computer);
        return hashMap;
    }

    @Override
    public Scalar toScalar() {
        Map map2 = this.toMap();
        return ScriptUtils.convertAll(map2);
    }

    @Override
    public String ID() {
        return this.id;
    }

    public String toString() {
        return "keystrokes from beacon id: " + this.bid;
    }

    public String time() {
        return this.when;
    }

    @Override
    public String getBeaconId() {
        return this.bid;
    }

    @Override
    public void formatEvent(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBytes(CommonUtils.formatLogDate(Long.parseLong(this.when)) + " Received keystrokes from " + this.user + " in desktop " + this.desktop);
        dataOutputStream.writeBytes("\n\n");
        dataOutputStream.writeBytes(CommonUtils.strip(this.data));
        dataOutputStream.writeBytes("\n");
        this.data = null;
    }

    @Override
    public String getLogFile() {
        return "keystrokes_" + this.bid + "." + this.desktop + ".txt";
    }

    @Override
    public String getLogFolder() {
        return "keystrokes";
    }

    @Override
    public long getLogLimit() {
        long l = TeamServerProps.getPropsFile().getLongNumber("limits.keystrokes_diskused_percent", 95L);
        return l;
    }

    @Override
    public String getLogEventName() {
        return "Keystrokes";
    }
}

