/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Authorization;
import common.CommonUtils;
import java.io.Serializable;

public class LicenseStatus
implements Serializable {
    protected long checkedTime = 0L;
    protected boolean perpetual = false;
    protected long expirationTS = 0L;
    protected String expirationDate = "";
    protected boolean valid = false;
    protected boolean expired = false;
    protected boolean almostExpired = false;
    protected String error = "";
    protected boolean initialClientConnect = false;

    public LicenseStatus() {
    }

    public LicenseStatus(Authorization authorization, boolean bl) {
        this.checkedTime = System.currentTimeMillis();
        this.valid = authorization.isValid();
        this.error = authorization.getError();
        this.perpetual = authorization.isPerpetual();
        this.initialClientConnect = bl;
        if (this.valid && !this.perpetual) {
            this.expirationTS = authorization.getExpirationDate();
            this.expired = authorization.isExpired();
            this.almostExpired = authorization.isAlmostExpired();
            this.expirationDate = LicenseStatus.formatDate(this.expirationTS);
        }
    }

    public final long getCheckedTime() {
        return this.checkedTime;
    }

    public final void setCheckedTime(long l) {
        this.checkedTime = l;
    }

    public final boolean isPerpetual() {
        return this.perpetual;
    }

    public final void setPerpetual(boolean bl) {
        this.perpetual = bl;
    }

    public final boolean isAlmostExpired() {
        return this.almostExpired;
    }

    public final boolean isInitialClientConnect() {
        return this.initialClientConnect;
    }

    public final void setAlmostExpired(boolean bl) {
        this.almostExpired = bl;
    }

    public final long getExpirationTS() {
        return this.expirationTS;
    }

    public final void setExpirationTS(long l) {
        this.expirationTS = l;
    }

    public final boolean isValid() {
        return this.valid;
    }

    public final void setValid(boolean bl) {
        this.valid = bl;
    }

    public final boolean isExpired() {
        return this.expired;
    }

    public final void setExpired(boolean bl) {
        this.expired = bl;
    }

    public final String getError() {
        return this.error;
    }

    public final void setError(String string) {
        this.error = string;
    }

    public final String getExpirationDate() {
        return this.expirationDate;
    }

    public final void setExpirationDate(String string) {
        this.expirationDate = string;
    }

    public static final String formatDate(long l) {
        return CommonUtils.formatDateAny("yyyy-MM-dd", l);
    }

    public static final String formatTimestamp(long l) {
        return CommonUtils.formatDateAny("yyyy-MM-dd HH:mm:ss", l);
    }

    public static final String getInvalidLicenseMsg(LicenseStatus licenseStatus) {
        if (CommonUtils.isNullOrEmpty(licenseStatus.getError())) {
            return "Team server license is invalid." + LicenseStatus.A(licenseStatus);
        }
        return "Team server license is invalid (" + licenseStatus.getError() + ")." + LicenseStatus.A(licenseStatus);
    }

    public static final String getPerpetualLicenseMessage(LicenseStatus licenseStatus) {
        return "Team server license is perpetual." + LicenseStatus.A(licenseStatus);
    }

    public static final String getExpiredMsg(LicenseStatus licenseStatus) {
        return "Team server license is expired " + licenseStatus.getExpirationDate() + "." + LicenseStatus.A(licenseStatus);
    }

    public static final String getAlmostExpiredMsg(LicenseStatus licenseStatus) {
        long l = LicenseStatus.C(licenseStatus);
        long l2 = LicenseStatus.A();
        long l3 = LicenseStatus.getGraceShutdownDate(licenseStatus);
        String string = " The team server will shutdown " + LicenseStatus.formatDate(l3) + ".";
        if (l < 1L) {
            return "Team server license has expired (" + licenseStatus.getExpirationDate() + ")." + LicenseStatus.A(licenseStatus);
        }
        if (l < l2) {
            return "Team server license expires today (" + licenseStatus.getExpirationDate() + ")." + string + LicenseStatus.A(licenseStatus);
        }
        long l4 = l / l2;
        if (l4 == 1L) {
            return "Team server license expires in 1 day (" + licenseStatus.getExpirationDate() + ")." + string + LicenseStatus.A(licenseStatus);
        }
        return "Team server license expires in " + l4 + " days (" + licenseStatus.getExpirationDate() + ")." + string + LicenseStatus.A(licenseStatus);
    }

    public static final String getExpiresMsg(LicenseStatus licenseStatus) {
        return "Team server license expires " + licenseStatus.getExpirationDate() + "." + LicenseStatus.A(licenseStatus);
    }

    private static final String A(LicenseStatus licenseStatus) {
        return "";
    }

    private static final long B() {
        return LicenseStatus.A(14L);
    }

    public static final boolean isGracePeriod(LicenseStatus licenseStatus) {
        long l = licenseStatus.getExpirationTS() + LicenseStatus.A();
        boolean bl = licenseStatus.getCheckedTime() >= l;
        boolean bl2 = licenseStatus.getCheckedTime() >= l + LicenseStatus.B();
        return bl && !bl2;
    }

    public static final long getGraceShutdownDate(LicenseStatus licenseStatus) {
        long l = licenseStatus.getExpirationTS() + LicenseStatus.B();
        return l;
    }

    public static final String getGracePeriodMsg(LicenseStatus licenseStatus) {
        long l = LicenseStatus.getGraceShutdownDate(licenseStatus);
        return "Team server license expired " + licenseStatus.getExpirationDate() + ". The team server will shutdown " + LicenseStatus.formatDate(l) + "." + LicenseStatus.A(licenseStatus);
    }

    private static final long C(LicenseStatus licenseStatus) {
        long l = licenseStatus.getExpirationTS() + LicenseStatus.A() - licenseStatus.getCheckedTime();
        if (l > 0L) {
            return l;
        }
        return 0L;
    }

    private static final long A(long l) {
        return l * LicenseStatus.A();
    }

    private static final long A() {
        return 86400000L;
    }

    public String toString() {
        return LicenseStatus.B(this);
    }

    private static final String B(LicenseStatus licenseStatus) {
        return "LicenseStatus - checkedTime=" + licenseStatus.checkedTime + " (" + LicenseStatus.formatTimestamp(licenseStatus.checkedTime) + ")" + " valid=" + licenseStatus.valid + " perpetual=" + licenseStatus.perpetual + " expirationTS=" + licenseStatus.expirationTS + " (" + LicenseStatus.formatTimestamp(licenseStatus.expirationTS) + ")" + " expirationDate=" + licenseStatus.expirationDate + " expired=" + licenseStatus.expired + " almostExpired=" + licenseStatus.almostExpired + " error=" + licenseStatus.error + "";
    }
}

