/*
 * Decompiled with CFR 0.152.
 */
package common;

import aggressor.AggressorClient;
import aggressor.dialogs.PivotListenerSetup;
import aggressor.dialogs.ScListenerDialog;
import beacon.TaskBeacon;
import common.CommonUtils;
import dialog.DialogUtils;
import java.util.Map;

public class ListenerTasks {
    protected AggressorClient client;
    protected String name;

    public ListenerTasks(AggressorClient aggressorClient, String string) {
        this.client = aggressorClient;
        this.name = string;
    }

    protected Map getListenerMap() {
        Map map2 = this.client.getData().getMapSafe("listeners");
        return (Map)map2.get(this.name);
    }

    public boolean isPivotListener() {
        Map map2 = this.getListenerMap();
        String string = DialogUtils.string(map2, "payload");
        String string2 = DialogUtils.string(map2, "bid");
        return "windows/beacon_reverse_tcp".equals(string) && !"".equals(string2);
    }

    public String getBeaconID() {
        return DialogUtils.string(this.getListenerMap(), "bid");
    }

    public int getPort() {
        return DialogUtils.number(this.getListenerMap(), "port");
    }

    public void remove() {
        if (this.isPivotListener()) {
            TaskBeacon taskBeacon = new TaskBeacon(this.client, this.client.getData(), this.client.getConnection(), new String[]{this.getBeaconID()});
            taskBeacon.input("rportfwd stop " + this.getPort());
            taskBeacon.PortForwardStop(this.getPort());
        }
        this.client.getConnection().call("listeners.remove", CommonUtils.args(this.name));
    }

    public void edit() {
        if (this.isPivotListener()) {
            new PivotListenerSetup(this.client, this.getListenerMap()).show();
        } else {
            new ScListenerDialog(this.client, this.getListenerMap()).show();
        }
    }
}

