/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CommonUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Manipulator {
    protected byte[] data;
    protected byte[] bdata = new byte[8];
    protected ByteBuffer buffer = null;

    public Manipulator(byte[] byArray) {
        this.data = byArray;
        this.buffer = ByteBuffer.wrap(this.bdata);
    }

    public void big() {
        this.buffer.order(ByteOrder.BIG_ENDIAN);
    }

    public void little() {
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void setString(int n, byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            this.data[i + n] = byArray[i];
        }
    }

    public void setStringZ(int n, String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.data[i + n] = (byte)string.charAt(i);
        }
        this.data[n + string.length()] = 0;
    }

    public int getInt(int n) {
        CommonUtils.clearBuffer(this.buffer);
        for (int i = 0; i < 4; ++i) {
            this.buffer.put(i, this.data[i + n]);
        }
        return this.buffer.getInt();
    }

    public int getShort(int n) {
        CommonUtils.clearBuffer(this.buffer);
        for (int i = 0; i < 4; ++i) {
            this.buffer.put(i, this.data[i + n]);
        }
        return (short)this.buffer.getInt();
    }

    public void setLong(int n, long l) {
        CommonUtils.clearBuffer(this.buffer);
        this.buffer.putLong(0, l);
        for (int i = 0; i < 4; ++i) {
            this.data[i + n] = this.bdata[i];
        }
    }

    public void setShort(int n, long l) {
        CommonUtils.clearBuffer(this.buffer);
        this.buffer.putShort(0, (short)l);
        for (int i = 0; i < 2; ++i) {
            this.data[i + n] = this.bdata[i];
        }
    }

    public byte[] getBytes() {
        return this.data;
    }
}

