/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CommonUtils;
import java.util.Iterator;
import java.util.LinkedList;

public class PortFlipper {
    protected String ports;
    protected boolean hasError;
    protected String description;

    public boolean hasError() {
        return this.hasError;
    }

    public String getError() {
        return this.description;
    }

    public int check(int n) {
        if (n < 0 || n > 65535) {
            this.hasError = true;
            this.description = "Invalid port value '" + n + "'";
        }
        return n;
    }

    public LinkedList parse() {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        String[] stringArray = this.ports.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            if (CommonUtils.isNumber(stringArray[i])) {
                linkedList.add(this.check(CommonUtils.toNumber(stringArray[i], -1)));
                continue;
            }
            if (stringArray[i].matches("\\d+-\\d+")) {
                String[] stringArray2 = stringArray[i].split("-");
                int n = this.check(CommonUtils.toNumber(stringArray2[1], 0));
                for (int j = this.check(CommonUtils.toNumber(stringArray2[0], 0)); j <= n; ++j) {
                    linkedList.add(j);
                }
                continue;
            }
            this.description = "Invalid port or range '" + stringArray[i] + "'";
            this.hasError = true;
        }
        return linkedList;
    }

    public PortFlipper(String string) {
        this.ports = string;
    }

    private static void A(byte[] byArray, int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        int n4 = n2;
        byArray[n4] = (byte)(byArray[n4] + (1 << n3));
    }

    public Iterator iterator() {
        return this.parse().iterator();
    }

    public byte[] getMask() {
        byte[] byArray = new byte[8192];
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            PortFlipper.A(byArray, (Integer)iterator.next());
        }
        return byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }
}

