/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.AggressorInfo;
import common.CommonUtils;
import common.DisconnectListener;
import common.MudgeSanity;
import dialog.DialogUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;

public class TeamSocket {
    protected String from;
    protected boolean connected = true;
    protected List listeners = new LinkedList();
    protected Socket client;
    protected OutputStream bout = null;
    protected boolean headless;
    protected boolean hasReadAnObject = false;

    public TeamSocket(Socket socket) throws Exception {
        this(socket, true);
    }

    public TeamSocket(Socket socket, boolean bl) throws Exception {
        this.headless = bl;
        this.client = socket;
        socket.setSoTimeout(0);
        this.from = socket.getInetAddress().getHostAddress();
    }

    public String getHostAddress() {
        return this.from;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisconnectListener(DisconnectListener disconnectListener) {
        TeamSocket teamSocket = this;
        synchronized (teamSocket) {
            this.listeners.add(disconnectListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDisconnectEvent() {
        TeamSocket teamSocket = this;
        synchronized (teamSocket) {
            for (DisconnectListener disconnectListener : this.listeners) {
                disconnectListener.disconnected(this);
            }
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        TeamSocket teamSocket = this;
        synchronized (teamSocket) {
            return this.connected;
        }
    }

    public Object readObject() {
        try {
            if (this.isConnected()) {
                ObjectInputStream objectInputStream = new ObjectInputStream(this.client.getInputStream());
                this.hasReadAnObject = true;
                return objectInputStream.readUnshared();
            }
        }
        catch (IOException iOException) {
            MudgeSanity.logException("client (" + this.from + ") read", iOException, true);
            this.close();
            if (!this.hasReadAnObject) {
                String string = "Unable to read object.  Are are you connecting to a " + AggressorInfo.VERSION + " team server?";
                CommonUtils.print_error(string);
                if (!this.headless) {
                    DialogUtils.showError(string);
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            MudgeSanity.logException("class not found", classNotFoundException, false);
            this.close();
        }
        catch (Exception exception) {
            MudgeSanity.logException("client (" + this.from + ") read", exception, false);
            this.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.isConnected()) {
            return;
        }
        TeamSocket teamSocket = this;
        synchronized (teamSocket) {
            try {
                this.connected = false;
                if (this.bout != null) {
                    this.bout.close();
                }
                if (this.client != null) {
                    this.client.close();
                }
            }
            catch (Exception exception) {
                MudgeSanity.logException("client (" + this.from + ") close", exception, false);
            }
            this.fireDisconnectEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(Object object) {
        if (!this.isConnected()) {
            return;
        }
        try {
            Socket socket = this.client;
            synchronized (socket) {
                if (this.bout == null) {
                    this.bout = new BufferedOutputStream(this.client.getOutputStream(), 262144);
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.bout);
                objectOutputStream.writeUnshared(object);
                objectOutputStream.flush();
            }
        }
        catch (IOException iOException) {
            MudgeSanity.logException("client (" + this.from + ") write", iOException, true);
            this.close();
        }
        catch (Exception exception) {
            MudgeSanity.logException("client (" + this.from + ") write", exception, false);
            this.close();
        }
    }
}

