/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CommonUtils;
import common.Informant;
import common.Loggable;
import common.Scriptable;
import common.Transcript;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import sleep.runtime.Scalar;
import sleep.runtime.SleepUtils;

public class WebEvent
implements Serializable,
Transcript,
Scriptable,
Loggable,
Informant {
    public String method;
    public String addr;
    public String ua;
    public String from;
    public Map params;
    public String handler;
    public long when = System.currentTimeMillis();
    public String response;
    public long size;
    public String uri;
    public int port;

    public WebEvent(String string, String string2, String string3, String string4, String string5, String string6, Map map2, String string7, long l, int n) {
        this.method = string;
        this.uri = string2;
        this.addr = string3;
        this.ua = string4;
        this.from = string5;
        this.handler = string6;
        this.params = map2;
        this.response = string7;
        this.size = l;
        this.port = n;
        this.params.remove("input");
    }

    @Override
    public Stack eventArguments() {
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(SleepUtils.getScalar(this.port));
        stack.push(SleepUtils.getScalar(this.when));
        stack.push(SleepUtils.getHashWrapper(this.params));
        stack.push(SleepUtils.getScalar(this.handler));
        stack.push(SleepUtils.getScalar(this.size));
        stack.push(SleepUtils.getScalar(this.response));
        stack.push(SleepUtils.getScalar(this.ua));
        stack.push(SleepUtils.getScalar(this.addr));
        stack.push(SleepUtils.getScalar(this.uri));
        stack.push(SleepUtils.getScalar(this.method));
        return stack;
    }

    @Override
    public String eventName() {
        return "web_hit";
    }

    @Override
    public String getBeaconId() {
        return null;
    }

    @Override
    public void formatEvent(DataOutputStream dataOutputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.addr);
        stringBuffer.append(" ");
        if (this.from != null || "unknown".equals(this.from)) {
            stringBuffer.append(this.from);
            stringBuffer.append(" ");
            stringBuffer.append(this.from);
            stringBuffer.append(" [");
        } else {
            stringBuffer.append("- - [");
        }
        stringBuffer.append(CommonUtils.formatLogDate(this.when));
        stringBuffer.append("] \"");
        stringBuffer.append(this.method);
        stringBuffer.append(" ");
        stringBuffer.append(this.uri);
        stringBuffer.append("\" ");
        stringBuffer.append(this.response.split(" ")[0]);
        stringBuffer.append(" ");
        stringBuffer.append(this.size);
        stringBuffer.append(" \"");
        if (this.handler != null) {
            stringBuffer.append(this.handler);
        }
        stringBuffer.append("\" \"");
        stringBuffer.append(this.ua);
        stringBuffer.append("\"\n");
        dataOutputStream.writeBytes(stringBuffer.toString());
    }

    @Override
    public String getLogFile() {
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append("weblog_");
        stringBuffer.append(this.port);
        stringBuffer.append(".log");
        return stringBuffer.toString();
    }

    @Override
    public String getLogFolder() {
        return null;
    }

    @Override
    public long getLogLimit() {
        return 0L;
    }

    @Override
    public String getLogEventName() {
        return "Web Event";
    }

    @Override
    public boolean hasInformation() {
        return this.response.startsWith("200") && !"".equals(this.handler);
    }

    @Override
    public Map archive() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("when", this.when);
        hashMap.put("type", "webhit");
        hashMap.put("data", "visit to " + this.uri + " (" + this.handler + ") by " + this.addr);
        hashMap.put("port", this.port);
        if (this.params.containsKey("id")) {
            hashMap.put("token", this.params.get("id"));
        }
        return hashMap;
    }
}

