/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.Serializable;
import java.util.ArrayList;

public class WebServersPersistentData
implements Serializable {
    protected ArrayList<WebServerData> _servers = new ArrayList();
    protected static final long serialVersionUID = 1L;

    public WebServerData[] getServers() {
        return this._servers.toArray(new WebServerData[this._servers.size()]);
    }

    public WebServerData getOrAddServer(int n, boolean bl) {
        WebServerData webServerData = this.getServer(n);
        if (webServerData == null) {
            webServerData = new WebServerData(n, bl);
            this._servers.add(webServerData);
        }
        return webServerData;
    }

    public WebServerData getServer(int n) {
        WebServerData webServerData = null;
        for (WebServerData webServerData2 : this._servers) {
            if (webServerData2 == null || webServerData2._port != n) continue;
            webServerData = webServerData2;
            break;
        }
        return webServerData;
    }

    public void removeServersWithNoItems() {
        ArrayList<WebServerData> arrayList = new ArrayList<WebServerData>();
        for (WebServerData webServerData : this._servers) {
            if (webServerData == null || webServerData.size() > 0) continue;
            arrayList.add(webServerData);
        }
        if (arrayList.size() > 0) {
            this._servers.removeAll(arrayList);
        }
    }

    public int size() {
        return this._servers.size();
    }

    public class WebServerData
    implements Serializable {
        protected boolean _isSSL;
        protected int _port;
        protected ArrayList<WebServerItemBase> _items = new ArrayList();
        protected static final long serialVersionUID = 1L;

        public WebServerData() {
        }

        public WebServerData(int n, boolean bl) {
            this._port = n;
            this._isSSL = bl;
        }

        public boolean getIsSSL() {
            return this._isSSL;
        }

        public int getPort() {
            return this._port;
        }

        public WebServerItemBase[] getItems() {
            return this._items.toArray(new WebServerItemBase[this._items.size()]);
        }

        public int size() {
            return this._items.size();
        }

        public void addServerFile(String string, String string2, String string3, String string4) {
            this._items.add(new WebServerFile(string, string2, string3, string4));
        }

        public void addServerStatic(String string, String string2, String string3, String string4, String string5) {
            this._items.add(new WebServerStatic(string, string2, string3, string4, string5));
        }

        public void addServerApplet(String string, String string2, byte[] byArray, byte[] byArray2, String string3, String string4, String string5) {
            this._items.add(new WebServerApplet(string, string2, byArray, byArray2, string3, string4, string5));
        }

        public void addServerKeyLogger(String string, String string2, String string3, String string4, String string5, String[] stringArray) {
            this._items.add(new WebServerKeyLogger(string, string2, string3, string4, string5, stringArray));
        }

        public void addServerSystemProfiler(String string, String string2, String string3, String string4, String string5) {
            this._items.add(new WebServerSystemProfiler(string, string2, string3, string4, string5));
        }

        public class WebServerSystemProfiler
        extends WebServerItemBase {
            protected String _redirectUrl;
            protected String _description;
            protected String _allowJava;
            protected static final long serialVersionUID = 1L;

            public WebServerSystemProfiler() {
            }

            public WebServerSystemProfiler(String string, String string2, String string3, String string4, String string5) {
                super(string, "", string2);
                this._redirectUrl = string3;
                this._description = string4;
                this._allowJava = string5;
            }

            public String getRedirectUrl() {
                return this._redirectUrl;
            }

            public String getDescription() {
                return this._description;
            }

            public String getAllowJava() {
                return this._allowJava;
            }
        }

        public class WebServerKeyLogger
        extends WebServerItemBase {
            protected String _content;
            protected String _description;
            protected String[] _curls;
            protected static final long serialVersionUID = 1L;

            public WebServerKeyLogger() {
                this._curls = new String[0];
            }

            public WebServerKeyLogger(String string, String string2, String string3, String string4, String string5, String[] stringArray) {
                super(string, string2, string3);
                this._curls = new String[0];
                this._content = string4;
                this._description = string5;
                this._curls = stringArray;
            }

            public String getContent() {
                return this._content;
            }

            public String getDescription() {
                return this._description;
            }

            public String[] getCurls() {
                return this._curls;
            }
        }

        public class WebServerApplet
        extends WebServerItemBase {
            protected byte[] _applet;
            protected byte[] _javaPayload;
            protected String _stager;
            protected String _clazz;
            protected String _title;
            protected static final long serialVersionUID = 1L;

            public WebServerApplet() {
            }

            public WebServerApplet(String string, String string2, byte[] byArray, byte[] byArray2, String string3, String string4, String string5) {
                super(string, "", string2);
                this._applet = byArray;
                this._javaPayload = byArray2;
                this._stager = string3;
                this._clazz = string4;
                this._title = string5;
            }

            public byte[] getApplet() {
                return this._applet;
            }

            public byte[] getJavaPayload() {
                return this._javaPayload;
            }

            public String getStager() {
                return this._stager;
            }

            public String getClazz() {
                return this._clazz;
            }

            public String get_title() {
                return this._title;
            }
        }

        public class WebServerStatic
        extends WebServerItemBase {
            protected String _data;
            protected String _description;
            protected static final long serialVersionUID = 1L;

            public WebServerStatic() {
            }

            public WebServerStatic(String string, String string2, String string3, String string4, String string5) {
                super(string, string2, string3);
                this._data = string4;
                this._description = string5;
            }

            public String getData() {
                return this._data;
            }

            public String getDescription() {
                return this._description;
            }
        }

        public class WebServerFile
        extends WebServerItemBase {
            protected String _filePath;
            protected static final long serialVersionUID = 1L;

            public WebServerFile() {
            }

            public WebServerFile(String string, String string2, String string3, String string4) {
                super(string, string2, string3);
                this._filePath = string4;
            }

            public String getFilePath() {
                return this._filePath;
            }
        }

        public abstract class WebServerItemBase
        implements Serializable {
            protected String _uri;
            protected String _MIMEType;
            protected String _host;
            protected static final long serialVersionUID = 1L;

            public WebServerItemBase() {
            }

            public WebServerItemBase(String string, String string2, String string3) {
                this._uri = string;
                this._MIMEType = string2;
                this._host = string3;
            }

            public String getURI() {
                return this._uri;
            }

            public String getMIMEType() {
                return this._MIMEType;
            }

            public String getHost() {
                return this._host;
            }
        }
    }
}

