/*
 * Decompiled with CFR 0.152.
 */
package common;

import c2profile.Profile;
import cloudstrike.Response;
import cloudstrike.ResponseFilter;
import common.CommonUtils;
import common.MudgeSanity;
import java.util.List;
import java.util.Map;

public class WebTransforms
implements ResponseFilter {
    protected List order;
    protected Map headers;
    protected Profile c2profile;

    public WebTransforms(Profile profile) {
        this.c2profile = profile;
        this.order = profile.hasString(".http-config.headers") ? CommonUtils.toList(profile.getString(".http-config.headers")) : null;
        this.headers = profile.getHeadersAsMap(".http-config");
        if (this.headers.size() == 0) {
            this.headers = null;
        }
    }

    @Override
    public void filterResponse(Response response) {
        try {
            if (this.headers != null) {
                for (Map.Entry entry : this.headers.entrySet()) {
                    if (response.header.containsKey(entry.getKey())) continue;
                    response.addHeader(entry.getKey().toString(), entry.getValue().toString());
                }
            }
            if (this.order != null) {
                response.orderHeaders(this.order);
            }
        }
        catch (Throwable throwable) {
            MudgeSanity.logException("filterResponse failed", throwable, false);
        }
    }
}

