/*
 * Decompiled with CFR 0.152.
 */
package console;

import aggressor.Prefs;
import common.CommonUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Properties;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class Colors {
    public static final char bold = '\u0002';
    public static final char underline = '\u001f';
    public static final char color = '\u0003';
    public static final char cancel = '\u000f';
    public static final char reverse = '\u0016';
    protected boolean showcolors = true;
    protected Color[] colorTable;
    private StyledDocument A = new DefaultStyledDocument();

    public static String color(String string, String string2) {
        return '\u0003' + string2 + string;
    }

    public static String underline(String string) {
        return '\u001f' + string + '\u000f';
    }

    public Colors(Properties properties) {
        this.colorTable = new Color[16];
        this.colorTable[0] = Color.white;
        this.colorTable[1] = new Color(0, 0, 0);
        this.colorTable[2] = Color.decode("#3465A4");
        this.colorTable[3] = Color.decode("#4E9A06");
        this.colorTable[4] = Color.decode("#EF2929");
        this.colorTable[5] = Color.decode("#CC0000");
        this.colorTable[6] = Color.decode("#75507B");
        this.colorTable[7] = Color.decode("#C4A000");
        this.colorTable[8] = Color.decode("#FCE94F");
        this.colorTable[9] = Color.decode("#8AE234");
        this.colorTable[10] = Color.decode("#06989A");
        this.colorTable[11] = Color.decode("#34E2E2");
        this.colorTable[12] = Color.decode("#729FCF");
        this.colorTable[13] = Color.decode("#AD7FA8");
        this.colorTable[14] = Color.decode("#808080");
        this.colorTable[15] = Color.lightGray;
        for (int i = 0; i < 16; ++i) {
            String string = Prefs.getPreferences().getString("console.color_" + i + ".color", null);
            if (string == null) continue;
            this.colorTable[i] = Color.decode(string);
        }
        this.showcolors = "true".equals(Prefs.getPreferences().getString("console.show_colors.boolean", "true"));
    }

    public String strip(String string) {
        _A _A2 = this.A(string);
        return this.A(_A2);
    }

    private String A(_A _A2) {
        StringBuffer stringBuffer = new StringBuffer(128);
        while (_A2 != null) {
            stringBuffer.append(_A2.C);
            _A2 = _A2.B;
        }
        return stringBuffer.toString();
    }

    private void A(StyledDocument styledDocument, _A _A2) {
        while (_A2 != null) {
            try {
                if (_A2.C.length() > 0) {
                    styledDocument.insertString(styledDocument.getLength(), _A2.C.toString(), _A2.A);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            _A2 = _A2.B;
        }
    }

    public void append(StyledDocument styledDocument, String string) {
        if (string.length() > 262144) {
            string = string.substring(string.length() - 262144, string.length());
        }
        _A _A2 = this.A(string);
        this.A(styledDocument, _A2);
        if (styledDocument.getLength() > 393216) {
            int n = styledDocument.getLength() - 327680;
            try {
                styledDocument.remove(0, n);
            }
            catch (BadLocationException badLocationException) {
                CommonUtils.print_error("Error trimming " + n + " characters from document length " + styledDocument.getLength() + ".");
            }
        }
    }

    public void append(JTextPane jTextPane, String string) {
        StyledDocument styledDocument = jTextPane.getStyledDocument();
        if (this.showcolors) {
            jTextPane.setDocument(this.A);
            this.append(styledDocument, string);
            jTextPane.setDocument(styledDocument);
        } else {
            _A _A2 = this.A(string);
            this.A(styledDocument, this.A(this.A(_A2)));
        }
    }

    public void set(JTextPane jTextPane, String string) {
        _A _A2 = this.A(string);
        if (this.A(_A2).equals(jTextPane.getText())) {
            return;
        }
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
        if (this.showcolors) {
            this.A(defaultStyledDocument, _A2);
        } else {
            this.A(defaultStyledDocument, this.A(this.A(_A2)));
        }
        jTextPane.setDocument(defaultStyledDocument);
        jTextPane.setSize(new Dimension(1000, jTextPane.getSize().height));
    }

    public void setNoHack(JTextPane jTextPane, String string) {
        _A _A2 = this.A(string);
        if (this.A(_A2).equals(jTextPane.getText())) {
            return;
        }
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
        if (this.showcolors) {
            this.A(defaultStyledDocument, _A2);
        } else {
            this.A(defaultStyledDocument, this.A(this.A(_A2)));
        }
        jTextPane.setDocument(defaultStyledDocument);
    }

    private _A A(String string) {
        _A _A2;
        _A _A3 = _A2 = new _A();
        if (string == null) {
            return _A2;
        }
        char[] cArray = string.toCharArray();
        block7: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\u0002': {
                    _A2.A();
                    StyleConstants.setBold(_A2.B.A, !StyleConstants.isBold(_A2.A));
                    _A2 = _A2.B;
                    continue block7;
                }
                case '\u001f': {
                    _A2.A();
                    StyleConstants.setUnderline(_A2.B.A, !StyleConstants.isUnderline(_A2.A));
                    _A2 = _A2.B;
                    continue block7;
                }
                case '\u0003': {
                    _A2.A();
                    if (i + 1 < cArray.length && (cArray[i + 1] >= '0' && cArray[i + 1] <= '9' || cArray[i + 1] >= 'A' && cArray[i + 1] <= 'F')) {
                        int n = Integer.parseInt(cArray[i + 1] + "", 16);
                        StyleConstants.setForeground(_A2.B.A, this.colorTable[n]);
                        ++i;
                    }
                    _A2 = _A2.B;
                    continue block7;
                }
                case '\n': {
                    _A2.A();
                    _A2 = _A2.B;
                    _A2.A = new SimpleAttributeSet();
                    _A2.C.append(cArray[i]);
                    continue block7;
                }
                case '\u000f': {
                    _A2.A();
                    _A2 = _A2.B;
                    _A2.A = new SimpleAttributeSet();
                    continue block7;
                }
                default: {
                    _A2.C.append(cArray[i]);
                }
            }
        }
        return _A3;
    }

    private static final class _A {
        protected SimpleAttributeSet A = new SimpleAttributeSet();
        protected StringBuffer C = new StringBuffer(32);
        protected _A B = null;

        private _A() {
        }

        public void A() {
            this.B = new _A();
            this.B.A = (SimpleAttributeSet)this.A.clone();
        }
    }
}

