/*
 * Decompiled with CFR 0.152.
 */
package console;

import aggressor.Prefs;
import common.CommandParser;
import common.CommonUtils;
import common.WindowsErrorCodes;
import console.AssociatedPanel;
import console.Colors;
import console.ConsolePopup;
import console.SearchPanel;
import console.StatusBar;
import dialog.DialogUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

public class Console
extends AssociatedPanel
implements FocusListener,
CaretListener {
    protected JTextPane console;
    protected JTextField input;
    protected JTextPane prompt;
    protected StatusBar status;
    protected PrintStream log = null;
    protected Properties display;
    protected Font consoleFont;
    protected Colors colors;
    protected ClickListener clickl;
    protected String defaultPrompt = "aggressor > ";
    protected LinkedList components = new LinkedList();
    protected ArrowDirection arrowDirection = ArrowDirection.NONE;
    protected LinkedList historyList = new LinkedList();
    protected ListIterator history = this.historyList.listIterator(0);
    protected boolean promptLock = false;
    protected _A[] colorme = null;
    protected JPanel bottom = null;

    public void addWordClickListener(ActionListener actionListener) {
        this.clickl.addListener(actionListener);
    }

    public void writeToLog(PrintStream printStream) {
        this.log = printStream;
    }

    public void setDefaultPrompt(String string) {
        this.defaultPrompt = string;
    }

    public void setPopupMenu(ConsolePopup consolePopup) {
        this.clickl.setPopup(consolePopup);
    }

    public JTextField getInput() {
        return this.input;
    }

    public void updateProperties(Properties properties) {
        this.display = properties;
        this.B();
    }

    private void B() {
        this.colors = new Colors(this.display);
        Color color = Prefs.getPreferences().getColor("console.foreground.color", "#c0c0c0");
        Color color2 = Prefs.getPreferences().getColor("console.background.color", "#000000");
        for (JComponent jComponent : this.components) {
            if (jComponent == this.status) {
                jComponent.setFont(this.consoleFont);
                continue;
            }
            jComponent.setForeground(color);
            jComponent.setBackground(color2);
            if (jComponent == this.console || jComponent == this.prompt) {
                jComponent.setOpaque(false);
            }
            jComponent.setFont(this.consoleFont);
            if (jComponent == this.console || jComponent == this.prompt) {
                jComponent.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            } else {
                jComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            }
            if (!(jComponent instanceof JTextComponent)) continue;
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            jTextComponent.setCaretColor(color.brighter());
        }
    }

    public String getPromptText() {
        return this.prompt.getText();
    }

    public void setPrompt(String string) {
        String string2 = "\ufffd\ufffd";
        if (string.equals(string2) || string.equals("null")) {
            this.colors.set(this.prompt, this.fixText(this.defaultPrompt));
        } else {
            this.defaultPrompt = string;
            this.colors.set(this.prompt, this.fixText(string));
        }
    }

    public void updatePrompt(final String string) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                if (!Console.this.promptLock) {
                    Console.this.setPrompt(string);
                }
            }
        });
    }

    public void setStyle(String string) {
        String[] stringArray = string.trim().split("\n");
        this.colorme = new _A[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("\\t+");
            if (stringArray2.length == 2) {
                stringArray2[1] = stringArray2[1].replace("\\c", "\u0003");
                stringArray2[1] = stringArray2[1].replace("\\o", "\u000f");
                stringArray2[1] = stringArray2[1].replace("\\u", "\u001f");
                this.colorme[i] = new _A(stringArray2[0], stringArray2[1]);
                continue;
            }
            System.err.println(stringArray[i] + "<-- didn't split right:" + stringArray2.length);
        }
    }

    protected String fixText(String string) {
        if (this.colorme == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = string.split("(?<=\\n)");
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            for (int j = 0; j < this.colorme.length; ++j) {
                if (this.colorme[j] == null) continue;
                string2 = this.colorme[j].B.matcher(string2).replaceFirst(this.colorme[j].A);
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    protected void appendToConsole(String string) {
        if ((string = this.fixText(string)).length() == 0) {
            return;
        }
        if (string.endsWith("\n") || string.endsWith("\r")) {
            if (!this.promptLock) {
                this.colors.append(this.console, string);
                if (this.log != null) {
                    this.log.print(this.colors.strip(string));
                }
            } else {
                this.colors.append(this.console, this.prompt.getText());
            }
            if (!string.startsWith(this.prompt.getText())) {
                this.promptLock = false;
            }
        } else {
            int n = string.lastIndexOf("\n");
            if (n != -1) {
                this.colors.append(this.console, string.substring(0, n + 1));
                this.updatePrompt(string.substring(n + 1) + " ");
                if (this.log != null) {
                    this.log.print(this.colors.strip(string.substring(0, n + 1)));
                }
            } else {
                this.updatePrompt(string);
            }
            this.promptLock = true;
        }
        if (this.console.getDocument().getLength() >= 1) {
            this.console.setCaretPosition(this.console.getDocument().getLength() - 1);
        }
    }

    public void append(final String string) {
        if (string == null) {
            return;
        }
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                Console.this.appendToConsole(string);
            }
        });
    }

    public void clear() {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                Console.this.console.setText("");
            }
        });
    }

    public void noInput() {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                Console.this.remove(Console.this.bottom);
                Console.this.validate();
            }
        });
    }

    public Console() {
        this(new Properties(), false);
    }

    public Console(boolean bl) {
        this(new Properties(), bl);
    }

    public Console(Properties properties, boolean bl) {
        this.display = properties;
        this.consoleFont = Prefs.getPreferences().getFont("console.font.font", "Monospaced BOLD 14");
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.console = new JTextPane();
        this.console.setEditable(false);
        this.console.addFocusListener(this);
        this.console.setCaret(new DefaultCaret(){

            @Override
            public void setSelectionVisible(boolean bl) {
                super.setSelectionVisible(true);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.console, 22, 30);
        this.add((Component)jScrollPane, "Center");
        this.prompt = new JTextPane();
        this.prompt.setEditable(false);
        this.input = new JTextField();
        this.input.setKeymap(JTextField.addKeymap(null, this.input.getKeymap()));
        this.input.addMouseListener(new MouseAdapter(){

            public void A(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    Console.this.getPopupMenu((JTextComponent)mouseEvent.getSource()).show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                this.A(mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.A(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.A(mouseEvent);
            }
        });
        this.input.setFocusTraversalKeys(0, new HashSet());
        this.input.setFocusTraversalKeys(1, new HashSet());
        this.input.setFocusTraversalKeys(2, new HashSet());
        this.bottom = new JPanel();
        this.bottom.setLayout(new BorderLayout());
        this.status = new StatusBar(properties);
        if (bl) {
            this.bottom.add((Component)this.status, "North");
        }
        this.bottom.add((Component)this.input, "Center");
        this.bottom.add((Component)this.prompt, "West");
        this.add((Component)this.bottom, "South");
        this.components.add(this.input);
        this.components.add(this.console);
        this.components.add(jScrollPane);
        this.components.add(this.prompt);
        this.components.add(this.bottom);
        this.components.add(this.status);
        this.components.add(this);
        this.B();
        this.addActionForKeySetting("console.clear_screen.shortcut", "ctrl K", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.console.setText("");
            }
        });
        this.addActionForKeySetting("console.select_all.shortcut", "ctrl A", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.console.requestFocus();
                Console.this.console.selectAll();
            }
        });
        this.addActionForKeySetting("console.clear_buffer.shortcut", "ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.input.setText("");
            }
        });
        this.addActionForKeySetting("console.copy.shortcut", "ctrl C", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = Console.this.A(Console.this.console, false);
                if (string == null || string.isEmpty()) {
                    string = Console.this.A(Console.this.input, false);
                }
            }
        });
        this.addActionForKeySetting("console.cut.shortcut", "ctrl X", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.A(Console.this.input, true);
            }
        });
        this.addActionForKeySetting("console.paste.shortcut", "ctrl V", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.input.paste();
            }
        });
        this.console.addCaretListener(this);
        this.input.addCaretListener(this);
        this.A();
        this.E();
        this.D();
        this.C();
        this.clickl = new ClickListener(this);
        this.console.addMouseListener(this.clickl);
    }

    private String A(JTextComponent jTextComponent, boolean bl) {
        String string = jTextComponent.getSelectedText();
        if (string != null && !string.isEmpty()) {
            if (bl) {
                jTextComponent.cut();
            } else {
                jTextComponent.copy();
            }
            DialogUtils.addToClipboardQuiet(string);
        }
        return string;
    }

    public StatusBar getStatusBar() {
        return this.status;
    }

    public JPopupMenu getPopupMenu(final JTextComponent jTextComponent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Cut", 67);
        JMenuItem jMenuItem2 = new JMenuItem("Copy", 111);
        JMenuItem jMenuItem3 = new JMenuItem("Paste", 80);
        JMenuItem jMenuItem4 = new JMenuItem("Clear", 108);
        if (jTextComponent.isEditable()) {
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.add(jMenuItem2);
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.add(jMenuItem4);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.A(jTextComponent, false);
            }
        });
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.A(jTextComponent, true);
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.input.paste();
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextComponent.setText("");
            }
        });
        return jPopupMenu;
    }

    private void A() {
        Properties properties = this.display;
        final Console console = this;
        this.addActionForKeySetting("console.find.shortcut", "ctrl pressed F", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = Prefs.getPreferences().getColor("console.highlight.color", "#0000cc");
                final SearchPanel searchPanel = new SearchPanel(Console.this.console, color);
                final JPanel jPanel = new JPanel();
                JButton jButton = new JButton("X ");
                DialogUtils.removeBorderFromButton(jButton);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        console.remove(jPanel);
                        console.validate();
                        searchPanel.clear();
                    }
                });
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)searchPanel, "Center");
                jPanel.add((Component)jButton, "East");
                console.add((Component)jPanel, "North");
                console.validate();
                searchPanel.requestFocusInWindow();
                searchPanel.requestFocus();
            }
        });
    }

    private void D() {
        this.addActionForKeySetting("console.font_size_plus.shortcut", "ctrl EQUALS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.A(1.0f);
            }
        });
        this.addActionForKeySetting("console.font_size_minus.shortcut", "ctrl MINUS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.A(-1.0f);
            }
        });
        this.addActionForKeySetting("console.font_size_reset.shortcut", "ctrl pressed 0", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.consoleFont = Prefs.getPreferences().getFont("console.font.font", "Monospaced BOLD 14");
                Console.this.B();
            }
        });
    }

    private void E() {
        this.addActionForKeySetting("console.page_up.shortcut", "pressed PAGE_UP", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rectangle rectangle = new Rectangle(Console.this.console.getVisibleRect());
                Rectangle rectangle2 = new Rectangle(0, (int)(rectangle.getY() - rectangle.getHeight() / 2.0), 1, 1);
                if (rectangle2.getY() <= 0.0) {
                    rectangle.setLocation(0, 0);
                }
                Console.this.console.scrollRectToVisible(rectangle2);
            }
        });
        this.addActionForKeySetting("console.page_down.shortcut", "pressed PAGE_DOWN", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rectangle rectangle = new Rectangle(Console.this.console.getVisibleRect());
                Rectangle rectangle2 = new Rectangle(0, (int)(rectangle.getY() + rectangle.getHeight() + rectangle.getHeight() / 2.0), 1, 1);
                if (rectangle2.getY() >= (double)Console.this.console.getHeight()) {
                    rectangle.setLocation(0, Console.this.console.getHeight());
                }
                Console.this.console.scrollRectToVisible(rectangle2);
            }
        });
    }

    private void C() {
        this.addActionForKeySetting("console.history_previous.shortcut", "UP", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Console.this.arrowDirection == ArrowDirection.DOWN && Console.this.history.hasPrevious()) {
                    Console.this.history.previous();
                }
                if (Console.this.history.hasPrevious()) {
                    Console.this.input.setText((String)Console.this.history.previous());
                    Console.this.arrowDirection = ArrowDirection.UP;
                } else {
                    Console.this.input.setText("");
                    Console.this.arrowDirection = ArrowDirection.NONE;
                }
            }
        });
        this.addActionForKeySetting("console.history_next.shortcut", "DOWN", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Console.this.arrowDirection == ArrowDirection.UP && Console.this.history.hasNext()) {
                    Console.this.history.next();
                }
                if (Console.this.history.hasNext()) {
                    Console.this.input.setText((String)Console.this.history.next());
                    Console.this.arrowDirection = ArrowDirection.DOWN;
                } else {
                    Console.this.input.setText("");
                    Console.this.arrowDirection = ArrowDirection.NONE;
                }
            }
        });
    }

    public void addCommandToHistory(String string) {
        if (!"".equals(string)) {
            this.A(this.history);
            this.arrowDirection = ArrowDirection.NONE;
            if (this.history.hasPrevious()) {
                String string2 = (String)this.history.previous();
                this.A(this.history);
                if (string.equals(string2)) {
                    return;
                }
            }
            this.history.add(string);
        }
    }

    private void A(ListIterator listIterator) {
        while (listIterator.hasNext()) {
            listIterator.next();
        }
    }

    public void showHistory(int n) {
        try {
            if (n > 0) {
                this.A("Command History: show last " + n);
            } else {
                this.A("Command History: show all");
            }
            int n2 = this.historyList.size();
            int n3 = 1;
            if (n > 0 && n < n2) {
                n3 = n2 - n + 1;
            }
            for (int i = n3; i <= n2; ++i) {
                String string = String.format("%5d", i) + "  " + this.historyList.get(i - 1);
                this.A(string);
            }
        }
        catch (Throwable throwable) {
            CommonUtils.print_error("Error processing history command: " + n);
            throwable.printStackTrace();
            return;
        }
    }

    private void A(String string) {
        this.appendToConsole(string + "\n");
    }

    public String processHistoryBang(String string) throws Exception {
        CharSequence charSequence;
        CommandParser commandParser = new CommandParser(string);
        if (!commandParser.getCommand().startsWith("!")) {
            return "";
        }
        if (this.historyList.size() == 0) {
            throw new Exception("Invalid command " + string);
        }
        if (commandParser.getCommand().length() > 1) {
            charSequence = new StringBuffer(string);
            ((StringBuffer)charSequence).insert(1, " ");
            commandParser = new CommandParser(((StringBuffer)charSequence).toString());
        }
        charSequence = "";
        if (commandParser.verify("I") || commandParser.reset()) {
            int n = commandParser.popInt();
            if (n > 0 && n > this.historyList.size() || n < 0 && Math.abs(n) > this.historyList.size() || n == 0) {
                throw new Exception("Invalid command " + string);
            }
            if (n < 0) {
                n = this.historyList.size() + n + 1;
            }
            charSequence = this.historyList.get(n - 1).toString();
        } else if (commandParser.verify("Z") || commandParser.reset()) {
            String string2 = commandParser.popString();
            if ("!".equals(string2.toLowerCase())) {
                charSequence = this.historyList.getLast().toString();
            } else {
                String string3;
                Boolean bl;
                if (string2.startsWith("?")) {
                    bl = true;
                    string3 = string2.substring(1);
                } else {
                    bl = false;
                    string3 = string2;
                }
                if (string3.isEmpty()) {
                    throw new Exception("Invalid command " + string);
                }
                for (int i = this.historyList.size() - 1; i >= 0; --i) {
                    String string4 = this.historyList.get(i).toString();
                    if (bl.booleanValue()) {
                        if (!string4.contains(string3)) continue;
                        charSequence = string4;
                        break;
                    }
                    if (!string4.startsWith(string3)) continue;
                    charSequence = string4;
                    break;
                }
                if (((String)charSequence).isEmpty()) {
                    throw new Exception("Invalid command " + string);
                }
            }
        } else {
            throw new Exception("Invalid command " + string);
        }
        return charSequence;
    }

    public void showErrorCodeMessage(Long l) {
        this.A(WindowsErrorCodes.getErrorString(l));
    }

    private void A(float f) {
        this.consoleFont = this.consoleFont.deriveFont(this.consoleFont.getSize2D() + f);
        this.B();
    }

    public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
        this.input.getKeymap().addActionForKeyStroke(keyStroke, action);
    }

    public void addActionForKey(String string, Action action) {
        this.addActionForKeyStroke(KeyStroke.getKeyStroke(string), action);
    }

    public void addActionForKeySetting(String string, String string2, Action action) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(this.display.getProperty(string, string2));
        if (keyStroke != null) {
            this.addActionForKeyStroke(keyStroke, action);
        }
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        int n;
        if (caretEvent.getSource() == this.console) {
            int n2 = this.console.getSelectionEnd() - this.console.getSelectionStart();
            if (n2 > 0) {
                this.input.setSelectionStart(this.input.getSelectionEnd());
            }
        } else if (caretEvent.getSource() == this.input && (n = this.input.getSelectionEnd() - this.input.getSelectionStart()) > 0) {
            this.console.setSelectionStart(this.console.getSelectionEnd());
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary() && focusEvent.getComponent() == this.console && (System.getProperty("os.name") + "").indexOf("Windows") == -1 && (System.getProperty("os.name") + "").indexOf("Mac") == -1) {
            this.input.requestFocusInWindow();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.input.requestFocusInWindow();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    private static class _A {
        public Pattern B;
        public String A;

        public _A(String string, String string2) {
            this.B = Pattern.compile(string);
            this.A = string2;
        }
    }

    public class ClickListener
    extends MouseAdapter {
        protected LinkedList listeners = new LinkedList();
        protected ConsolePopup popup = null;
        protected Console parent = null;

        public ClickListener(Console console2) {
            this.parent = console2;
        }

        public void setPopup(ConsolePopup consolePopup) {
            this.popup = consolePopup;
        }

        public void addListener(ActionListener actionListener) {
            this.listeners.add(actionListener);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.checkPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkPopup(mouseEvent);
        }

        public void checkPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (this.popup != null && Console.this.console.getSelectedText() == null) {
                    String string = this.resolveWord(mouseEvent.getPoint());
                    this.popup.showPopup(string, mouseEvent);
                } else {
                    Console.this.getPopupMenu((JTextComponent)mouseEvent.getSource()).show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                String string = this.resolveWord(mouseEvent.getPoint());
                Iterator iterator = this.listeners.iterator();
                ActionEvent actionEvent = new ActionEvent(this.parent, 0, string);
                if (!"".equals(string)) {
                    while (iterator.hasNext()) {
                        ActionListener actionListener = (ActionListener)iterator.next();
                        actionListener.actionPerformed(new ActionEvent(this.parent, 0, string));
                    }
                }
            } else {
                this.checkPopup(mouseEvent);
            }
        }

        public String resolveWord(Point point) {
            int n = Console.this.console.viewToModel(point);
            String string = Console.this.console.getText().replace("\n", " ").replaceAll("\\s", " ");
            int n2 = string.lastIndexOf(" ", n);
            int n3 = string.indexOf(" ", n);
            if (n2 == -1) {
                n2 = 0;
            }
            if (n3 == -1) {
                n3 = string.length();
            }
            if (n3 >= n2) {
                String string2 = string.substring(n2, n3).trim();
                return string2;
            }
            return null;
        }
    }

    protected static enum ArrowDirection {
        NONE,
        UP,
        DOWN;

    }
}

