/*
 * Decompiled with CFR 0.152.
 */
package console;

import aggressor.Prefs;
import common.CommonUtils;
import console.Colors;
import console.SearchPanel;
import dialog.DialogUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import ui.CopyPopup;

public class Display
extends JPanel {
    protected JTextPane console;
    protected Properties display;
    protected Font consoleFont;
    protected Colors colors;
    protected LinkedList components = new LinkedList();

    private void B() {
        this.colors = new Colors(this.display);
        Color color = Prefs.getPreferences().getColor("console.foreground.color", "#ffffff");
        Color color2 = Prefs.getPreferences().getColor("console.background.color", "#000000");
        for (JComponent jComponent : this.components) {
            if (jComponent == this.console) {
                jComponent.setOpaque(false);
            }
            jComponent.setBackground(color2);
            jComponent.setForeground(color);
            jComponent.setFont(this.consoleFont);
            if (jComponent == this.console) {
                jComponent.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            } else {
                jComponent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            }
            if (!(jComponent instanceof JTextComponent)) continue;
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            jTextComponent.setCaretColor(color.brighter());
        }
    }

    public void append(final String string) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                Display.this._append(string);
            }
        });
    }

    public void _append(String string) {
        Rectangle rectangle = this.console.getVisibleRect();
        this.colors.append(this.console, string);
        this.console.scrollRectToVisible(rectangle);
    }

    public void setText(final String string) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                Display.this.console.setText(string);
            }
        });
    }

    public void setTextDirect(String string) {
        this.console.setText(string);
    }

    public Display() {
        this(new Properties());
    }

    public Display(Properties properties) {
        this.display = properties;
        this.consoleFont = Prefs.getPreferences().getFont("console.font.font", "Monospaced BOLD 14");
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.console = new JTextPane();
        this.console.setEditable(false);
        this.console.setCaret(new DefaultCaret(){

            @Override
            public void setSelectionVisible(boolean bl) {
                super.setSelectionVisible(true);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.console, 22, 30);
        this.add((Component)jScrollPane, "Center");
        this.components.add(this.console);
        this.components.add(jScrollPane);
        this.components.add(this);
        this.B();
        new CopyPopup(this.console);
        this.addActionForKeySetting("console.clear_screen.shortcut", "ctrl K", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Display.this.console.setText("");
            }
        });
        this.addActionForKeySetting("console.select_all.shortcut", "ctrl A", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Display.this.console.requestFocus();
                Display.this.console.selectAll();
            }
        });
        this.C();
        this.A();
        this.D();
    }

    private void C() {
        Properties properties = this.display;
        final Display display = this;
        this.addActionForKeySetting("console.find.shortcut", "ctrl pressed F", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = Prefs.getPreferences().getColor("console.highlight.color", "#0000cc");
                final SearchPanel searchPanel = new SearchPanel(Display.this.console, color);
                final JPanel jPanel = new JPanel();
                JButton jButton = new JButton("X ");
                DialogUtils.removeBorderFromButton(jButton);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        display.remove(jPanel);
                        display.validate();
                        searchPanel.clear();
                    }
                });
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)searchPanel, "Center");
                jPanel.add((Component)jButton, "East");
                display.add((Component)jPanel, "North");
                display.validate();
                searchPanel.requestFocusInWindow();
                searchPanel.requestFocus();
            }
        });
    }

    private void D() {
        this.addActionForKeySetting("console.font_size_plus.shortcut", "ctrl EQUALS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Display.this.A(1.0f);
            }
        });
        this.addActionForKeySetting("console.font_size_minus.shortcut", "ctrl MINUS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Display.this.A(-1.0f);
            }
        });
        this.addActionForKeySetting("console.font_size_reset.shortcut", "ctrl pressed 0", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Display.this.consoleFont = Prefs.getPreferences().getFont("console.font.font", "Monospaced BOLD 14");
                Display.this.B();
            }
        });
    }

    private void A() {
        this.addActionForKeySetting("console.page_up.shortcut", "pressed PAGE_UP", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rectangle rectangle = new Rectangle(Display.this.console.getVisibleRect());
                Rectangle rectangle2 = new Rectangle(0, (int)(rectangle.getY() - rectangle.getHeight() / 2.0), 1, 1);
                if (rectangle2.getY() <= 0.0) {
                    rectangle.setLocation(0, 0);
                }
                Display.this.console.scrollRectToVisible(rectangle2);
            }
        });
        this.addActionForKeySetting("console.page_down.shortcut", "pressed PAGE_DOWN", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Rectangle rectangle = new Rectangle(Display.this.console.getVisibleRect());
                Rectangle rectangle2 = new Rectangle(0, (int)(rectangle.getY() + rectangle.getHeight() + rectangle.getHeight() / 2.0), 1, 1);
                if (rectangle2.getY() >= (double)Display.this.console.getHeight()) {
                    rectangle.setLocation(0, Display.this.console.getHeight());
                }
                Display.this.console.scrollRectToVisible(rectangle2);
            }
        });
    }

    private void A(float f) {
        this.consoleFont = this.consoleFont.deriveFont(this.consoleFont.getSize2D() + f);
        this.B();
    }

    public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
        this.console.getKeymap().addActionForKeyStroke(keyStroke, action);
    }

    public void addActionForKey(String string, Action action) {
        this.addActionForKeyStroke(KeyStroke.getKeyStroke(string), action);
    }

    public void addActionForKeySetting(String string, String string2, Action action) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(this.display.getProperty(string, string2));
        if (keyStroke != null) {
            this.addActionForKeyStroke(keyStroke, action);
        }
    }

    public void clear() {
        CommonUtils.Guard();
        this.console.setDocument(new DefaultStyledDocument());
    }

    public void swap(StyledDocument styledDocument) {
        CommonUtils.Guard();
        this.console.setDocument(styledDocument);
    }

    public JTextPane getConsole() {
        return this.console;
    }
}

