/*
 * Decompiled with CFR 0.152.
 */
package console;

import dialog.DialogUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class SearchPanel
extends JPanel
implements ActionListener {
    protected JTextField search = null;
    protected JLabel status = null;
    protected JTextComponent component = null;
    protected int index = 0;
    protected Color highlight = null;

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(">")) {
            ++this.index;
            this.B();
        } else if (actionEvent.getActionCommand().equals("<")) {
            --this.index;
            this.B();
        } else {
            this.A();
            this.B();
        }
    }

    private void B() {
        Highlighter.Highlight[] highlightArray = this.component.getHighlighter().getHighlights();
        if (highlightArray.length == 0) {
            if (this.search.getText().trim().length() > 0) {
                this.status.setText("Phrase not found");
            }
            return;
        }
        try {
            if (this.index < 0) {
                this.index = highlightArray.length - 1 - this.index;
            }
            int n = this.index % highlightArray.length;
            this.status.setText(n + 1 + " of " + highlightArray.length);
            int n2 = highlightArray[n].getStartOffset();
            Rectangle rectangle = this.component.modelToView(n2);
            this.component.scrollRectToVisible(rectangle);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void A() {
        this.clear();
        String string = this.search.getText().toLowerCase().trim();
        if (string.length() == 0) {
            return;
        }
        DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(this.highlight);
        try {
            String string2 = this.component.getText().toLowerCase();
            if ((System.getProperty("os.name") + "").indexOf("Windows") != -1) {
                string2 = string2.replaceAll("\r\n", "\n");
            }
            int n = -1;
            while ((n = string2.indexOf(string, n + 1)) != -1) {
                this.component.getHighlighter().addHighlight(n, n + string.length(), defaultHighlightPainter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void requestFocus() {
        this.search.requestFocus();
    }

    public void clear() {
        this.component.getHighlighter().removeAllHighlights();
        this.index = 0;
        this.status.setText("");
    }

    public SearchPanel(JTextComponent jTextComponent, Color color) {
        this.component = jTextComponent;
        this.highlight = color;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        JButton jButton = new JButton("<");
        jButton.setActionCommand("<");
        JButton jButton2 = new JButton(">");
        jButton2.setActionCommand(">");
        DialogUtils.removeBorderFromButton(jButton);
        DialogUtils.removeBorderFromButton(jButton2);
        jButton.addActionListener(this);
        jButton2.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.search = new JTextField(15);
        this.search.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(new JLabel("Find: "));
        jPanel2.add(this.search);
        jPanel2.add(jPanel);
        this.add((Component)jPanel2, "West");
        this.status = new JLabel("");
        this.add((Component)this.status, "Center");
    }
}

