/*
 * Decompiled with CFR 0.152.
 */
package cortana;

import common.AObject;
import common.CommonUtils;
import cortana.ConsoleInterface;
import cortana.CortanaPipe;
import cortana.Loader;
import cortana.SafeEnvironment;
import cortana.SafeFunction;
import cortana.core.EventManager;
import cortana.core.FormatManager;
import cortana.gui.KeyBridge;
import cortana.gui.MenuBuilder;
import cortana.gui.ScriptableApplication;
import cortana.support.CortanaUtilities;
import cortana.support.Heartbeat;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import sleep.bridges.BridgeUtilities;
import sleep.bridges.io.IOObject;
import sleep.error.RuntimeWarningWatcher;
import sleep.error.ScriptWarning;
import sleep.error.YourCodeSucksException;
import sleep.interfaces.Environment;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;

public class Cortana
extends AObject
implements Loadable,
RuntimeWarningWatcher,
Function {
    protected IOObject cortana_io = null;
    protected CortanaPipe pipe = null;
    protected ScriptableApplication application = null;
    protected ConsoleInterface myinterface = null;
    protected EventManager events = new EventManager();
    protected MenuBuilder menus = null;
    protected FormatManager formats = new FormatManager();
    protected Loadable utils = new CortanaUtilities();
    protected Loadable keys = null;
    protected LinkedList bridges = new LinkedList();
    protected boolean active = true;
    protected Map scripts = new HashMap();

    public List getScripts() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : this.scripts.keySet()) {
            if (string == null) continue;
            File file = new File(string);
            linkedList.add(file.getName());
        }
        return linkedList;
    }

    public void register(Loadable loadable) {
        this.bridges.add(loadable);
    }

    public ScriptableApplication getScriptableApplication() {
        return this.application;
    }

    public boolean isActive() {
        return this.active;
    }

    public void go() {
        new Heartbeat(this).start();
    }

    public Cortana(ScriptableApplication scriptableApplication) {
        if (!scriptableApplication.isHeadless()) {
            this.pipe = new CortanaPipe();
            this.cortana_io = new IOObject();
            this.cortana_io.openWrite(this.pipe.getOutput());
        }
        this.application = scriptableApplication;
        this.myinterface = new ConsoleInterface(this);
        this.keys = new KeyBridge(this.application);
        this.menus = new MenuBuilder(this.application);
    }

    public String format(String string, Stack stack) {
        return this.formats.format(string, stack);
    }

    public static void put(ScriptInstance scriptInstance, String string, Function function2) {
        scriptInstance.getScriptEnvironment().getEnvironment().put(string, new SafeFunction(function2));
    }

    public static void putenv(ScriptInstance scriptInstance, String string, Environment environment) {
        scriptInstance.getScriptEnvironment().getEnvironment().put(string, new SafeEnvironment(environment));
    }

    public MenuBuilder getMenuBuilder() {
        return this.menus;
    }

    public EventManager getEventManager() {
        return this.events;
    }

    public void addTextListener(CortanaPipe.CortanaPipeListener cortanaPipeListener) {
        this.pipe.addCortanaPipeListener(cortanaPipeListener);
    }

    public void stop() {
        if (this.pipe != null) {
            this.pipe.close();
        }
        this.active = false;
    }

    public ConsoleInterface getConsoleInterface() {
        return this.myinterface;
    }

    @Override
    public void scriptLoaded(ScriptInstance scriptInstance) {
        if (this.cortana_io != null) {
            IOObject.setConsole(scriptInstance.getScriptEnvironment(), this.cortana_io);
        }
        scriptInstance.getScriptEnvironment().getEnvironment().put("&script_load", this);
        scriptInstance.getScriptEnvironment().getEnvironment().put("&script_unload", this);
    }

    @Override
    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    @Override
    public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
        if (string.equals("&script_load")) {
            try {
                this.loadScript(BridgeUtilities.getString(stack, ""));
            }
            catch (YourCodeSucksException yourCodeSucksException) {
                throw new RuntimeException(yourCodeSucksException.formatErrors());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else if (string.equals("&script_unload")) {
            String string2 = this.findScript(BridgeUtilities.getString(stack, ""));
            if (string2 == null) {
                throw new RuntimeException("Could not find script");
            }
            this.unloadScript(string2);
        }
        return SleepUtils.getEmptyScalar();
    }

    @Override
    public void processScriptWarning(ScriptWarning scriptWarning) {
        String string = scriptWarning.getNameShort() + ":" + scriptWarning.getLineNumber();
        if (scriptWarning.isDebugTrace()) {
            this.pwarn("Trace: " + scriptWarning.getMessage() + " at " + string, true);
        } else {
            this.pwarn(scriptWarning.getMessage() + " at " + string, true);
        }
    }

    public static void filterList(List list, String string) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next() + "";
            if (string2.startsWith(string)) continue;
            iterator.remove();
        }
    }

    public String findScript(String string) {
        Iterator iterator = this.scripts.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            File file = new File(string2);
            if (!string.equals(file.getName())) continue;
            return string2;
        }
        return null;
    }

    public void unloadScript(String string) {
        Loader loader = (Loader)this.scripts.get(string);
        if (loader == null) {
            return;
        }
        this.scripts.remove(string);
        loader.unload();
    }

    public void loadScript(String string) throws YourCodeSucksException, IOException {
        this.loadScript(string, null);
    }

    public void loadScript(String string, InputStream inputStream) throws YourCodeSucksException, IOException {
        Loader loader = new Loader(this);
        if (this.scripts.containsKey(string)) {
            throw new RuntimeException(string + " is already loaded");
        }
        loader.getScriptLoader().addGlobalBridge(this.events.getBridge());
        loader.getScriptLoader().addGlobalBridge(this.formats.getBridge());
        loader.getScriptLoader().addGlobalBridge(this.myinterface.getBridge());
        loader.getScriptLoader().addGlobalBridge(this.utils);
        loader.getScriptLoader().addGlobalBridge(this);
        loader.getScriptLoader().addGlobalBridge(this.keys);
        loader.getScriptLoader().addGlobalBridge(this.menus.getBridge());
        for (Loadable loadable : this.bridges) {
            loader.getScriptLoader().addGlobalBridge(loadable);
        }
        if (inputStream != null) {
            loader.loadScript(string, inputStream);
        } else {
            loader.loadScript(string);
        }
        this.scripts.put(string, loader);
    }

    public void pgood(String string) {
        if (this.application.isHeadless()) {
            CommonUtils.print_good(string);
        } else {
            this.p("\u00039[+]\u000f " + string);
        }
    }

    public void perror(String string) {
        this.perror(string, false);
    }

    public void perror(String string, boolean bl) {
        if (this.application.isHeadless()) {
            CommonUtils.print_error(string);
        } else {
            this.p("\u00034[-]\u000f " + string, bl);
        }
    }

    public void pwarn(String string) {
        this.pwarn(string, false);
    }

    public void pwarn(String string, boolean bl) {
        if (this.application.isHeadless()) {
            CommonUtils.print_warn(string);
        } else {
            this.p("\u00038[!]\u000f " + string, bl);
        }
    }

    public void pinfo(String string) {
        this.pinfo(string, false);
    }

    public void pinfo(String string, boolean bl) {
        if (this.application.isHeadless()) {
            CommonUtils.print_info(string);
        } else {
            this.p("\u0003C[*]\u000f " + string, bl);
        }
    }

    public void pdark(String string) {
        if (this.application.isHeadless()) {
            System.out.println("\u001b[01;30m" + string + "\u001b[0m");
        } else {
            this.p("\u0003E" + string + '\u000f');
        }
    }

    public void p(String string, boolean bl) {
        if (bl) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            String string2 = simpleDateFormat.format(new Date(), new StringBuffer(), new FieldPosition(0)).toString();
            this.p("[" + string2 + "] " + string);
        } else {
            this.p(string);
        }
    }

    public void p(String string) {
        if (this.cortana_io != null) {
            this.cortana_io.printLine(string);
        } else {
            System.out.println(string);
        }
    }
}

