/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.util;

import java.text.NumberFormat;
import java.text.ParseException;

public class JavaVersion {
    private static final int VERSION = JavaVersion.getVersion();
    public static final boolean JAVA5 = VERSION == 5;
    public static final boolean JAVA6 = VERSION == 6;
    public static final boolean JAVA6U10_OR_ABOVE = JavaVersion.isJava6uNOrAbove(10);
    public static final boolean JAVA7 = VERSION == 7;
    public static final boolean JAVA7_OR_ABOVE = VERSION >= 7;
    public static final boolean JAVA7U8_OR_ABOVE = JavaVersion.isJava7uNOrAbove(8);
    public static final boolean JAVA8 = VERSION == 8;
    public static final boolean JAVA8_OR_ABOVE = VERSION >= 8;
    public static final boolean JAVA9 = VERSION == 9;
    public static final boolean JAVA9_OR_ABOVE = VERSION >= 9;
    public static final boolean JAVA11 = VERSION == 11;
    public static final boolean JAVA11_OR_ABOVE = VERSION >= 11;
    public static final boolean JAVA15 = VERSION == 15;
    public static final boolean JAVA15_OR_ABOVE = VERSION >= 15;

    public static int getVersion() {
        String string = System.getProperty("java.version");
        boolean bl = string.startsWith("1.");
        if (bl) {
            string = string.substring(2);
        }
        int n = string.indexOf(46);
        int n2 = string.indexOf(45);
        return Integer.parseInt(string.substring(0, n > -1 ? n : (n2 > -1 ? n2 : (bl ? 1 : string.length()))));
    }

    public static boolean isJava6uNOrAbove(int n) {
        String string = System.getProperty("java.version");
        if (JAVA5) {
            return false;
        }
        if (string.equals("1.6.0")) {
            return false;
        }
        if (string.startsWith("1.6.0_")) {
            try {
                int n2 = ((Long)NumberFormat.getIntegerInstance().parse(string.substring(6))).intValue();
                return n2 >= n;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return true;
    }

    public static boolean isJava7uNOrAbove(int n) {
        String string = System.getProperty("java.version");
        if (JAVA5 || JAVA6) {
            return false;
        }
        if (string.equals("1.7.0")) {
            return false;
        }
        if (string.startsWith("1.7.0_")) {
            try {
                int n2 = ((Long)NumberFormat.getIntegerInstance().parse(string.substring(6))).intValue();
                return n2 >= n;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return true;
    }
}

