/*
 * Decompiled with CFR 0.152.
 */
package dialog;

import aggressor.AggressorClient;
import aggressor.DataManager;
import aggressor.DataUtils;
import aggressor.Prefs;
import aggressor.dialogs.BeaconChooser;
import aggressor.dialogs.CredentialChooser;
import aggressor.dialogs.GuardrailsDialog;
import aggressor.dialogs.InterfaceDialog;
import aggressor.dialogs.MailServerDialog;
import aggressor.dialogs.ProxyServerDialog;
import aggressor.dialogs.ScListenerChooser;
import aggressor.dialogs.SiteChooser;
import aggressor.ui.UseSynthetica;
import common.BeaconEntry;
import common.Callback;
import common.CommonUtils;
import common.Guardrails;
import common.TeamQueue;
import dialog.CheckBoxListItem;
import dialog.DialogListener;
import dialog.DialogUtils;
import dialog.FontDialog;
import dialog.JCheckBoxList;
import dialog.SafeDialogCallback;
import dialog.SafeDialogs;
import dialog.SolidIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import ui.APasswordField;
import ui.ATable;
import ui.ATextField;
import ui.GenericTableModel;
import ui.ListCopyPopup;

public class DialogManager {
    protected HashMap options = new HashMap();
    protected LinkedList listeners = new LinkedList();
    protected LinkedList listeners2 = new LinkedList();
    protected LinkedList rows = new LinkedList();
    protected JFrame dialog = null;
    protected LinkedList group = null;
    protected Map groups = new HashMap();

    public void addDialogListener(DialogListener dialogListener) {
        this.listeners2.add(dialogListener);
    }

    public void addDialogListenerInternal(DialogListener dialogListener) {
        this.listeners.add(dialogListener);
    }

    public LinkedList getRows() {
        return new LinkedList(this.rows);
    }

    public void startGroup(String string) {
        this.group = new LinkedList();
        this.groups.put(string, this.group);
    }

    public void endGroup() {
        this.group = null;
    }

    public DialogManager(JFrame jFrame) {
        this.dialog = jFrame;
    }

    public void set(String string, String string2) {
        this.options.put(string, string2);
    }

    public void set(Map map2) {
        for (Map.Entry entry : map2.entrySet()) {
            this.options.put(entry.getKey() + "", entry.getValue() + "");
        }
    }

    private static void B(final JComponent jComponent, final boolean bl) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                jComponent.setEnabled(bl);
            }
        });
    }

    public JButton action_noclose(final String string) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(final ActionEvent actionEvent) {
                ((JComponent)actionEvent.getSource()).setEnabled(false);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (DialogListener dialogListener : DialogManager.this.listeners) {
                            dialogListener.dialogAction(actionEvent, DialogManager.this.options);
                        }
                        for (DialogListener dialogListener : DialogManager.this.listeners2) {
                            dialogListener.dialogAction(actionEvent, DialogManager.this.options);
                        }
                        DialogManager.B((JComponent)actionEvent.getSource(), true);
                    }
                }, "dialog action: " + string).start();
            }
        });
        return jButton;
    }

    public DialogRow beacon_disabled(String string, String string2, AggressorClient aggressorClient) {
        DialogRow dialogRow = this.beacon(string, string2, aggressorClient);
        dialogRow.get(2).setEnabled(false);
        return dialogRow;
    }

    public DialogRow beacon(final String string, String string2, final AggressorClient aggressorClient) {
        Serializable serializable;
        final DialogRow dialogRow = this.text(string + ".title", string2);
        ((JTextField)dialogRow.c[1]).setEditable(false);
        if (this.options.containsKey(string) && (serializable = DataUtils.getBeacon(aggressorClient.getData(), this.options.get(string) + "")) != null) {
            ((JTextField)dialogRow.c[1]).setText(((BeaconEntry)serializable).getUser() + ((BeaconEntry)serializable).title(" via "));
        }
        serializable = new JButton("...");
        ((AbstractButton)serializable).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new BeaconChooser(aggressorClient, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        DialogManager.this.options.put(string, string);
                        BeaconEntry beaconEntry = DataUtils.getBeacon(aggressorClient.getData(), string);
                        if (beaconEntry != null) {
                            ((JTextField)dialogRow.c[1]).setText(beaconEntry.getUser() + beaconEntry.title(" via "));
                        }
                    }
                }).show();
            }
        });
        dialogRow.c[2] = serializable;
        return dialogRow;
    }

    public DialogRow interfaces(String string, String string2, TeamQueue teamQueue, DataManager dataManager) {
        List list = DataUtils.getInterfaceList(dataManager);
        DialogRow dialogRow = this.combobox(string, string2, CommonUtils.toArray(list));
        JButton jButton = new JButton("Add");
        jButton.addActionListener(new _A((JComboBox)dialogRow.c[1], teamQueue, dataManager));
        dialogRow.last(jButton);
        return dialogRow;
    }

    public DialogRow exploits(String string, String string2, AggressorClient aggressorClient) {
        List list = DataUtils.getBeaconExploits(aggressorClient.getData()).exploits();
        DialogRow dialogRow = this.combobox(string, string2, CommonUtils.toArray(list));
        return dialogRow;
    }

    public DialogRow krbtgt(String string, String string2, final AggressorClient aggressorClient) {
        DialogRow dialogRow = this.text(string, string2);
        final JTextField jTextField = (JTextField)dialogRow.c[1];
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CredentialChooser credentialChooser = new CredentialChooser(aggressorClient, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        String[] stringArray = string.split(" ");
                        jTextField.setText(stringArray[1]);
                    }
                });
                credentialChooser.getFilter().checkLiteral("user", "krbtgt");
                credentialChooser.getFilter().checkNTLMHash("password", false);
                credentialChooser.show();
            }
        });
        dialogRow.c[2] = jButton;
        return dialogRow;
    }

    public DialogRow label(String string) {
        DialogRow dialogRow = new DialogRow(new JPanel(), new JLabel(string), new JPanel());
        this.rows.add(dialogRow);
        if (this.group != null) {
            this.group.add(dialogRow);
        }
        return dialogRow;
    }

    public DialogRow combobox(String string, String string2, Object[] objectArray) {
        return this.combobox(string, string2, objectArray, null);
    }

    public DialogRow combobox(final String string, String string2, Object[] objectArray, ItemListener itemListener) {
        JLabel jLabel = new JLabel(string2);
        final JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setPreferredSize(new Dimension(240, 0));
        if (this.options.containsKey(string)) {
            jComboBox.setSelectedItem(this.options.get(string));
        }
        if (itemListener != null) {
            jComboBox.addItemListener(itemListener);
        }
        this.addDialogListenerInternal(new DialogListener(){

            @Override
            public void dialogAction(ActionEvent actionEvent, Map map2) {
                map2.put(string, jComboBox.getSelectedItem());
            }
        });
        DialogRow dialogRow = new DialogRow(new JLabel(string2), jComboBox, new JPanel());
        this.rows.add(dialogRow);
        if (this.group != null) {
            this.group.add(dialogRow);
        }
        return dialogRow;
    }

    public DialogRow attack(String string, String string2) {
        DialogRow dialogRow = this.text(string, string2);
        JTextField jTextField = (JTextField)dialogRow.c[1];
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        dialogRow.c[2] = jButton;
        return dialogRow;
    }

    public DialogRow site(String string, String string2, final TeamQueue teamQueue, final DataManager dataManager) {
        DialogRow dialogRow = this.text(string, string2);
        final JTextField jTextField = (JTextField)dialogRow.c[1];
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new SiteChooser(teamQueue, dataManager, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        jTextField.setText(string + "?id=%TOKEN%");
                    }
                }).show();
            }
        });
        dialogRow.c[2] = jButton;
        return dialogRow;
    }

    public DialogRow sc_listener_all(String string, String string2, AggressorClient aggressorClient) {
        return this.sc_listener_all(string, string2, aggressorClient, null);
    }

    public DialogRow sc_listener_all(String string, String string2, final AggressorClient aggressorClient, DocumentListener documentListener) {
        DialogRow dialogRow = this.text(string, string2);
        final JTextField jTextField = (JTextField)dialogRow.c[1];
        jTextField.setEditable(false);
        jTextField.getDocument().addDocumentListener(documentListener);
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScListenerChooser.ListenersAll(aggressorClient, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        jTextField.setText(string);
                    }
                }).show();
            }
        });
        dialogRow.c[2] = jButton;
        return dialogRow;
    }

    public DialogRow sc_listener_stagers(String string, String string2, final AggressorClient aggressorClient) {
        DialogRow dialogRow = this.text(string, string2);
        final JTextField jTextField = (JTextField)dialogRow.c[1];
        jTextField.setEditable(false);
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScListenerChooser.ListenersWithStagers(aggressorClient, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        jTextField.setText(string);
                    }
                }).show();
            }
        });
        dialogRow.c[2] = jButton;
        return dialogRow;
    }

    public DialogRow proxyserver(String string, String string2, final AggressorClient aggressorClient) {
        DialogRow dialogRow = this.text(string, string2);
        final JTextField jTextField = (JTextField)dialogRow.c[1];
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new ProxyServerDialog(jTextField.getText(), new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        aggressorClient.getConnection().call("armitage.broadcast", CommonUtils.args("manproxy", string));
                        jTextField.setText(string);
                    }
                }).show();
            }
        });
        dialogRow.c[2] = jButton;
        return dialogRow;
    }

    public DialogRow guardrailsRow(final String string, String string2, String string3, final AggressorClient aggressorClient) {
        DialogRow dialogRow = this.text(string2, string3);
        final JTextField jTextField = (JTextField)dialogRow.get(1);
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string2 = "";
                if (DialogManager.this.options.get(string) != null) {
                    string2 = DialogManager.this.options.get(string).toString();
                }
                new GuardrailsDialog(string2, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        Guardrails guardrails = Guardrails.parseTabDelString(string);
                        jTextField.setText(guardrails.toString());
                        DialogManager.this.options.put(string, guardrails.toTabDelString());
                        aggressorClient.getConnection().call("armitage.broadcast", CommonUtils.args("guardrailsettings", string));
                    }
                }).show();
            }
        });
        dialogRow.c[2] = jButton;
        return dialogRow;
    }

    public DialogRow mailserver(String string, String string2) {
        DialogRow dialogRow = this.text(string, string2);
        final JTextField jTextField = (JTextField)dialogRow.c[1];
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new MailServerDialog(jTextField.getText(), new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        jTextField.setText(string);
                    }
                }).show();
            }
        });
        dialogRow.c[2] = jButton;
        return dialogRow;
    }

    public DialogRow file(String string, String string2) {
        DialogRow dialogRow = this.text(string, string2);
        final JTextField jTextField = (JTextField)dialogRow.c[1];
        JButton jButton = new JButton(DialogUtils.getIcon(UseSynthetica.isUsingDarkMode() != false ? "resources/cc/white/png/document_icon&16.png" : "resources/cc/black/png/document_icon&16.png"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SafeDialogs.openFile("Choose file", null, null, false, false, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        jTextField.setText(string);
                    }
                });
            }
        });
        dialogRow.c[2] = jButton;
        return dialogRow;
    }

    public DialogRow folder(String string, String string2, final String string3) {
        DialogRow dialogRow = this.text(string, string2);
        final JTextField jTextField = (JTextField)dialogRow.c[1];
        jTextField.setText(string3);
        JButton jButton = new JButton(DialogUtils.getIcon(UseSynthetica.isUsingDarkMode() != false ? "resources/cc/white/png/folder_icon&16.png" : "resources/cc/black/png/folder_icon&16.png"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SafeDialogs.openFile("Choose folder", null, string3, false, true, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        jTextField.setText(string);
                    }
                });
            }
        });
        dialogRow.c[2] = jButton;
        return dialogRow;
    }

    public DialogRow font(String string, String string2) {
        DialogRow dialogRow = this.text(string, string2);
        JButton jButton = new JButton("...");
        final JTextField jTextField = (JTextField)dialogRow.c[1];
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontDialog fontDialog = new FontDialog(Font.decode(jTextField.getText()));
                fontDialog.addFontChooseListener(new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        jTextField.setText(string);
                    }
                });
                fontDialog.show();
            }
        });
        dialogRow.c[2] = jButton;
        return dialogRow;
    }

    public DialogRow color(String string, String string2) {
        DialogRow dialogRow = this.text(string, string2);
        final JTextField jTextField = (JTextField)dialogRow.c[1];
        Color color = Color.black;
        if (jTextField.getText() != null && jTextField.getText().length() > 0) {
            color = Color.decode(jTextField.getText());
        }
        final SolidIcon solidIcon = new SolidIcon(color, 16, 16);
        JButton jButton = new JButton(solidIcon);
        final Color color2 = color;
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SafeDialogs.chooseColor("pick a color", color2, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        jTextField.setText(string);
                        solidIcon.setColor(Color.decode(string));
                    }
                });
            }
        });
        dialogRow.c[2] = jButton;
        return dialogRow;
    }

    public DialogRow file_import(final String string, String string2, ATable aTable, final GenericTableModel genericTableModel) {
        DialogRow dialogRow = this.file("_" + string, string2);
        final JTextField jTextField = (JTextField)dialogRow.c[1];
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.A();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.A();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.A();
            }

            public void A() {
                genericTableModel.clear(128);
                File file = new File(jTextField.getText().trim());
                if (file.exists() && file.canRead() && !file.isDirectory()) {
                    String[] stringArray = CommonUtils.bString(CommonUtils.strrep(CommonUtils.readFile(file.getAbsolutePath()), "\r", "")).split("\n");
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (stringArray[i].length() <= 0) continue;
                        String[] stringArray2 = stringArray[i].split("\t");
                        if (stringArray2.length == 1) {
                            genericTableModel.addEntry(CommonUtils.toMap("To", stringArray2[0], "To_Name", ""));
                            continue;
                        }
                        if (stringArray2.length < 2) continue;
                        genericTableModel.addEntry(CommonUtils.toMap("To", stringArray2[0], "To_Name", stringArray2[1]));
                    }
                }
                genericTableModel.fireListeners();
            }
        };
        jTextField.getDocument().addDocumentListener(documentListener);
        this.addDialogListenerInternal(new DialogListener(){

            @Override
            public void dialogAction(ActionEvent actionEvent, Map map2) {
                map2.put(string, genericTableModel.export());
            }
        });
        documentListener.insertUpdate(null);
        return dialogRow;
    }

    public JButton action(String string) {
        JButton jButton = this.action_noclose(string);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!DialogUtils.isShift(actionEvent)) {
                    DialogManager.this.dialog.setVisible(false);
                    DialogManager.this.dialog.dispose();
                }
            }
        });
        return jButton;
    }

    public JButton help(String string) {
        JButton jButton = new JButton("Help");
        jButton.addActionListener(DialogUtils.gotoURL(string));
        return jButton;
    }

    public DialogRow text(String string, String string2) {
        return this.text(string, string2, 20);
    }

    public DialogRow text_disabled(String string, String string2) {
        DialogRow dialogRow = this.text(string, string2, 20);
        dialogRow.get(1).setEnabled(false);
        return dialogRow;
    }

    public DialogRow text(final String string, String string2, int n) {
        final ATextField aTextField = new ATextField(n);
        if (this.options.containsKey(string)) {
            aTextField.setText(this.options.get(string) + "");
        }
        this.addDialogListenerInternal(new DialogListener(){

            @Override
            public void dialogAction(ActionEvent actionEvent, Map map2) {
                if ("".equals(aTextField.getText())) {
                    map2.put(string, "");
                } else {
                    map2.put(string, aTextField.getText());
                }
            }
        });
        DialogRow dialogRow = new DialogRow(new JLabel(string2), aTextField, new JPanel());
        this.rows.add(dialogRow);
        if (this.group != null) {
            this.group.add(dialogRow);
        }
        return dialogRow;
    }

    public DialogRow list_file(String string, String string2) {
        return this.list(string, string2, "file", 64);
    }

    public DialogRow list_text(String string, String string2) {
        return this.list(string, string2, "text", 160);
    }

    public DialogRow list_csv(final String string, String string2, final String string3, final String string4, int n) {
        Object object;
        final JList<String> jList = new JList<String>();
        JScrollPane jScrollPane = new JScrollPane(jList, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(240, n));
        if (this.options.containsKey(string) && !"".equals(object = this.options.get(string) + "")) {
            jList.setListData(CommonUtils.toArray((String)object));
        }
        this.addDialogListenerInternal(new DialogListener(){

            @Override
            public void dialogAction(ActionEvent actionEvent, Map map2) {
                if (jList.getModel().getSize() == 0) {
                    map2.put(string, "");
                } else {
                    LinkedList linkedList = new LinkedList();
                    for (int i = 0; i < jList.getModel().getSize(); ++i) {
                        linkedList.add(jList.getModel().getElementAt(i));
                    }
                    map2.put(string, CommonUtils.join(linkedList, ", "));
                }
            }
        });
        object = new JButton(DialogUtils.getIcon(UseSynthetica.isUsingDarkMode() != false ? "resources/cc/white/png/delete_icon&16.png" : "resources/cc/black/png/delete_icon&16.png"));
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jList.setListData(new String[0]);
                DialogManager.this.options.put(string, "");
            }
        });
        JButton jButton = new JButton(DialogUtils.getIcon(UseSynthetica.isUsingDarkMode() != false ? "resources/cc/white/png/sq_minus_icon&16.png" : "resources/cc/black/png/sq_minus_icon&16.png"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinkedList linkedList = new LinkedList();
                for (int i = 0; i < jList.getModel().getSize(); ++i) {
                    boolean bl = false;
                    for (int j = 0; j < jList.getSelectedIndices().length; ++j) {
                        if (i != jList.getSelectedIndices()[j]) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    linkedList.add(jList.getModel().getElementAt(i));
                }
                jList.setListData(CommonUtils.toArray(linkedList));
                DialogManager.this.options.put(string, CommonUtils.join(linkedList, ", "));
            }
        });
        JButton jButton2 = new JButton(DialogUtils.getIcon(UseSynthetica.isUsingDarkMode() != false ? "resources/cc/white/png/sq_plus_icon&16.png" : "resources/cc/black/png/sq_plus_icon&16.png"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SafeDialogs.ask(string3, string4, new SafeDialogCallback(){

                    @Override
                    public void dialogResult(String string) {
                        LinkedList linkedList = new LinkedList();
                        for (int i = 0; i < jList.getModel().getSize(); ++i) {
                            linkedList.add(jList.getModel().getElementAt(i));
                        }
                        String[] stringArray = CommonUtils.toArray(string);
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (stringArray[i].trim().length() <= 0) continue;
                            linkedList.add(stringArray[i].trim());
                        }
                        jList.setListData(CommonUtils.toArray(linkedList));
                        DialogManager.this.options.put(string, CommonUtils.join(linkedList, ", "));
                    }
                });
            }
        });
        new ListCopyPopup(jList);
        DialogRow dialogRow = new DialogRow(new JLabel(string2), jScrollPane, DialogUtils.stack(jButton2, jButton, (JComponent)object));
        this.rows.add(dialogRow);
        if (this.group != null) {
            this.group.add(dialogRow);
        }
        return dialogRow;
    }

    private Object A(String string, Object object) {
        if ("connection.profiles".equals(string)) {
            String string2 = object.toString();
            int n = string2.indexOf(" (");
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            return string2;
        }
        return object;
    }

    public DialogRow list(final String string, String string2, String string3, int n) {
        Object object;
        Object object2;
        Object object3;
        final JList<String> jList = new JList<String>();
        JScrollPane jScrollPane = new JScrollPane(jList, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(240, n));
        if (this.options.containsKey(string) && !"".equals(object3 = this.options.get(string) + "")) {
            if ("connection.profiles".equals(string)) {
                object2 = ((String)object3).split("!!");
                object = new String[((String[])object2).length];
                int n2 = 0;
                for (String string4 : object2) {
                    String string5 = Prefs.getPreferences().getString("connection.profiles." + string4 + ".alias", "");
                    object[n2] = string4 + " (" + string5 + ")";
                    ++n2;
                }
                jList.setListData((E[])object);
            } else {
                jList.setListData(((String)object3).split("!!"));
            }
        }
        this.addDialogListenerInternal(new DialogListener(){

            @Override
            public void dialogAction(ActionEvent actionEvent, Map map2) {
                if (jList.getModel().getSize() == 0) {
                    map2.put(string, "");
                } else {
                    LinkedList<Object> linkedList = new LinkedList<Object>();
                    for (int i = 0; i < jList.getModel().getSize(); ++i) {
                        linkedList.add(DialogManager.this.A(string, jList.getModel().getElementAt(i)));
                    }
                    map2.put(string, CommonUtils.join(linkedList, "!!"));
                }
            }
        });
        object3 = "file".equals(string3) ? new JButton(DialogUtils.getIcon(UseSynthetica.isUsingDarkMode() != false ? "resources/cc/white/png/doc_minus_icon&16.png" : "resources/cc/black/png/doc_minus_icon&16.png")) : new JButton(DialogUtils.getIcon(UseSynthetica.isUsingDarkMode() != false ? "resources/cc/white/png/sq_minus_icon&16.png" : "resources/cc/black/png/sq_minus_icon&16.png"));
        ((AbstractButton)object3).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinkedList<Object> linkedList = new LinkedList<Object>();
                LinkedList linkedList2 = new LinkedList();
                for (int i = 0; i < jList.getModel().getSize(); ++i) {
                    boolean bl = false;
                    for (int j = 0; j < jList.getSelectedIndices().length; ++j) {
                        if (i != jList.getSelectedIndices()[j]) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    linkedList.add(DialogManager.this.A(string, jList.getModel().getElementAt(i)));
                    linkedList2.add(jList.getModel().getElementAt(i));
                }
                if ("connection.profiles".equals(string)) {
                    jList.setListData(CommonUtils.toArray(linkedList2));
                } else {
                    jList.setListData(CommonUtils.toArray(linkedList));
                }
                DialogManager.this.options.put(string, CommonUtils.join(linkedList, "!!"));
            }
        });
        object2 = null;
        if ("file".equals(string3)) {
            object = new JButton(DialogUtils.getIcon(UseSynthetica.isUsingDarkMode() != false ? "resources/cc/white/png/doc_plus_icon&16.png" : "resources/cc/black/png/doc_plus_icon&16.png"));
            object.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SafeDialogs.openFile("Choose a file", null, null, false, false, new SafeDialogCallback(){

                        @Override
                        public void dialogResult(String string) {
                            LinkedList linkedList = new LinkedList();
                            for (int i = 0; i < jList.getModel().getSize(); ++i) {
                                linkedList.add(jList.getModel().getElementAt(i));
                            }
                            linkedList.add(string);
                            jList.setListData(CommonUtils.toArray(linkedList));
                            DialogManager.this.options.put(string, CommonUtils.join(linkedList, "!!"));
                        }
                    });
                }
            });
            object2 = DialogUtils.stack((JComponent)object, (JComponent)object3);
        } else {
            object2 = DialogUtils.stack((JComponent)object3);
        }
        object = new DialogRow(new JLabel(string2), jScrollPane, (JComponent)object2);
        this.rows.add(object);
        if (this.group != null) {
            this.group.add(object);
        }
        return object;
    }

    public DialogRow stealTokenCheckBoxList(final String string, String string2, final LinkedHashMap<String, Integer> linkedHashMap, int n, int n2) {
        final JCheckBoxList jCheckBoxList = new JCheckBoxList(linkedHashMap, n);
        JScrollPane jScrollPane = new JScrollPane(jCheckBoxList, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(270, n2));
        this.addDialogListenerInternal(new DialogListener(){

            @Override
            public void dialogAction(ActionEvent actionEvent, Map map2) {
                ArrayList<CheckBoxListItem> arrayList = jCheckBoxList.getCheckedItems();
                int n = 0;
                for (CheckBoxListItem checkBoxListItem : arrayList) {
                    if (!linkedHashMap.containsKey(checkBoxListItem.getValue())) continue;
                    Integer n2 = (Integer)linkedHashMap.get(checkBoxListItem.getValue());
                    n |= n2.intValue();
                }
                map2.put(string, n);
            }
        });
        DialogRow dialogRow = new DialogRow(new JLabel(string2), jScrollPane, new JPanel());
        this.rows.add(dialogRow);
        if (this.group != null) {
            this.group.add(dialogRow);
        }
        return dialogRow;
    }

    public DialogRow text_big(String string, String string2) {
        return this.text_big(string, string2, 20);
    }

    public DialogRow text_big(final String string, String string2, int n) {
        final JTextArea jTextArea = new JTextArea();
        jTextArea.setRows(3);
        jTextArea.setColumns(n);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        if (this.options.containsKey(string)) {
            jTextArea.setText(this.options.get(string) + "");
        }
        this.addDialogListenerInternal(new DialogListener(){

            @Override
            public void dialogAction(ActionEvent actionEvent, Map map2) {
                if ("".equals(jTextArea.getText())) {
                    map2.put(string, "");
                } else {
                    map2.put(string, jTextArea.getText());
                }
            }
        });
        DialogRow dialogRow = new DialogRow(new JLabel(string2), new JScrollPane(jTextArea), new JPanel());
        this.rows.add(dialogRow);
        if (this.group != null) {
            this.group.add(dialogRow);
        }
        return dialogRow;
    }

    public DialogRow password(final String string, String string2, int n) {
        final APasswordField aPasswordField = new APasswordField(n);
        if (this.options.containsKey(string)) {
            ((JTextComponent)aPasswordField).setText(this.options.get(string) + "");
        }
        this.addDialogListenerInternal(new DialogListener(){

            @Override
            public void dialogAction(ActionEvent actionEvent, Map map2) {
                if ("".equals(aPasswordField.getText())) {
                    map2.remove(string);
                } else {
                    map2.put(string, aPasswordField.getText());
                }
            }
        });
        DialogRow dialogRow = new DialogRow(new JLabel(string2), aPasswordField, new JPanel());
        this.rows.add(dialogRow);
        if (this.group != null) {
            this.group.add(dialogRow);
        }
        return dialogRow;
    }

    public JComponent layout() {
        return this.layout(this.rows);
    }

    public JComponent layout(String string) {
        LinkedList linkedList = (LinkedList)this.groups.get(string);
        return this.layout(linkedList);
    }

    public JComponent row() {
        if (this.rows.size() != 1) {
            throw new RuntimeException("Can only layout a row with one component!");
        }
        DialogRow dialogRow = (DialogRow)this.rows.get(0);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add((Component)dialogRow.get(0), "West");
        jPanel.add((Component)dialogRow.get(1), "Center");
        jPanel.add((Component)dialogRow.get(2), "East");
        return jPanel;
    }

    public JComponent layout(LinkedList linkedList) {
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout(jPanel);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        jPanel.setLayout(groupLayout);
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        for (int i = 0; i < 3; ++i) {
            GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup();
            for (Object object2 : linkedList) {
                parallelGroup.addComponent(((DialogRow)object2).get(i));
            }
            sequentialGroup.addGroup(parallelGroup);
        }
        groupLayout.setHorizontalGroup(sequentialGroup);
        GroupLayout.SequentialGroup sequentialGroup2 = groupLayout.createSequentialGroup();
        for (Object object : linkedList) {
            Object object2;
            object2 = groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE);
            for (int i = 0; i < 3; ++i) {
                ((GroupLayout.ParallelGroup)object2).addComponent(((DialogRow)object).get(i));
            }
            sequentialGroup2.addGroup((GroupLayout.Group)object2);
        }
        groupLayout.setVerticalGroup(sequentialGroup2);
        return jPanel;
    }

    public DialogRow checkbox_add(String string, String string2, String string3) {
        return this.checkbox_add(string, string2, string3, true);
    }

    public DialogRow checkbox_add(String string, String string2, String string3, boolean bl) {
        JLabel jLabel = new JLabel(string2);
        JCheckBox jCheckBox = this.checkbox(string, string3);
        if (!bl) {
            jLabel.setEnabled(false);
            jCheckBox.setEnabled(false);
        }
        DialogRow dialogRow = new DialogRow(jLabel, jCheckBox, new JPanel());
        this.rows.add(dialogRow);
        if (this.group != null) {
            this.group.add(dialogRow);
        }
        return dialogRow;
    }

    public JCheckBox checkbox(final String string, String string2) {
        final JCheckBox jCheckBox = new JCheckBox(string2);
        if ("true".equals(this.options.get(string))) {
            jCheckBox.setSelected(true);
        } else {
            jCheckBox.setSelected(false);
        }
        this.addDialogListenerInternal(new DialogListener(){

            @Override
            public void dialogAction(ActionEvent actionEvent, Map map2) {
                if (jCheckBox.isSelected()) {
                    map2.put(string, "true");
                } else {
                    map2.put(string, "false");
                }
            }
        });
        return jCheckBox;
    }

    private static class _A
    implements ActionListener,
    Callback {
        protected JComboBox \u0148;
        protected TeamQueue \u0149;
        protected DataManager \u014a;

        public _A(JComboBox jComboBox, TeamQueue teamQueue, DataManager dataManager) {
            this.\u0148 = jComboBox;
            this.\u0149 = teamQueue;
            this.\u014a = dataManager;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InterfaceDialog interfaceDialog = new InterfaceDialog(this.\u0149, this.\u014a);
            interfaceDialog.notify(this);
            interfaceDialog.show();
        }

        @Override
        public void result(String string, final Object object) {
            CommonUtils.runSafe(new Runnable(){

                @Override
                public void run() {
                    _A.this.\u0148.addItem(object + "");
                    _A.this.\u0148.setSelectedItem(object + "");
                }
            });
        }
    }

    public static final class DialogRow {
        public JComponent[] c = new JComponent[3];

        public DialogRow(JComponent jComponent, JComponent jComponent2, JComponent jComponent3) {
            this.c[0] = jComponent;
            this.c[1] = jComponent2;
            this.c[2] = jComponent3;
        }

        public JComponent get(int n) {
            return this.c[n];
        }

        public void last(JComponent jComponent) {
            this.c[2] = jComponent;
        }

        public boolean ContainsCompoment(Component component) {
            if (this.c[0] == component) {
                return true;
            }
            if (this.c[1] == component) {
                return true;
            }
            return this.c[2] == component;
        }

        public Component getCompoment(Class clazz) {
            if (clazz.isInstance(this.c[0])) {
                return this.c[0];
            }
            if (clazz.isInstance(this.c[1])) {
                return this.c[1];
            }
            if (clazz.isInstance(this.c[2])) {
                return this.c[2];
            }
            return null;
        }

        private void A(Component[] componentArray, Boolean bl) {
            if (componentArray == null) {
                return;
            }
            for (Component component : componentArray) {
                if (component == null) continue;
                component.setEnabled(bl);
                if (!(component instanceof Container)) continue;
                this.A(((Container)component).getComponents(), bl);
            }
        }

        public void setEnabled(Boolean bl) {
            if (this.c[0] != null) {
                this.c[0].setEnabled(bl);
                this.A(this.c[0].getComponents(), bl);
            }
            if (this.c[1] != null) {
                this.c[1].setEnabled(bl);
                this.A(this.c[1].getComponents(), bl);
            }
            if (this.c[2] != null) {
                this.c[2].setEnabled(bl);
                this.A(this.c[2].getComponents(), bl);
            }
        }
    }
}

