/*
 * Decompiled with CFR 0.152.
 */
package dialog;

import aggressor.AggressorClient;
import aggressor.DataUtils;
import aggressor.windows.BeaconConsole;
import aggressor.windows.SecureShellConsole;
import common.AssertUtils;
import common.BeaconEntry;
import common.CHECKINSTATE;
import common.CommonHTMLUtils;
import common.CommonUtils;
import common.MudgeSanity;
import common.StringStack;
import common.TabScreenshot;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import sleep.runtime.Scalar;
import table.FilterAndScroll;
import ui.ATable;
import ui.ATextField;
import ui.GenericTableModel;
import ui.Sorters;

public class DialogUtils {
    public static Map icache = new HashMap();

    public static JFrame dialog(String string, int n, int n2) {
        JFrame jFrame = new JFrame(string);
        jFrame.setSize(n, n2);
        jFrame.setLayout(new BorderLayout());
        jFrame.setLocationRelativeTo(null);
        jFrame.setIconImage(DialogUtils.getImage("resources/armitage-icon.gif"));
        jFrame.setDefaultCloseOperation(2);
        return jFrame;
    }

    public static void close(final JFrame jFrame) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(false);
                jFrame.dispose();
            }
        });
    }

    public static void showError(MessageID messageID) {
        switch (messageID) {
            case A_ROW_MUST_BE_SELECTED: {
                DialogUtils.showError("A row must be selected");
                break;
            }
            case ROWS_MUST_BE_SELECTED: {
                DialogUtils.showError("One or more rows must be selected");
                break;
            }
            default: {
                DialogUtils.showError("Undefined error: " + messageID.name());
            }
        }
    }

    public static void showError(final String string) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, string, null, 0);
            }
        });
    }

    public static void showInfo(final String string) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, string, null, 1);
            }
        });
    }

    public static void showInput(final JFrame jFrame, final String string, final String string2) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showInputDialog(jFrame, string, string2);
            }
        });
    }

    public static GenericTableModel setupModel(String string, String[] stringArray, List list) {
        GenericTableModel genericTableModel = new GenericTableModel(stringArray, string, 8);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            genericTableModel._addEntry((Map)iterator.next());
        }
        return genericTableModel;
    }

    public static Map toMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringStack stringStack = new StringStack(string, ",");
        while (!stringStack.isEmpty()) {
            String string2 = stringStack.pop();
            String[] stringArray = string2.split(": ");
            if (stringArray.length != 2) {
                throw new RuntimeException("toMap: '" + string + "' failed at: " + string2);
            }
            hashMap.put(stringArray[0].trim(), stringArray[1].trim());
        }
        return hashMap;
    }

    public static void addToClipboard(String string) {
        DialogUtils.addToClipboardQuiet(string);
        DialogUtils.showInfo("Copied text to clipboard");
    }

    public static void addToClipboardQuiet(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemSelection();
        if (clipboard != null) {
            clipboard.setContents(stringSelection, null);
        }
        if ((clipboard = Toolkit.getDefaultToolkit().getSystemClipboard()) != null) {
            clipboard.setContents(stringSelection, null);
        }
    }

    public static void setTableColumnWidths(JTable jTable, Map map2) {
        for (Map.Entry entry : map2.entrySet()) {
            String string = entry.getKey() + "";
            int n = Integer.parseInt(entry.getValue() + "");
            jTable.getColumn(string).setPreferredWidth(n);
        }
    }

    public static ATable setupTable(TableModel tableModel, String[] stringArray, boolean bl) {
        if (bl) {
            return DialogUtils.setupTable(tableModel, stringArray, 2);
        }
        return DialogUtils.setupTable(tableModel, stringArray, 0);
    }

    public static ATable setupTable(TableModel tableModel, String[] stringArray, int n) {
        ATable aTable = new ATable(tableModel);
        aTable.getSelectionModel().setSelectionMode(n);
        TableRowSorter<TableModel> tableRowSorter = new TableRowSorter<TableModel>(tableModel);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Comparator comparator = Sorters.getProperSorter(string);
            if (comparator == null) continue;
            tableRowSorter.setComparator(i, comparator);
        }
        aTable.setRowSorter(tableRowSorter);
        return aTable;
    }

    public static void sortby(JTable jTable, int n) {
        try {
            LinkedList<RowSorter.SortKey> linkedList = new LinkedList<RowSorter.SortKey>();
            linkedList.add(new RowSorter.SortKey(n, SortOrder.ASCENDING));
            jTable.getRowSorter().setSortKeys(linkedList);
            ((DefaultRowSorter)jTable.getRowSorter()).sort();
        }
        catch (Exception exception) {
            MudgeSanity.logException("sortby: " + n, exception, false);
        }
    }

    public static void sortby(JTable jTable, int n, int n2) {
        try {
            LinkedList<RowSorter.SortKey> linkedList = new LinkedList<RowSorter.SortKey>();
            linkedList.add(new RowSorter.SortKey(n, SortOrder.ASCENDING));
            linkedList.add(new RowSorter.SortKey(n2, SortOrder.ASCENDING));
            jTable.getRowSorter().setSortKeys(linkedList);
            ((DefaultRowSorter)jTable.getRowSorter()).sort();
        }
        catch (Exception exception) {
            MudgeSanity.logException("sortby: " + n + ", " + n2, exception, false);
        }
    }

    public static void startedWebService(String string, String string2) {
        final JFrame jFrame = DialogUtils.dialog("Success", 240, 120);
        jFrame.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel();
        jLabel.putClientProperty("html.disable", Boolean.FALSE);
        jLabel.setText("<html>Started service: " + CommonHTMLUtils.escapeHtml(string) + "<br />Copy and paste this URL to access it</html>");
        ATextField aTextField = new ATextField(string2, 20);
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.setVisible(false);
                jFrame.dispose();
            }
        });
        jFrame.add((Component)DialogUtils.wrapComponent(jLabel, 5), "North");
        jFrame.add((Component)DialogUtils.wrapComponent(aTextField, 5), "Center");
        jFrame.add((Component)DialogUtils.center(jButton), "South");
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void presentURL(String string) {
        final JFrame jFrame = DialogUtils.dialog("Open URL", 240, 120);
        jFrame.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("I couldn't open your browser. Try browsing to:");
        ATextField aTextField = new ATextField(string, 20);
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.setVisible(false);
                jFrame.dispose();
            }
        });
        jFrame.add((Component)DialogUtils.wrapComponent(jLabel, 5), "North");
        jFrame.add((Component)DialogUtils.wrapComponent(aTextField, 5), "Center");
        jFrame.add((Component)DialogUtils.center(jButton), "South");
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void presentText(String string, String string2, String string3) {
        final JFrame jFrame = DialogUtils.dialog(string, 240, 120);
        jFrame.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel();
        jLabel.putClientProperty("html.disable", Boolean.FALSE);
        jLabel.setText("<html>" + string2 + "</html>");
        ATextField aTextField = new ATextField(string3, 20);
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.setVisible(false);
                jFrame.dispose();
            }
        });
        jFrame.add((Component)DialogUtils.wrapComponent(jLabel, 5), "North");
        jFrame.add((Component)DialogUtils.wrapComponent(aTextField, 5), "Center");
        jFrame.add((Component)DialogUtils.center(jButton), "South");
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static JComponent wrapComponent(JComponent jComponent, int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jComponent, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        return jPanel;
    }

    public static JComponent pad(JComponent jComponent, int n, int n2, int n3, int n4) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jComponent, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(n, n2, n3, n4));
        return jPanel;
    }

    private static LinkedList A(Object object) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(object);
        return linkedList;
    }

    private static LinkedList A(Object object, Object object2) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(object);
        linkedList.add(object2);
        return linkedList;
    }

    private static LinkedList A(Object object, Object object2, Object object3) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(object);
        linkedList.add(object2);
        linkedList.add(object3);
        return linkedList;
    }

    private static LinkedList A(Object object, Object object2, Object object3, Object object4) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(object);
        linkedList.add(object2);
        linkedList.add(object3);
        linkedList.add(object4);
        return linkedList;
    }

    private static LinkedList A(Object object, Object object2, Object object3, Object object4, Object object5) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(object);
        linkedList.add(object2);
        linkedList.add(object3);
        linkedList.add(object4);
        linkedList.add(object5);
        return linkedList;
    }

    private static LinkedList A(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(object);
        linkedList.add(object2);
        linkedList.add(object3);
        linkedList.add(object4);
        linkedList.add(object5);
        linkedList.add(object6);
        return linkedList;
    }

    private static LinkedList A(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(object);
        linkedList.add(object2);
        linkedList.add(object3);
        linkedList.add(object4);
        linkedList.add(object5);
        linkedList.add(object6);
        linkedList.add(object7);
        return linkedList;
    }

    private static LinkedList A(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(object);
        linkedList.add(object2);
        linkedList.add(object3);
        linkedList.add(object4);
        linkedList.add(object5);
        linkedList.add(object6);
        linkedList.add(object7);
        linkedList.add(object8);
        return linkedList;
    }

    private static LinkedList A(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(object);
        linkedList.add(object2);
        linkedList.add(object3);
        linkedList.add(object4);
        linkedList.add(object5);
        linkedList.add(object6);
        linkedList.add(object7);
        linkedList.add(object8);
        linkedList.add(object9);
        return linkedList;
    }

    public static JComponent stack(JComponent jComponent) {
        return DialogUtils.stack(DialogUtils.A(jComponent));
    }

    public static JComponent stack(JComponent jComponent, JComponent jComponent2) {
        return DialogUtils.stack(DialogUtils.A(jComponent, jComponent2));
    }

    public static JComponent stack(JComponent jComponent, JComponent jComponent2, JComponent jComponent3) {
        return DialogUtils.stack(DialogUtils.A(jComponent, jComponent2, jComponent3));
    }

    public static JComponent stack(List list) {
        Box box = Box.createVerticalBox();
        for (JComponent jComponent : list) {
            jComponent.setAlignmentX(0.0f);
            box.add(jComponent);
        }
        return box;
    }

    public static JComponent stackTwo(JComponent jComponent, JComponent jComponent2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jComponent, "Center");
        jPanel.add((Component)jComponent2, "South");
        return jPanel;
    }

    public static JComponent stackThree(JComponent jComponent, JComponent jComponent2, JComponent jComponent3) {
        return DialogUtils.stackTwo(jComponent, DialogUtils.stackTwo(jComponent2, jComponent3));
    }

    public static JComponent center(JComponent jComponent) {
        return DialogUtils.center(DialogUtils.A(jComponent));
    }

    public static JComponent center(JComponent jComponent, JComponent jComponent2) {
        return DialogUtils.center(DialogUtils.A(jComponent, jComponent2));
    }

    public static JComponent center(JComponent jComponent, JComponent jComponent2, JComponent jComponent3) {
        return DialogUtils.center(DialogUtils.A(jComponent, jComponent2, jComponent3));
    }

    public static JComponent center(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, JComponent jComponent4) {
        return DialogUtils.center(DialogUtils.A(jComponent, jComponent2, jComponent3, jComponent4));
    }

    public static JComponent center(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, JComponent jComponent4, JComponent jComponent5) {
        return DialogUtils.center(DialogUtils.A(jComponent, jComponent2, jComponent3, jComponent4, jComponent5));
    }

    public static JComponent center(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, JComponent jComponent4, JComponent jComponent5, JComponent jComponent6) {
        return DialogUtils.center(DialogUtils.A(jComponent, jComponent2, jComponent3, jComponent4, jComponent5, jComponent6));
    }

    public static JComponent center(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, JComponent jComponent4, JComponent jComponent5, JComponent jComponent6, JComponent jComponent7) {
        return DialogUtils.center(DialogUtils.A(jComponent, jComponent2, jComponent3, jComponent4, jComponent5, jComponent6, jComponent7));
    }

    public static JComponent center(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, JComponent jComponent4, JComponent jComponent5, JComponent jComponent6, JComponent jComponent7, JComponent jComponent8) {
        return DialogUtils.center(DialogUtils.A(jComponent, jComponent2, jComponent3, jComponent4, jComponent5, jComponent6, jComponent7, jComponent8));
    }

    public static JComponent center(JComponent jComponent, JComponent jComponent2, JComponent jComponent3, JComponent jComponent4, JComponent jComponent5, JComponent jComponent6, JComponent jComponent7, JComponent jComponent8, JComponent jComponent9) {
        return DialogUtils.center(DialogUtils.A(jComponent, jComponent2, jComponent3, jComponent4, jComponent5, jComponent6, jComponent7, jComponent8, jComponent9));
    }

    public static JComponent center(List list) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        for (JComponent jComponent : list) {
            jPanel.add(jComponent);
        }
        return jPanel;
    }

    public static Dimension getDescription3LineDimension() {
        return new Dimension(0, 72);
    }

    public static Dimension getDescription2LineDimension() {
        return new Dimension(0, 48);
    }

    public static JComponent description(String string) {
        return DialogUtils.A(string, false, null);
    }

    public static JComponent description(String string, Dimension dimension) {
        return DialogUtils.A(string, false, dimension);
    }

    public static JComponent descriptionHTML(String string) {
        return DialogUtils.A(string, true, null);
    }

    private static JComponent A(String string, boolean bl, Dimension dimension) {
        JEditorPane jEditorPane = new JEditorPane();
        if (bl) {
            jEditorPane.setContentType("text/html");
        } else {
            jEditorPane.setContentType("text/plain");
        }
        jEditorPane.setText(string.trim());
        jEditorPane.setEditable(false);
        jEditorPane.setOpaque(true);
        jEditorPane.setCaretPosition(0);
        jEditorPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        if (dimension != null) {
            jScrollPane.setPreferredSize(dimension);
        } else {
            jScrollPane.setPreferredSize(DialogUtils.getDescription2LineDimension());
        }
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return jScrollPane;
    }

    public static ActionListener gotoURL(final String string) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Desktop.isDesktopSupported()) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Desktop.getDesktop().browse(new URL(string).toURI());
                            }
                            catch (Exception exception) {
                                MudgeSanity.logException("goto: " + string + " *grumble* *grumble*", exception, true);
                                DialogUtils.presentURL(string);
                            }
                        }
                    }, "show URL").start();
                } else {
                    CommonUtils.print_error("No desktop support to show: " + string);
                }
            }
        };
    }

    public static boolean isShift(ActionEvent actionEvent) {
        return (actionEvent.getModifiers() & 1) == 1;
    }

    public static void setupLastRenderer(JTable jTable, GenericTableModel genericTableModel, String string) {
        jTable.getColumn(string).setCellRenderer(ATable.getLastTableRenderer(genericTableModel));
    }

    public static void setupSleepRenderer(JTable jTable, String string) {
        jTable.getColumn(string).setCellRenderer(ATable.getTimeSleepRenderer());
    }

    public static void setupUserRenderer(JTable jTable, GenericTableModel genericTableModel, String string) {
        jTable.getColumn(string).setCellRenderer(ATable.getUserRenderer(genericTableModel));
    }

    public static void setupDateRenderer(JTable jTable, String string) {
        jTable.getColumn(string).setCellRenderer(ATable.getDateTableRenderer());
    }

    public static void setupSizeRenderer(JTable jTable, String string) {
        jTable.getColumn(string).setCellRenderer(ATable.getSizeTableRenderer());
    }

    public static void setupImageRenderer(JTable jTable, GenericTableModel genericTableModel, String string, String string2) {
        jTable.getColumn(string).setCellRenderer(ATable.getImageTableRenderer(genericTableModel, string2));
    }

    public static void setupImageAndTextRenderer(JTable jTable, GenericTableModel genericTableModel, String string, String string2) {
        jTable.getColumn(string).setCellRenderer(ATable.getImageAndTextTableRenderer(genericTableModel, string2));
    }

    public static void setupBoldOnKeyRenderer(JTable jTable, GenericTableModel genericTableModel, String string, String string2) {
        jTable.getColumn(string).setCellRenderer(ATable.getBoldOnKeyRenderer(genericTableModel, string2));
    }

    public static void setupListenerStatusRenderer(JTable jTable, GenericTableModel genericTableModel, String string) {
        jTable.getColumn(string).setCellRenderer(ATable.getListenerStatusRenderer(genericTableModel));
    }

    public static void setupClientStatusRenderer(JTable jTable, GenericTableModel genericTableModel, String string) {
        jTable.getColumn(string).setCellRenderer(ATable.getClientStatusRenderer(genericTableModel));
    }

    public static boolean bool(Map map2, String string) {
        String string2 = map2.get(string) + "";
        return string2.equals("true");
    }

    public static String string(Map map2, String string) {
        return DialogUtils.string(map2, string, "");
    }

    public static String string(Map map2, String string, String string2) {
        Object v = map2.get(string);
        if (v == null) {
            return string2;
        }
        return v.toString();
    }

    public static boolean isNumber(Map map2, String string) {
        try {
            DialogUtils.number(map2, string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int number(Map map2, String string) {
        return Integer.parseInt(DialogUtils.string(map2, string));
    }

    public static void workAroundEditorBug(JEditorPane jEditorPane) {
        jEditorPane.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
    }

    public static JComponent top(JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jComponent, "North");
        jPanel.add(Box.createVerticalGlue(), "Center");
        return jPanel;
    }

    public static String encodeColor(Color color) {
        String string = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        while (string.length() < 6) {
            string = "0" + string;
        }
        return "#" + string;
    }

    public static JButton Button(String string, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static Icon getIcon(String string) {
        try {
            return new ImageIcon(ImageIO.read(CommonUtils.resource(string)));
        }
        catch (IOException iOException) {
            MudgeSanity.logException("getIcon: " + string, iOException, false);
            return null;
        }
    }

    public static Image getImage(String string) {
        try {
            return ImageIO.read(CommonUtils.resource(string));
        }
        catch (IOException iOException) {
            MudgeSanity.logException("getImage: " + string, iOException, false);
            return null;
        }
    }

    public static Image getImage(String[] stringArray) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsConfiguration graphicsConfiguration = graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(1000, 776, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                BufferedImage bufferedImage2 = ImageIO.read(CommonUtils.resource(stringArray[i]));
                graphics2D.drawImage(bufferedImage2, 0, 0, 1000, 776, null);
                continue;
            }
            catch (Exception exception) {
                MudgeSanity.logException("getImage: " + stringArray[i], exception, false);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public static byte[] toImage(RenderedImage renderedImage, String string) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(524288);
            ImageIO.write(renderedImage, string, byteArrayOutputStream);
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            MudgeSanity.logException("toImage: " + string, exception, false);
            return new byte[0];
        }
    }

    public static Image getImageSmall(String[] stringArray) {
        BufferedImage bufferedImage = new BufferedImage(1000, 776, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                BufferedImage bufferedImage2 = ImageIO.read(CommonUtils.resource(stringArray[i]));
                graphics2D.drawImage(bufferedImage2, 0, 0, 1000, 776, null);
                continue;
            }
            catch (Exception exception) {
                MudgeSanity.logException("getImageSmall: " + stringArray[i], exception, false);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage resize(Image image, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Image image2 = image.getScaledInstance(n, n2, 4);
        graphics2D.drawImage(image2, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static void addToTable(final ATable aTable, final GenericTableModel genericTableModel, final Map map2) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                aTable.markSelections();
                genericTableModel.addEntry(map2);
                genericTableModel.fireListeners();
                aTable.restoreSelections();
            }
        });
    }

    public static void removeFromTable(final ATable aTable, final GenericTableModel genericTableModel, String string, final String string2) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                aTable.markSelections();
                genericTableModel.removeRowWithValueAtColumn("lpath", string2);
                genericTableModel.fireListeners();
                aTable.restoreSelections();
            }
        });
    }

    public static void setText(final ATextField aTextField, final String string) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                aTextField.setText(string);
            }
        });
    }

    public static void setTable(final ATable aTable, final GenericTableModel genericTableModel, Collection collection) {
        if (!AssertUtils.TestNotNull(aTable, "table")) {
            return;
        }
        final LinkedList linkedList = new LinkedList(collection);
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                aTable.markSelections();
                genericTableModel.clear(linkedList.size());
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    genericTableModel.addEntry((Map)iterator.next());
                }
                genericTableModel.fireListeners();
                aTable.restoreSelections();
            }
        });
    }

    public static String[] TargetVisualizationArray(String string, double d, boolean bl, CHECKINSTATE cHECKINSTATE, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl2) {
            switch (cHECKINSTATE) {
                case GOOD: {
                    arrayList.add("resources/beacon-25-icon.png");
                }
            }
        }
        if (bl) {
            switch (cHECKINSTATE) {
                case GOOD: {
                    arrayList.add("resources/yellow-lightning-icon.png");
                    break;
                }
                default: {
                    arrayList.add("resources/gray-lightning-icon.png");
                }
            }
        }
        if (string.equals("windows")) {
            arrayList.add("resources/windows-logo-icon.png");
        } else {
            if (string.equals("firewall")) {
                return CommonUtils.toArray("resources/firewall-icon.png");
            }
            if (string.equals("printer")) {
                return CommonUtils.toArray("resources/printer-icon.png");
            }
            if (string.equals("android")) {
                arrayList.add("resources/android-logo-icon.png");
            } else if (string.equals("vmware")) {
                arrayList.add("resources/vmware-logo-icon.png");
            } else if (string.equals("solaris")) {
                arrayList.add("resources/solaris-logo-icon.png");
            } else if (string.equals("freebsd") || string.equals("openbsd") || string.equals("netbsd")) {
                arrayList.add("resources/bsd-logo-icon.png");
            } else if (string.equals("linux")) {
                arrayList.add("resources/linux-logo-icon.png");
            } else if (string.equals("cisco ios")) {
                arrayList.add("resources/cisco-logo-icon.png");
            } else if (string.equals("macos x")) {
                arrayList.add("resources/apple-logo-icon.png");
            } else if (string.equals("apple ios")) {
                arrayList.add("resources/ios-logo-icon.png");
            } else {
                arrayList.add("resources/unknown-logo-icon.png");
            }
        }
        switch (cHECKINSTATE) {
            case GOOD: {
                if (bl) {
                    arrayList.add("resources/red-screen-icon.png");
                    break;
                }
                arrayList.add("resources/blue-screen-icon.png");
                break;
            }
            default: {
                arrayList.add("resources/gray-screen-icon.png");
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon TargetVisualizationSmall(String string, double d, boolean bl, CHECKINSTATE cHECKINSTATE) {
        String string2 = "small:" + string.toLowerCase() + "." + d + "." + bl + "." + (Object)((Object)cHECKINSTATE);
        Map map2 = icache;
        synchronized (map2) {
            if (icache.containsKey(string2)) {
                return (ImageIcon)icache.get(string2);
            }
            Image image = DialogUtils.getImage(DialogUtils.TargetVisualizationArray(string.toLowerCase(), d, bl, cHECKINSTATE, false));
            ImageIcon imageIcon = new ImageIcon(image.getScaledInstance((int)Math.floor((double)image.getWidth(null) / 44.0), (int)Math.floor((double)image.getHeight(null) / 44.0), 4));
            icache.put(string2, imageIcon);
            return imageIcon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image TargetVisualizationMedium(String string, double d, boolean bl, CHECKINSTATE cHECKINSTATE) {
        String string2 = "medium:" + string.toLowerCase() + "." + d + "." + bl + "." + (Object)((Object)cHECKINSTATE);
        Map map2 = icache;
        synchronized (map2) {
            if (icache.containsKey(string2)) {
                return (Image)icache.get(string2);
            }
            Image image = DialogUtils.getImageSmall(DialogUtils.TargetVisualizationArray(string.toLowerCase(), d, bl, cHECKINSTATE, false));
            BufferedImage bufferedImage = DialogUtils.resize(image, 125, 97);
            icache.put(string2, bufferedImage);
            return bufferedImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image TargetVisualization(String string, double d, boolean bl, CHECKINSTATE cHECKINSTATE, boolean bl2) {
        String string2 = string.toLowerCase() + "." + d + "." + bl + "." + (Object)((Object)cHECKINSTATE);
        Map map2 = icache;
        synchronized (map2) {
            if (icache.containsKey(string2)) {
                return (Image)icache.get(string2);
            }
            Image image = DialogUtils.getImage(DialogUtils.TargetVisualizationArray(string.toLowerCase(), d, bl, cHECKINSTATE, bl2));
            icache.put(string2, image);
            return image;
        }
    }

    public static void openOrActivate(final AggressorClient aggressorClient, final String string) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                BeaconEntry beaconEntry = DataUtils.getBeacon(aggressorClient.getData(), string);
                if (!aggressorClient.getTabManager().activateConsole(string)) {
                    if (beaconEntry.isBeacon()) {
                        BeaconConsole beaconConsole = new BeaconConsole(string, aggressorClient);
                        aggressorClient.getTabManager().addTab(beaconEntry.title(), beaconConsole.getConsole(), beaconConsole.cleanup(), "Beacon console");
                    } else if (beaconEntry.isSSH()) {
                        SecureShellConsole secureShellConsole = new SecureShellConsole(string, aggressorClient);
                        aggressorClient.getTabManager().addTab(beaconEntry.title(), secureShellConsole.getConsole(), secureShellConsole.cleanup(), "SSH console");
                    }
                }
            }
        });
    }

    public static void setupScreenshotShortcut(final AggressorClient aggressorClient, final ATable aTable, final String string) {
        aTable.addActionForKey("ctrl pressed P", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BufferedImage bufferedImage = aTable.getScreenshot();
                byte[] byArray = DialogUtils.toImage(bufferedImage, "png");
                aggressorClient.getConnection().call("aggressor.screenshot", CommonUtils.args(new TabScreenshot(string, byArray)));
                DialogUtils.showInfo("Pushed screenshot to team server");
            }
        });
    }

    public static byte[] screenshot(Component component) {
        BufferedImage bufferedImage = new BufferedImage(component.getWidth(), component.getHeight(), 6);
        Graphics graphics = bufferedImage.getGraphics();
        component.paint(graphics);
        graphics.dispose();
        byte[] byArray = DialogUtils.toImage(bufferedImage, "png");
        return byArray;
    }

    public static void removeBorderFromButton(JButton jButton) {
        jButton.setOpaque(false);
        jButton.setContentAreaFilled(false);
        jButton.setBorder(new EmptyBorder(2, 2, 2, 2));
    }

    public static JPanel FilterAndScroll(ATable aTable) {
        return new FilterAndScroll(aTable);
    }

    public static void showSessionPopup(AggressorClient aggressorClient, MouseEvent mouseEvent, Object[] objectArray) {
        if (objectArray.length == 0) {
            return;
        }
        String string = objectArray[0].toString();
        String string2 = "";
        string2 = "beacon".equals(CommonUtils.session(string)) ? "beacon" : "ssh";
        Stack<Scalar> stack = new Stack<Scalar>();
        stack.push(CommonUtils.toSleepArray(objectArray));
        aggressorClient.getScriptEngine().getMenuBuilder().installMenu(mouseEvent, string2, stack);
    }

    public static enum MessageID {
        A_ROW_MUST_BE_SELECTED,
        ROWS_MUST_BE_SELECTED;

    }
}

