/*
 * Decompiled with CFR 0.152.
 */
package dialog;

import common.CommonUtils;
import dialog.DialogUtils;
import dialog.SafeDialogCallback;
import dialog.SafeDialogsFileFilter;
import encoders.Base64;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class SafeDialogs {
    protected static File lastSaveDirectory = null;
    protected static File lastOpenDirectory = null;

    public static void askYesNo(final String string, final String string2, final SafeDialogCallback safeDialogCallback) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                int n = JOptionPane.showConfirmDialog(null, string, string2, 0);
                if (n == 0 || n == 0) {
                    SafeDialogs.A(safeDialogCallback, "yes");
                }
            }
        });
    }

    public static void askYesNoBoth(final String string, final String string2, final SafeDialogCallback safeDialogCallback) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                int n = JOptionPane.showConfirmDialog(null, string, string2, 0);
                if (n == 0 || n == 0) {
                    SafeDialogs.A(safeDialogCallback, "yes");
                } else {
                    SafeDialogs.A(safeDialogCallback, "no");
                }
            }
        });
    }

    private static void A(final SafeDialogCallback safeDialogCallback, final String string) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                safeDialogCallback.dialogResult(string);
            }
        }, "dialog result thread").start();
    }

    public static void ask(final String string, final String string2, final SafeDialogCallback safeDialogCallback) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                String string3 = JOptionPane.showInputDialog(string, (Object)string2);
                if (string3 != null) {
                    SafeDialogs.A(safeDialogCallback, string3);
                }
            }
        });
    }

    public static void saveFile(JFrame jFrame, String string, SafeDialogCallback safeDialogCallback) {
        SafeDialogs.saveFile(jFrame, string, null, safeDialogCallback);
    }

    public static void saveFile(final JFrame jFrame, final String string, final FileFilter[] fileFilterArray, final SafeDialogCallback safeDialogCallback) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                File file;
                JFileChooser jFileChooser = new JFileChooser();
                if (string != null) {
                    jFileChooser.setSelectedFile(new File(string));
                }
                if (lastSaveDirectory != null) {
                    jFileChooser.setCurrentDirectory(lastSaveDirectory);
                }
                if (fileFilterArray != null) {
                    boolean bl = true;
                    for (FileFilter fileFilter : fileFilterArray) {
                        jFileChooser.addChoosableFileFilter(fileFilter);
                        if (!bl) continue;
                        jFileChooser.setFileFilter(fileFilter);
                        jFileChooser.setAcceptAllFileFilterUsed(false);
                        bl = false;
                    }
                }
                jFileChooser.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        try {
                            SafeDialogsFileFilter safeDialogsFileFilter;
                            JFileChooser jFileChooser;
                            FileFilter fileFilter;
                            if ("fileFilterChanged".equalsIgnoreCase(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() instanceof JFileChooser && (fileFilter = (jFileChooser = (JFileChooser)propertyChangeEvent.getSource()).getFileFilter()) != null && fileFilter instanceof SafeDialogsFileFilter && (safeDialogsFileFilter = (SafeDialogsFileFilter)fileFilter).getDefaultFileName() != null) {
                                jFileChooser.setSelectedFile(new File(safeDialogsFileFilter.getDefaultFileName()));
                            }
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                });
                if (jFileChooser.showSaveDialog(jFrame) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    lastSaveDirectory = file.isDirectory() ? file : file.getParentFile();
                    FileFilter fileFilter = jFileChooser.getFileFilter();
                    if (fileFilter != null && fileFilter instanceof SafeDialogsFileFilter) {
                        SafeDialogsFileFilter safeDialogsFileFilter = (SafeDialogsFileFilter)fileFilter;
                        file = safeDialogsFileFilter.correctExtension(file);
                    }
                    SafeDialogs.A(safeDialogCallback, file + "");
                    return;
                }
            }
        });
    }

    public static void chooseColor(final String string, final Color color, final SafeDialogCallback safeDialogCallback) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                Color color2 = JColorChooser.showDialog(null, string, color);
                if (color2 != null) {
                    SafeDialogs.A(safeDialogCallback, DialogUtils.encodeColor(color2));
                }
            }
        });
    }

    public static void openFile(String string, String string2, String string3, boolean bl, boolean bl2, SafeDialogCallback safeDialogCallback) {
        SafeDialogs.openFile(string, string2, string3, bl, bl2, null, safeDialogCallback);
    }

    public static void openFile(final String string, final String string2, final String string3, final boolean bl, final boolean bl2, final FileFilter[] fileFilterArray, final SafeDialogCallback safeDialogCallback) {
        CommonUtils.runSafe(new Runnable(){

            @Override
            public void run() {
                JFileChooser jFileChooser = new JFileChooser();
                if (string != null) {
                    jFileChooser.setDialogTitle(string);
                }
                if (string2 != null) {
                    jFileChooser.setSelectedFile(new File(string2));
                }
                if (string3 != null) {
                    jFileChooser.setCurrentDirectory(new File(string3));
                } else if (lastOpenDirectory != null) {
                    jFileChooser.setCurrentDirectory(lastOpenDirectory);
                }
                jFileChooser.setMultiSelectionEnabled(bl);
                if (bl2) {
                    jFileChooser.setFileSelectionMode(1);
                }
                if (fileFilterArray != null) {
                    boolean bl3 = true;
                    for (FileFilter fileFilter : fileFilterArray) {
                        jFileChooser.addChoosableFileFilter(fileFilter);
                        if (!bl3) continue;
                        jFileChooser.setFileFilter(fileFilter);
                        jFileChooser.setAcceptAllFileFilterUsed(false);
                        bl3 = false;
                    }
                }
                if (jFileChooser.showOpenDialog(null) != 0) {
                    return;
                }
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Object[] objectArray = jFileChooser.getSelectedFiles();
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray[i] == null || !((File)objectArray[i]).exists()) continue;
                        stringBuffer.append(objectArray[i]);
                        if (i + 1 >= objectArray.length) continue;
                        stringBuffer.append(",");
                    }
                    SafeDialogs.A(safeDialogCallback, stringBuffer.toString());
                } else {
                    if (jFileChooser.getSelectedFile() != null && jFileChooser.getSelectedFile().exists()) {
                        lastOpenDirectory = jFileChooser.getSelectedFile().isDirectory() ? jFileChooser.getSelectedFile() : jFileChooser.getSelectedFile().getParentFile();
                    }
                    SafeDialogs.A(safeDialogCallback, jFileChooser.getSelectedFile() + "");
                }
            }
        });
    }

    public static final class SafetyCheck {
        public static final boolean isModeEnabled() {
            return false;
        }

        public static final boolean checkSafety(Class clazz) {
            if (!SafetyCheck.A(clazz)) {
                System.exit(1);
            }
            return true;
        }

        private static final boolean A(Method method, Class clazz, boolean bl, String string, long l) {
            Object var6_5 = null;
            try {
                return (Boolean)method.invoke(var6_5, clazz, SafetyCheck.A(string), bl, l);
            }
            catch (Throwable throwable) {
                System.exit(1);
                return false;
            }
        }

        private static final String A(String string, String string2) {
            return new String(Base64.decode(string));
        }

        private static final Class A(String string) {
            try {
                return Class.forName(SafetyCheck.A(string, ""));
            }
            catch (Throwable throwable) {
                System.exit(1);
                return null;
            }
        }

        private static final boolean A(Class clazz) {
            boolean bl = true;
            Method method = null;
            String string = "Y29tbW9uLkNvbW1vblV0aWxz";
            String string2 = "amF2YS5sYW5nLkNsYXNz";
            String string3 = "dmFsaWRDbGFzc0ludGVncml0eQ==";
            Class<?> clazz2 = null;
            try {
                clazz2 = Class.forName(SafetyCheck.A(string, ""));
                Class<?> clazz3 = Class.forName(SafetyCheck.A(string2, ""));
                method = clazz2.getDeclaredMethod(SafetyCheck.A(string3, ""), clazz3, clazz3, Boolean.TYPE, Long.TYPE);
            }
            catch (Throwable throwable) {
                System.exit(1);
            }
            bl = bl && SafetyCheck.A(method, clazz, false, "YWdncmVzc29yLnVpLlVzZUxvb2tBbmRGZWVsJExvb2tBbmRGZWVsTWFuYWdlcg==", 684737157L);
            long l = 942042510L;
            String string4 = "YWdncmVzc29yLk11bHRpRnJhbWU=";
            bl = bl && !SafetyCheck.A(method, clazz, false, string4, l + 1L);
            bl = bl && SafetyCheck.A(method, clazz, false, string4, l);
            bl = bl && SafetyCheck.A(method, clazz, false, "ZGlhbG9nLkFjdGl2aXR5UGFuZWw=", 3600095813L);
            return bl;
        }
    }
}

