/*
 * Decompiled with CFR 0.152.
 */
package dns;

import common.CommonUtils;
import common.MudgeSanity;
import dns.QuickSecurity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class BaseSecurity {
    public static final short CRYPTO_LICENSED_PRODUCT = 0;
    public static final short CRYPTO_TRIAL_PRODUCT = 1;
    protected IvParameterSpec ivspec;
    protected Cipher in;
    protected Cipher out;
    protected Mac mac;
    private static Map A = new HashMap();

    protected SecretKey getKey(String string) {
        _A _A2 = this.getSession(string);
        if (_A2 != null) {
            return _A2.C;
        }
        return null;
    }

    protected SecretKey getHashKey(String string) {
        _A _A2 = this.getSession(string);
        if (_A2 != null) {
            return _A2.B;
        }
        return null;
    }

    public boolean isReady(String string) {
        return this.getSession(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected _A getSession(String string) {
        BaseSecurity baseSecurity = this;
        synchronized (baseSecurity) {
            return (_A)A.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerKey(String string, byte[] byArray) {
        Object object = this;
        synchronized (object) {
            if (A.containsKey(string)) {
                return;
            }
        }
        try {
            object = MessageDigest.getInstance("SHA-256");
            byte[] byArray2 = ((MessageDigest)object).digest(byArray);
            byte[] byArray3 = Arrays.copyOfRange(byArray2, 0, 16);
            byte[] byArray4 = Arrays.copyOfRange(byArray2, 16, 32);
            _A _A2 = new _A();
            _A2.C = new SecretKeySpec(byArray3, "AES");
            _A2.B = new SecretKeySpec(byArray4, "HmacSHA256");
            BaseSecurity baseSecurity = this;
            synchronized (baseSecurity) {
                A.put(string, _A2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public BaseSecurity() {
        try {
            byte[] byArray = "abcdefghijklmnop".getBytes();
            this.ivspec = new IvParameterSpec(byArray);
            this.in = Cipher.getInstance("AES/CBC/NoPadding");
            this.out = Cipher.getInstance("AES/CBC/NoPadding");
            this.mac = Mac.getInstance("HmacSHA256");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void pad(ByteArrayOutputStream byteArrayOutputStream) {
        for (int i = byteArrayOutputStream.size() % 16; i < 16; ++i) {
            byteArrayOutputStream.write(65);
        }
    }

    public void debugFrame(String string, byte[] byArray) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("== " + string + " ==\n");
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n = dataInputStream.readInt();
            stringBuffer.append("\tReplay Counter: " + n + "\n");
            int n2 = dataInputStream.readInt();
            stringBuffer.append("\tMessage Length: " + n2 + "\n");
            byte[] byArray2 = new byte[n2];
            dataInputStream.readFully(byArray2, 0, n2);
            stringBuffer.append("\tPlain Text:     " + CommonUtils.toHexString(byArray2) + "\n");
            CommonUtils.print_good(stringBuffer.toString());
        }
        catch (Exception exception) {
            MudgeSanity.logException("foo", exception, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(String string, byte[] byArray) {
        try {
            if (!this.isReady(string)) {
                CommonUtils.print_error("encrypt: No session for '" + string + "'");
                return new byte[0];
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length + 1024);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            SecretKey secretKey = this.getKey(string);
            SecretKey secretKey2 = this.getHashKey(string);
            byteArrayOutputStream.reset();
            dataOutputStream.writeInt((int)(System.currentTimeMillis() / 1000L));
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray, 0, byArray.length);
            this.pad(byteArrayOutputStream);
            byte[] byArray2 = null;
            Object object = this.in;
            synchronized (object) {
                byArray2 = this.do_encrypt(secretKey, byteArrayOutputStream.toByteArray());
            }
            object = null;
            Object object2 = this.mac;
            synchronized (object2) {
                this.mac.init(secretKey2);
                object = this.mac.doFinal(byArray2);
            }
            object2 = new ByteArrayOutputStream();
            ((OutputStream)object2).write(byArray2);
            ((ByteArrayOutputStream)object2).write((byte[])object, 0, 16);
            byte[] byArray3 = ((ByteArrayOutputStream)object2).toByteArray();
            return byArray3;
        }
        catch (InvalidKeyException invalidKeyException) {
            MudgeSanity.logException("encrypt failure for: " + string, invalidKeyException, false);
            CommonUtils.print_error_file("resources/crypto.txt");
            MudgeSanity.debugJava();
            SecretKey secretKey = this.getKey(string);
            if (secretKey != null) {
                CommonUtils.print_info("Key's algorithm is: '" + secretKey.getAlgorithm() + "' ivspec is: " + this.ivspec);
            }
        }
        catch (Exception exception) {
            MudgeSanity.logException("encrypt failure for: " + string, exception, false);
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(String string, byte[] byArray) {
        try {
            if (!this.isReady(string)) {
                CommonUtils.print_error("decrypt: No session for '" + string + "'");
                return new byte[0];
            }
            _A _A2 = this.getSession(string);
            SecretKey secretKey = this.getKey(string);
            SecretKey secretKey2 = this.getHashKey(string);
            byte[] byArray2 = Arrays.copyOfRange(byArray, 0, byArray.length - 16);
            byte[] byArray3 = Arrays.copyOfRange(byArray, byArray.length - 16, byArray.length);
            byte[] byArray4 = null;
            Object object = this.mac;
            synchronized (object) {
                this.mac.init(secretKey2);
                byArray4 = this.mac.doFinal(byArray2);
            }
            object = Arrays.copyOfRange(byArray4, 0, 16);
            if (!MessageDigest.isEqual(byArray3, (byte[])object)) {
                CommonUtils.print_error("[Session Security] Bad HMAC on " + byArray.length + " byte message from Beacon " + string);
                return new byte[0];
            }
            byte[] byArray5 = null;
            Object object2 = this.out;
            synchronized (object2) {
                byArray5 = this.do_decrypt(secretKey, byArray2);
            }
            object2 = new DataInputStream(new ByteArrayInputStream(byArray5));
            int n = ((DataInputStream)object2).readInt();
            if ((long)n <= _A2.A) {
                CommonUtils.print_error("[Session Security] Bad counter (replay attack?, duplicate message?) " + n + " <= " + _A2.A + " message from Beacon " + string);
                return new byte[0];
            }
            int n2 = ((DataInputStream)object2).readInt();
            if (n2 < 0 || n2 > byArray.length) {
                CommonUtils.print_error("[Session Security] Impossible message length: " + n2 + " from Beacon " + string);
                return new byte[0];
            }
            byte[] byArray6 = new byte[n2];
            ((DataInputStream)object2).readFully(byArray6, 0, n2);
            _A2.A = n;
            return byArray6;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new byte[0];
        }
    }

    public static void main(String[] stringArray) {
        QuickSecurity quickSecurity = new QuickSecurity();
        quickSecurity.registerKey("1234", CommonUtils.randomData(16));
        String string = "This is a test string, I want to see what happens.";
        byte[] byArray = CommonUtils.toBytes(string);
        byte[] byArray2 = quickSecurity.encrypt("1234", byArray);
        byte[] byArray3 = quickSecurity.decrypt("1234", byArray2);
        CommonUtils.print_info("Cipher [H]:  " + CommonUtils.toHexString(byArray2));
        CommonUtils.print_info("Plain  [H]:  " + CommonUtils.toHexString(byArray3));
        CommonUtils.print_info("Cipher:      " + CommonUtils.bString(byArray2).replaceAll("\\P{Print}", "."));
        CommonUtils.print_info("Plain:       " + CommonUtils.bString(byArray3));
        CommonUtils.print_info("[Cipher]:    " + byArray2.length);
        CommonUtils.print_info("[Plain]:     " + byArray3.length);
        System.out.println("SCHEME" + quickSecurity.getCryptoScheme());
    }

    protected abstract byte[] do_encrypt(SecretKey var1, byte[] var2) throws Exception;

    protected abstract byte[] do_decrypt(SecretKey var1, byte[] var2) throws Exception;

    private static class _A {
        public SecretKey C = null;
        public SecretKey B = null;
        public long A = 0L;

        private _A() {
        }
    }
}

